/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.base.ClassObjectType;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateImpl;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.facttemplates.FieldTemplate;
import org.drools.facttemplates.FieldTemplateImpl;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class PatternTest
extends TestCase {
    public void testDeclarationsObjectType() throws Exception {
        ClassObjectType type = new ClassObjectType(Cheese.class);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        InternalReadAccessor ext = dec.getExtractor();
        PatternTest.assertEquals(Cheese.class, (Object)ext.getExtractToClass());
        Cheese stilton = new Cheese("stilton", 42);
        PatternTest.assertEquals((Object)stilton, (Object)dec.getValue(null, (Object)stilton));
    }

    public void testDeclarationsFactTemplate() throws Exception {
        Package pkg = new Package("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateObjectType type = new FactTemplateObjectType((FactTemplate)cheese);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        InternalReadAccessor ext = dec.getExtractor();
        PatternTest.assertEquals(Fact.class, (Object)ext.getExtractToClass());
        Fact stilton = cheese.createFact(10L);
        stilton.setFieldValue("name", (Object)"stilton");
        stilton.setFieldValue("price", (Object)new Integer(200));
        PatternTest.assertEquals((Object)stilton, (Object)dec.getValue(null, (Object)stilton));
    }
}

