/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.drools.ClockType;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.TimerService;
import org.drools.time.TimerServiceFactory;
import org.drools.time.Trigger;
import org.drools.time.impl.CronTrigger;
import org.drools.time.impl.JDKTimerServiceTest;
import org.drools.time.impl.PseudoClockScheduler;

public class CronJobTest
extends TestCase {
    public void testCronTriggerJob() throws Exception {
        PseudoClockScheduler timeService = (PseudoClockScheduler)TimerServiceFactory.getTimerService((ClockType)ClockType.PSEUDO_CLOCK);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        System.out.println("current time " + date);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        CronTrigger trigger = new CronTrigger(date.getTime(), null, null, -1, "15 * * * * ?", null, null);
        JDKTimerServiceTest.HelloWorldJobContext ctx = new JDKTimerServiceTest.HelloWorldJobContext("hello world", (TimerService)timeService);
        timeService.scheduleJob((Job)new JDKTimerServiceTest.HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        CronJobTest.assertEquals((int)0, (int)ctx.getList().size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        CronJobTest.assertEquals((int)0, (int)ctx.getList().size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        CronJobTest.assertEquals((int)1, (int)ctx.getList().size());
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        CronJobTest.assertEquals((int)1, (int)ctx.getList().size());
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        CronJobTest.assertEquals((int)2, (int)ctx.getList().size());
    }
}

