/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.text.ParseException;
import java.util.Set;
import junit.framework.TestCase;
import org.drools.time.impl.TestCronExpression;

public class Quartz601Test
extends TestCase {
    public void testNormal() {
        for (int i = 0; i < 6; ++i) {
            this.assertParsesForField("0 15 10 * * ? 2005", i);
        }
    }

    public void testSecond() {
        this.assertParsesForField("58-4 5 21 ? * MON-FRI", 0);
    }

    public void testMinute() {
        this.assertParsesForField("0 58-4 21 ? * MON-FRI", 1);
    }

    public void testHour() {
        this.assertParsesForField("0 0/5 21-3 ? * MON-FRI", 2);
    }

    public void testDayOfWeekNumber() {
        this.assertParsesForField("58 5 21 ? * 6-2", 5);
    }

    public void testDayOfWeek() {
        this.assertParsesForField("58 5 21 ? * FRI-TUE", 5);
    }

    public void testDayOfMonth() {
        this.assertParsesForField("58 5 21 28-5 1 ?", 3);
    }

    public void testMonth() {
        this.assertParsesForField("58 5 21 ? 11-2 FRI", 4);
    }

    public void testAmbiguous() {
        System.err.println(this.assertParsesForField("0 0 14-6 ? * FRI-MON", 2));
        System.err.println(this.assertParsesForField("0 0 14-6 ? * FRI-MON", 5));
        System.err.println(this.assertParsesForField("55-3 56-2 6 ? * FRI", 0));
        System.err.println(this.assertParsesForField("55-3 56-2 6 ? * FRI", 1));
    }

    private Set assertParsesForField(String expression, int constant) {
        try {
            TestCronExpression cronExpression = new TestCronExpression(expression);
            Set set = cronExpression.getSetPublic(constant);
            if (set.size() == 0) {
                Quartz601Test.fail((String)("Empty field [" + constant + "] returned for " + expression));
            }
            return set;
        }
        catch (ParseException pe) {
            Quartz601Test.fail((String)("Exception thrown during parsing: " + pe));
            return null;
        }
    }
}

