/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import junit.framework.TestCase;
import org.drools.core.util.ClassUtils;

public class ClassUtilsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCanonicalNameSimpleClass() {
        String name = ClassUtils.canonicalName(ClassUtilsTest.class);
        ClassUtilsTest.assertEquals((String)"org.drools.util.ClassUtilsTest", (String)name);
    }

    public void testCanonicalNameInnerClass() {
        String name = ClassUtils.canonicalName(A.class);
        ClassUtilsTest.assertEquals((String)"org.drools.util.ClassUtilsTest.A", (String)name);
    }

    public void testCanonicalNameInnerInnerClass() {
        String name = ClassUtils.canonicalName(A.B.class);
        ClassUtilsTest.assertEquals((String)"org.drools.util.ClassUtilsTest.A.B", (String)name);
    }

    public void testCanonicalNameArray() {
        String name = ClassUtils.canonicalName(Object[].class);
        ClassUtilsTest.assertEquals((String)"java.lang.Object[]", (String)name);
    }

    public void testCanonicalNameMultiIndexArray() {
        String name = ClassUtils.canonicalName(Object[][][].class);
        ClassUtilsTest.assertEquals((String)"java.lang.Object[][][]", (String)name);
    }

    public void testCanonicalNameMultiIndexArrayInnerClass() {
        String name = ClassUtils.canonicalName(A.B[][][].class);
        ClassUtilsTest.assertEquals((String)"org.drools.util.ClassUtilsTest.A.B[][][]", (String)name);
    }

    public void testCanonicalNameMultiIndexArrayPrimitives() {
        String name = ClassUtils.canonicalName(long[][][].class);
        ClassUtilsTest.assertEquals((String)"long[][][]", (String)name);
    }

    public static class A {

        public static class B {
        }
    }
}

