/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeNotifier;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceFactoryService;
import org.drools.io.impl.ByteArrayResource;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.FileSystemResource;
import org.drools.io.impl.InputStreamResource;
import org.drools.io.impl.ReaderResource;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.io.impl.UrlResource;

public class ResourceFactoryServiceImpl
implements ResourceFactoryService {
    private ResourceChangeNotifier notifier;
    private ResourceChangeScanner scanner;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceChangeNotifier getResourceChangeNotifierService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.notifier == null) {
                this.notifier = new ResourceChangeNotifierImpl();
            }
            return this.notifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceChangeScanner getResourceChangeScannerService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scanner == null) {
                this.scanner = new ResourceChangeScannerImpl();
            }
            return this.scanner;
        }
    }

    public Resource newByteArrayResource(byte[] bytes) {
        return new ByteArrayResource(bytes);
    }

    public Resource newClassPathResource(String path) {
        return new ClassPathResource(path);
    }

    public Resource newClassPathResource(String path, ClassLoader classLoader) {
        return new ClassPathResource(path, classLoader);
    }

    public Resource newClassPathResource(String path, Class clazz) {
        return new ClassPathResource(path, clazz);
    }

    public Resource newFileSystemResource(File file) {
        return new FileSystemResource(file);
    }

    public Resource newFileSystemResource(String fileName) {
        return new FileSystemResource(fileName);
    }

    public Resource newInputStreamResource(InputStream stream) {
        return new InputStreamResource(stream);
    }

    public Resource newReaderResource(Reader reader) {
        return new ReaderResource(reader);
    }

    public Resource newReaderResource(Reader reader, String encoding) {
        return new ReaderResource(reader, encoding);
    }

    public Resource newUrlResource(URL url) {
        return new UrlResource(url);
    }

    public Resource newUrlResource(String path) {
        return new UrlResource(path);
    }
}

