/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProcessInstanceMarshaller;
import org.drools.process.core.Context;
import org.drools.process.core.Process;
import org.drools.process.instance.ContextInstance;
import org.drools.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.drools.workflow.instance.node.CompositeContextNodeInstance;
import org.drools.workflow.instance.node.DynamicNodeInstance;
import org.drools.workflow.instance.node.EventNodeInstance;
import org.drools.workflow.instance.node.ForEachNodeInstance;
import org.drools.workflow.instance.node.HumanTaskNodeInstance;
import org.drools.workflow.instance.node.JoinInstance;
import org.drools.workflow.instance.node.MilestoneNodeInstance;
import org.drools.workflow.instance.node.RuleSetNodeInstance;
import org.drools.workflow.instance.node.StateBasedNodeInstance;
import org.drools.workflow.instance.node.StateNodeInstance;
import org.drools.workflow.instance.node.SubProcessNodeInstance;
import org.drools.workflow.instance.node.TimerNodeInstance;
import org.drools.workflow.instance.node.WorkItemNodeInstance;

public abstract class AbstractProcessInstanceMarshaller
implements ProcessInstanceMarshaller {
    public void writeProcessInstance(MarshallerWriteContext context, ProcessInstance processInstance) throws IOException {
        this.writeProcessInstance(context, processInstance, true);
    }

    public void writeProcessInstance(MarshallerWriteContext context, ProcessInstance processInstance, boolean includeVariables) throws IOException {
        SwimlaneContextInstance swimlaneContextInstance;
        WorkflowProcessInstanceImpl workFlow = (WorkflowProcessInstanceImpl)processInstance;
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workFlow.getId());
        stream.writeUTF(workFlow.getProcessId());
        stream.writeInt(workFlow.getState());
        stream.writeLong(workFlow.getNodeInstanceCounter());
        if (includeVariables) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
            Map<String, Object> variables = variableScopeInstance.getVariables();
            ArrayList<String> keys = new ArrayList<String>(variables.keySet());
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            stream.writeInt(keys.size());
            for (String key : keys) {
                stream.writeUTF(key);
                stream.writeObject(variables.get(key));
            }
        }
        if ((swimlaneContextInstance = (SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope")) != null) {
            Map<String, String> swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
            stream.writeInt(swimlaneActors.size());
            for (Map.Entry<String, String> entry : swimlaneActors.entrySet()) {
                stream.writeUTF(entry.getKey());
                stream.writeUTF(entry.getValue());
            }
        } else {
            stream.writeInt(0);
        }
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(workFlow.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (NodeInstance nodeInstance : nodeInstances) {
            stream.writeShort(18);
            this.writeNodeInstance(context, nodeInstance);
        }
        stream.writeShort(1);
        List<ContextInstance> exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        if (exclusiveGroupInstances == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(exclusiveGroupInstances.size());
            for (ContextInstance contextInstance : exclusiveGroupInstances) {
                ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                stream.writeInt(groupNodeInstances.size());
                for (NodeInstance nodeInstance : groupNodeInstances) {
                    stream.writeLong(nodeInstance.getId());
                }
            }
        }
    }

    public void writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(nodeInstance.getId());
        stream.writeLong(nodeInstance.getNodeId());
        this.writeNodeInstanceContent(stream, nodeInstance, context);
    }

    protected void writeNodeInstanceContent(ObjectOutputStream stream, NodeInstance nodeInstance, MarshallerWriteContext context) throws IOException {
        if (nodeInstance instanceof RuleSetNodeInstance) {
            stream.writeShort(20);
            List<Long> timerInstances = ((RuleSetNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            stream.writeShort(27);
            stream.writeLong(((HumanTaskNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((HumanTaskNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            stream.writeShort(21);
            stream.writeLong(((WorkItemNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((WorkItemNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            stream.writeShort(22);
            stream.writeLong(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
            List<Long> timerInstances = ((SubProcessNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            stream.writeShort(23);
            List<Long> timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof EventNodeInstance) {
            stream.writeShort(32);
        } else if (nodeInstance instanceof TimerNodeInstance) {
            stream.writeShort(24);
            stream.writeLong(((TimerNodeInstance)nodeInstance).getTimerId());
        } else if (nodeInstance instanceof JoinInstance) {
            stream.writeShort(25);
            Map<Long, Integer> triggers = ((JoinInstance)nodeInstance).getTriggers();
            stream.writeInt(triggers.size());
            ArrayList<Long> keys = new ArrayList<Long>(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                stream.writeLong(key);
                stream.writeInt(triggers.get(key));
            }
        } else if (nodeInstance instanceof StateNodeInstance) {
            stream.writeShort(30);
            List<Long> timerInstances = ((StateNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            if (nodeInstance instanceof DynamicNodeInstance) {
                stream.writeShort(31);
            } else {
                stream.writeShort(26);
            }
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            List<Long> timerInstances = ((CompositeContextNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope");
            if (variableScopeInstance == null) {
                stream.writeInt(0);
            } else {
                Map<String, Object> variables = variableScopeInstance.getVariables();
                ArrayList<String> keys = new ArrayList<String>(variables.keySet());
                Collections.sort(keys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                stream.writeInt(keys.size());
                for (String key : keys) {
                    stream.writeUTF(key);
                    stream.writeObject(variables.get(key));
                }
            }
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
            List<ContextInstance> exclusiveGroupInstances = compositeNodeInstance.getContextInstances("ExclusiveGroup");
            if (exclusiveGroupInstances == null) {
                stream.writeInt(0);
            } else {
                stream.writeInt(exclusiveGroupInstances.size());
                for (ContextInstance contextInstance : exclusiveGroupInstances) {
                    ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                    Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                    stream.writeInt(groupNodeInstances.size());
                    for (NodeInstance groupNodeInstance : groupNodeInstances) {
                        stream.writeLong(groupNodeInstance.getId());
                    }
                }
            }
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            stream.writeShort(28);
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
    }

    public ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        return this.readProcessInstance(context, true);
    }

    public ProcessInstance readProcessInstance(MarshallerReaderContext context, boolean includeVariables) throws IOException {
        int nbSwimlanes;
        Object value;
        String name;
        int i;
        int nbVariables;
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        WorkflowProcessInstanceImpl processInstance = this.createProcessInstance();
        processInstance.setId(stream.readLong());
        String processId = stream.readUTF();
        processInstance.setProcessId(processId);
        Process process = ruleBase.getProcess(processId);
        if (ruleBase != null) {
            processInstance.setProcess(process);
        }
        processInstance.setState(stream.readInt());
        long nodeInstanceCounter = stream.readLong();
        processInstance.setWorkingMemory(wm);
        if (includeVariables && (nbVariables = stream.readInt()) > 0) {
            Context variableScope = process.getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance(variableScope);
            for (i = 0; i < nbVariables; ++i) {
                name = stream.readUTF();
                try {
                    value = stream.readObject();
                    variableScopeInstance.setVariable(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        if ((nbSwimlanes = stream.readInt()) > 0) {
            Context swimlaneContext = process.getDefaultContext("SwimlaneScope");
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance(swimlaneContext);
            for (i = 0; i < nbSwimlanes; ++i) {
                name = stream.readUTF();
                value = stream.readUTF();
                swimlaneContextInstance.setActorId(name, (String)value);
            }
        }
        while (stream.readShort() == 18) {
            this.readNodeInstance(context, processInstance, processInstance);
        }
        int exclusiveGroupInstances = stream.readInt();
        for (int i2 = 0; i2 < exclusiveGroupInstances; ++i2) {
            ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
            processInstance.addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
            int nodeInstances = stream.readInt();
            for (int j = 0; j < nodeInstances; ++j) {
                long nodeInstanceId = stream.readLong();
                org.drools.workflow.instance.NodeInstance nodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                if (nodeInstance == null) {
                    throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                }
                exclusiveGroupInstance.addNodeInstance(nodeInstance);
            }
        }
        processInstance.internalSetNodeInstanceCounter(nodeInstanceCounter);
        if (wm != null) {
            processInstance.reconnect();
        }
        return processInstance;
    }

    protected abstract WorkflowProcessInstanceImpl createProcessInstance();

    public NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, WorkflowProcessInstance processInstance) throws IOException {
        MarshallerReaderContext stream = context.stream;
        long id = stream.readLong();
        long nodeId = stream.readLong();
        short nodeType = stream.readShort();
        NodeInstanceImpl nodeInstance = this.readNodeInstanceContent(nodeType, stream, context, processInstance);
        nodeInstance.setNodeId(nodeId);
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance(processInstance);
        nodeInstance.setId(id);
        switch (nodeType) {
            case 26: 
            case 31: {
                int nbVariables = stream.readInt();
                if (nbVariables > 0) {
                    Context variableScope = ((Process)processInstance.getProcess()).getDefaultContext("VariableScope");
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance(variableScope);
                    for (int i = 0; i < nbVariables; ++i) {
                        String name = stream.readUTF();
                        try {
                            Object value = stream.readObject();
                            variableScopeInstance.setVariable(name, value);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + name);
                        }
                    }
                }
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (CompositeContextNodeInstance)nodeInstance, processInstance);
                }
                int exclusiveGroupInstances = stream.readInt();
                for (int i = 0; i < exclusiveGroupInstances; ++i) {
                    ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
                    processInstance.addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
                    int nodeInstances = stream.readInt();
                    for (int j = 0; j < nodeInstances; ++j) {
                        long nodeInstanceId = stream.readLong();
                        NodeInstance groupNodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                        if (groupNodeInstance == null) {
                            throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                        }
                        exclusiveGroupInstance.addNodeInstance(groupNodeInstance);
                    }
                }
                break;
            }
            case 28: {
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (ForEachNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    protected NodeInstanceImpl readNodeInstanceContent(int nodeType, ObjectInputStream stream, MarshallerReaderContext context, WorkflowProcessInstance processInstance) throws IOException {
        NodeInstanceImpl nodeInstance = null;
        switch (nodeType) {
            case 20: {
                nodeInstance = new RuleSetNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((StateBasedNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 27: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(stream.readLong());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((HumanTaskNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 21: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(stream.readLong());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((WorkItemNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 22: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(stream.readLong());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((SubProcessNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 23: {
                nodeInstance = new MilestoneNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 24: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(stream.readLong());
                break;
            }
            case 32: {
                nodeInstance = new EventNodeInstance();
                break;
            }
            case 25: {
                nodeInstance = new JoinInstance();
                int number = stream.readInt();
                if (number <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (int i = 0; i < number; ++i) {
                    long l = stream.readLong();
                    int count = stream.readInt();
                    triggers.put(l, count);
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case 26: {
                nodeInstance = new CompositeContextNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 28: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            case 31: {
                nodeInstance = new DynamicNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 30: {
                nodeInstance = new StateNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + nodeType);
            }
        }
        return nodeInstance;
    }
}

