/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.List;
import org.drools.base.DroolsQuery;
import org.drools.base.InternalViewChangedEventListener;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QueryElementFactHandle;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.QueryElement;
import org.drools.rule.Rule;
import org.drools.rule.Variable;
import org.drools.spi.PropagationContext;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode {
    private LeftTupleSource tupleSource;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private QueryElement queryElement;
    private boolean tupleMemoryEnabled;

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object[] arguments = this.queryElement.getArguments();
        Object[] inputArgs = new Object[arguments.length];
        System.arraycopy(arguments, 0, inputArgs, 0, inputArgs.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Declaration declr = (Declaration)arguments[declIndexes[i]];
            inputArgs[declIndexes[i]] = declr.getValue(workingMemory, leftTuple.get(declr).getObject());
        }
        UnificationNodeViewChangedEventListener collector = new UnificationNodeViewChangedEventListener(leftTuple, this.queryElement.getVariables(), this.sink, this.tupleMemoryEnabled);
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), inputArgs, collector, false);
        collector.setDroolsQuery(queryObject);
        InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(queryObject, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, queryObject), workingMemory, null);
        workingMemory.insert(handle, queryObject, null, null, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(workingMemory.getEntryPoint(), queryObject));
        workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        LeftTuple temp = null;
        for (LeftTuple childLeftTuple = leftTuple.firstChild; childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
            temp = childLeftTuple;
            this.sink.doPropagateAssertLeftTuple(context, workingMemory, childLeftTuple, childLeftTuple.getLeftTupleSink());
            temp.setLeftParentNext(null);
        }
        leftTuple.firstChild = null;
    }

    public short getType() {
        return 11;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        private LeftTuple leftTuple;
        protected LeftTupleSinkPropagator sink;
        private DroolsQuery query;
        private int[] variables;
        private boolean tupleMemoryEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, LeftTupleSinkPropagator sink, boolean tupleMemoryEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.sink = sink;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
        }

        public void setDroolsQuery(DroolsQuery query) {
            this.query = query;
        }

        @Override
        public void rowAdded(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            Object[] args = this.query.getElements();
            Object[] objects = new Object[this.variables.length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                objects[i] = ((Variable)args[this.variables[i]]).getValue();
            }
            QueryElementFactHandle handle = new QueryElementFactHandle(objects);
            RightTuple rightTuple = new RightTuple(handle);
            this.sink.createChildLeftTuplesforQuery(this.leftTuple, rightTuple, this.tupleMemoryEnabled);
        }

        @Override
        public void rowRemoved(Rule rule, LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        @Override
        public void rowUpdated(Rule rule, LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        @Override
        public List<? extends Object> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }
    }
}

