/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.QueryResults;
import org.drools.SessionConfiguration;
import org.drools.base.DroolsQuery;
import org.drools.base.InternalViewChangedEventListener;
import org.drools.base.NonCloningQueryViewListener;
import org.drools.base.StandardQueryViewChangedEventListener;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.DefaultAgenda;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.event.AgendaEventSupport;
import org.drools.event.RuleFlowEventSupport;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.impl.EnvironmentFactory;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.Environment;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.impl.LiveQueryImpl;
import org.drools.runtime.rule.impl.OpenQueryViewChangedEventListenerAdapter;
import org.drools.spi.FactHandleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteooWorkingMemory
extends AbstractWorkingMemory {
    private static final long serialVersionUID = 510L;

    public ReteooWorkingMemory() {
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase) {
        this(id, ruleBase, new SessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase, SessionConfiguration config, Environment environment) {
        super(id, ruleBase, ruleBase.newFactHandleFactory(), config, environment);
        this.agenda = new DefaultAgenda(ruleBase);
        this.agenda.setWorkingMemory(this);
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase, SessionConfiguration config, Environment environment, WorkingMemoryEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport, RuleFlowEventSupport ruleFlowEventSupport) {
        super(id, ruleBase, ruleBase.newFactHandleFactory(), config, environment, workingMemoryEventSupport, agendaEventSupport, ruleFlowEventSupport);
        this.agenda = new DefaultAgenda(ruleBase);
        this.agenda.setWorkingMemory(this);
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        super(id, ruleBase, handleFactory, initialFactHandle, propagationContext, config, environment);
        this.agenda = agenda;
        this.agenda.setWorkingMemory(this);
    }

    @Override
    public QueryResults getQueryResults(String query) {
        return this.getQueryResults(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResults getQueryResults(String query, Object[] arguments) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            DroolsQuery queryObject = new DroolsQuery(query, arguments, this.getQueryListenerInstance(), false);
            ObjectTypeConf objectTypeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, queryObject);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, objectTypeConf, this, this);
            this.insert(handle, queryObject, null, null, objectTypeConf);
            this.handleFactory.destroyFactHandle(handle);
            Declaration[] declarations = new Declaration[]{};
            if (queryObject.getQuery() != null) {
                declarations = queryObject.getQuery().getDeclarations();
            }
            QueryResults queryResults = new QueryResults(queryObject.getQueryResultCollector().getResults(), declarations, this);
            return queryResults;
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    private InternalViewChangedEventListener getQueryListenerInstance() {
        switch (this.config.getQueryListenerOption()) {
            case STANDARD: {
                return new StandardQueryViewChangedEventListener();
            }
            case LIGHTWEIGHT: {
                return new NonCloningQueryViewListener();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            DroolsQuery queryObject = new DroolsQuery(query, arguments, new OpenQueryViewChangedEventListenerAdapter(listener), true);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, this.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, queryObject), this, this);
            this.insert(handle, queryObject, null, null, this.typeConfReg.getObjectTypeConf(this.entryPoint, queryObject));
            LiveQueryImpl liveQueryImpl = new LiveQueryImpl(this, handle);
            return liveQueryImpl;
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLiveQuery(InternalFactHandle factHandle) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            this.getEntryPointNode().retractObject(factHandle, null, this.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.getEntryPoint(), factHandle.getObject()), this);
            this.getFactHandleFactory().destroyFactHandle(factHandle);
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this;
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public Collection<Object> getObjects() {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public static class WorkingMemoryReteExpireAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private ObjectTypeNode node;

        public WorkingMemoryReteExpireAction(InternalFactHandle factHandle, ObjectTypeNode node) {
            this.factHandle = factHandle;
            this.node = node;
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            int nodeId = context.readInt();
            this.node = (ObjectTypeNode)context.sinks.get(nodeId);
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(5);
            context.writeInt(this.factHandle.getId());
            context.writeInt(this.node.getId());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.factHandle = (InternalFactHandle)in.readObject();
            this.node = (ObjectTypeNode)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.factHandle);
            out.writeObject(this.node);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.factHandle.isValid()) {
                PropagationContextImpl context = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, this.factHandle);
                ((EventFactHandle)this.factHandle).setExpired(true);
                this.node.retractObject(this.factHandle, context, workingMemory);
                if (((EventFactHandle)this.factHandle).getActivationsCount() == 0L) {
                    ((EventFactHandle)this.factHandle).getEntryPoint().retract((FactHandle)this.factHandle);
                }
            }
        }
    }

    public static class WorkingMemoryReteAssertAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private boolean removeLogical;
        private boolean updateEqualsMap;
        private Rule ruleOrigin;
        private LeftTuple leftTuple;

        public WorkingMemoryReteAssertAction(InternalFactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule ruleOrigin, LeftTuple leftTuple) {
            this.factHandle = factHandle;
            this.removeLogical = removeLogical;
            this.updateEqualsMap = updateEqualsMap;
            this.ruleOrigin = ruleOrigin;
            this.leftTuple = leftTuple;
        }

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            this.removeLogical = context.readBoolean();
            this.updateEqualsMap = context.readBoolean();
            if (context.readBoolean()) {
                String pkgName = context.readUTF();
                String ruleName = context.readUTF();
                Package pkg = context.ruleBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
            }
            if (context.readBoolean()) {
                this.leftTuple = context.terminalTupleMap.get(context.readInt());
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(1);
            context.writeInt(this.factHandle.getId());
            context.writeBoolean(this.removeLogical);
            context.writeBoolean(this.updateEqualsMap);
            if (this.ruleOrigin != null) {
                context.writeBoolean(true);
                context.writeUTF(this.ruleOrigin.getPackage());
                context.writeUTF(this.ruleOrigin.getName());
            } else {
                context.writeBoolean(false);
            }
            if (this.leftTuple != null) {
                context.writeBoolean(true);
                context.writeInt(context.terminalTupleMap.get(this.leftTuple));
            } else {
                context.writeBoolean(false);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.factHandle = (InternalFactHandle)in.readObject();
            this.removeLogical = in.readBoolean();
            this.updateEqualsMap = in.readBoolean();
            this.ruleOrigin = (Rule)in.readObject();
            this.leftTuple = (LeftTuple)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.factHandle);
            out.writeBoolean(this.removeLogical);
            out.writeBoolean(this.updateEqualsMap);
            out.writeObject(this.ruleOrigin);
            out.writeObject(this.leftTuple);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            PropagationContextImpl context = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 0, this.ruleOrigin, this.leftTuple, this.factHandle);
            ReteooRuleBase ruleBase = (ReteooRuleBase)workingMemory.getRuleBase();
            ruleBase.assertObject(this.factHandle, this.factHandle.getObject(), context, workingMemory);
        }
    }
}

