/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.DroolsClassLoader;

public class MapBackedClassLoader
extends ClassLoader
implements DroolsClassLoader {
    private static final long serialVersionUID = 510L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return MapBackedClassLoader.class.getProtectionDomain();
        }
    });
    private Map<String, byte[]> store;

    public MapBackedClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.store = new HashMap<String, byte[]>();
    }

    public MapBackedClassLoader(ClassLoader parentClassLoader, Map store) {
        super(parentClassLoader);
        this.store = store;
    }

    public void addResource(String className, byte[] bytes) {
        this.addClass(className, bytes);
    }

    private String convertResourcePathToClassName(String pName) {
        return pName.replaceAll(".java$|.class$", "").replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(String className, byte[] bytes) {
        Map<String, byte[]> map = this.store;
        synchronized (map) {
            this.store.put(this.convertResourcePathToClassName(className), bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class fastFindClass(String name) {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            byte[] clazzBytes;
            Map<String, byte[]> map = this.store;
            synchronized (map) {
                clazzBytes = this.store.get(name);
            }
            if (clazzBytes != null) {
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
            }
        }
        return clazz;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader parent;
        Class<?> clazz = this.fastFindClass(name);
        if (clazz == null && (parent = this.getParent()) != null) {
            clazz = Class.forName(name, true, parent);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.fastFindClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = null;
        Map<String, byte[]> map = this.store;
        synchronized (map) {
            bytes = this.store.get(this.convertResourcePathToClassName(name));
        }
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        InputStream input = this.getParent().getResourceAsStream(name);
        if (input == null) {
            input = super.getResourceAsStream(name);
        }
        return input;
    }

    public Map getStore() {
        return this.store;
    }
}

