/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Properties;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.IHttpClient;
import org.drools.agent.LastUpdatedPing;
import org.drools.agent.MockListener;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.agent.URLScanner;
import org.drools.common.DroolsObjectInputStream;
import org.drools.definition.KnowledgePackage;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class URLScannerTest {
    @Test
    public void testFileURLCache() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        String url = "http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST";
        String fileName = URLEncoder.encode(url, "UTF-8");
        File f = new File(dir, fileName);
        Package p = new Package("x");
        RuleBaseAssemblerTest.writePackage(p, f);
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new FileInputStream(f));
        Package p_ = (Package)in.readObject();
        in.close();
        Assert.assertEquals((Object)"x", (Object)p_.getName());
    }

    @Test
    public void testFileURLCacheWithKnowledgePackage() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        String url = "http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST";
        String fileName = URLEncoder.encode(url, "UTF-8");
        File f = new File(dir, fileName);
        KnowledgePackageImp kpackage = new KnowledgePackageImp(new Package("x"));
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage, f);
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new FileInputStream(f));
        KnowledgePackage p_ = (KnowledgePackage)in.readObject();
        in.close();
        Assert.assertEquals((Object)"x", (Object)p_.getName());
    }

    @Test
    public void testGetFiles() throws Exception {
        URL u1 = new URL("http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST");
        URL u2 = new URL("http://localhost:8080/foo/bar.bar/packages/IMINYRURL/PROD");
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        File[] result = scan.getFiles(new URL[]{u1, u2}, dir);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)dir.getPath(), (Object)result[0].getParent());
        File f1 = result[0];
        File f2 = result[1];
        Assert.assertEquals((Object)"http%3A%2F%2Flocalhost%3A8080%2Ffoo%2Fbar.bar%2Fpackages%2FIMINYRURL%2FLATEST.pkg", (Object)f1.getName());
        Assert.assertEquals((Object)"http%3A%2F%2Flocalhost%3A8080%2Ffoo%2Fbar.bar%2Fpackages%2FIMINYRURL%2FPROD.pkg", (Object)f2.getName());
    }

    @Test
    public void testConfig() throws Exception {
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        Assert.assertNotNull((Object)scan.lastUpdated);
        Assert.assertEquals((long)2L, (long)scan.urls.length);
        Assert.assertEquals((Object)"http://goo.ber", (Object)scan.urls[0].toExternalForm());
        Assert.assertEquals((Object)"http://wee.waa", (Object)scan.urls[1].toExternalForm());
        Assert.assertNotNull((Object)scan.localCacheFileScanner);
        Assert.assertEquals((long)2L, (long)scan.localCacheFileScanner.files.length);
        Assert.assertEquals((Object)"http%3A%2F%2Fgoo.ber.pkg", (Object)scan.localCacheFileScanner.files[0].getName());
        Assert.assertEquals((Object)"http%3A%2F%2Fwee.waa.pkg", (Object)scan.localCacheFileScanner.files[1].getName());
    }

    @Test
    public void testLastUpdatedError() {
        LastUpdatedPing ping = new LastUpdatedPing();
        Assert.assertTrue((boolean)ping.isError());
        ping.responseMessage = "ABC";
        ping.lastUpdated = 42L;
        Assert.assertTrue((boolean)ping.isError());
        ping.responseMessage = "200 OK";
        Assert.assertFalse((boolean)ping.isError());
    }

    @Test
    public void testUpdateNoLocalCache() throws Exception {
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        int numfiles = dir.list().length;
        Properties config = new Properties();
        config.setProperty("url", "http://goo2.ber http://wee2.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 123L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url, boolean enableBasicAuthentication, String username, String password) throws IOException {
                if (url.toExternalForm().equals("http://goo2.ber")) {
                    return new Package("goo2.ber");
                }
                return new Package("wee2.waa");
            }
        };
        Assert.assertNull((Object)scan.localCacheFileScanner);
        Assert.assertNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        AgentEventListener list = this.getNilListener();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)false, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)list);
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        this.assertExists(new String[]{"goo2.ber", "wee2.waa"}, rb.getPackages());
        Assert.assertEquals((long)numfiles, (long)dir.list().length);
    }

    private AgentEventListener getNilListener() {
        return new MockListener();
    }

    private void assertExists(String[] names, Package[] packages) {
        for (int i = 0; i < packages.length; ++i) {
            String name = packages[i].getName();
            int matches = 0;
            for (int j = 0; j < names.length; ++j) {
                if (!name.equals(names[j])) continue;
                ++matches;
            }
            Assert.assertEquals((String)("Should only have one package named " + name), (long)1L, (long)matches);
        }
    }

    @Test
    public void testUpdateWithLocalCache() {
        URLScanner scan = new URLScanner();
        scan.listener = new MockListener();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 123L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url, boolean enableBasicAuthentication, String username, String password) throws IOException {
                if (url.toExternalForm().equals("http://goo.ber")) {
                    return new Package("goo.ber");
                }
                return new Package("wee.waa");
            }
        };
        Assert.assertNotNull((Object)scan.localCacheFileScanner);
        Assert.assertNotNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)false, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        Assert.assertTrue(("goo.ber".equals(rb.getPackages()[0].getName()) || "goo.ber".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        Assert.assertTrue(("wee.waa".equals(rb.getPackages()[0].getName()) || "wee.waa".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                if (url.toExternalForm().equals("http://wee.waa")) {
                    ping.lastUpdated = -1L;
                    ping.responseMessage = "XXX";
                } else {
                    ping.lastUpdated = 123L;
                    ping.responseMessage = "200 OK";
                }
                return ping;
            }

            public Package fetchPackage(URL url, boolean enableBasicAuthentication, String username, String password) throws IOException {
                throw new IOException("poo");
            }
        };
        rb = RuleBaseFactory.newRuleBase();
        Assert.assertEquals((long)0L, (long)rb.getPackages().length);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        final boolean[] fetchCalled = new boolean[]{false};
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 1234L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url, boolean enableBasicAuthentication, String username, String password) throws IOException {
                fetchCalled[0] = true;
                throw new IOException("poo");
            }
        };
        PackageChangeInfo changes = scan.loadPackageChanges();
        Assert.assertEquals((long)0L, (long)changes.getChangedPackages().size());
        Assert.assertEquals((Object)true, (Object)fetchCalled[0]);
        Assert.assertEquals((long)2L, (long)((MockListener)scan.listener).exceptions.size());
    }

    @Test
    public void testColdStartWithError() throws Exception {
        URLScanner scan = new URLScanner();
        scan.listener = new MockListener();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("goo.ber");
        Package p2 = new Package("wee.waa");
        File f1 = URLScanner.getLocalCacheFileForURL((File)dir, (URL)new URL("http://goo.ber"));
        File f2 = URLScanner.getLocalCacheFileForURL((File)dir, (URL)new URL("http://wee.waa"));
        RuleBaseAssemblerTest.writePackage(p1, f1);
        RuleBaseAssemblerTest.writePackage(p2, f2);
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                throw new IOException();
            }

            public Package fetchPackage(URL url, boolean enableBasicAuthentication, String username, String password) throws IOException {
                throw new IOException();
            }
        };
        Assert.assertNotNull((Object)scan.localCacheFileScanner);
        Assert.assertNotNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
    }
}

