/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.SingleBetaConstraints;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.VariableConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FromNodeTest {
    EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, new ReteooBuilder.IdGenerator());
    }

    @Test
    public void testAlphaNode() {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)this.ruleBase);
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"stilton");
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), field);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("cheddar", 20);
        Cheese cheese2 = new Cheese("brie", 20);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        FromNode from = new FromNode(3, (DataProvider)dataProvider, null, new AlphaNodeFieldConstraint[]{constraint}, null, true, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        Person person1 = new Person("xxx1", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person1Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        cheese1.setType("stilton");
        Person person2 = new Person("xxx2", 30);
        FactHandle person2Handle = workingMemory.insert((Object)person2);
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person2Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        Assert.assertEquals((long)1L, (long)asserted.size());
        Tuple tuple = (Tuple)((Object[])asserted.get(0))[0];
        Assert.assertSame((Object)person2, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese1, (Object)tuple.getFactHandles()[0].getObject());
        cheese2.setType("stilton");
        Person person3 = new Person("xxx2", 30);
        FactHandle person3Handle = workingMemory.insert((Object)person3);
        LeftTuple tuple3 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person3Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple3, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)asserted.size());
        tuple = (Tuple)((Object[])asserted.get(1))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese1, (Object)tuple.getFactHandles()[0].getObject());
        tuple = (Tuple)((Object[])asserted.get(2))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese2, (Object)tuple.getFactHandles()[0].getObject());
        Assert.assertNotSame((Object)cheese1, (Object)cheese2);
    }

    @Test
    public void testBetaNode() {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", this.getClass().getClassLoader());
        ClassFieldReader ageExtractor = this.store.getReader(Person.class, "age", this.getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Person.class));
        Declaration declaration = new Declaration("age", (InternalReadAccessor)ageExtractor, pattern);
        VariableConstraint variableConstraint = new VariableConstraint((InternalReadAccessor)priceExtractor, declaration, this.equals.getEvaluator(ValueType.PINTEGER_TYPE, Operator.EQUAL));
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        configuration.setIndexRightBetaMemory(false);
        configuration.setIndexLeftBetaMemory(false);
        SingleBetaConstraints betaConstraints = new SingleBetaConstraints((BetaNodeFieldConstraint)variableConstraint, configuration);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("cheddar", 18);
        Cheese cheese2 = new Cheese("brie", 12);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        FromNode from = new FromNode(3, (DataProvider)dataProvider, null, new AlphaNodeFieldConstraint[0], (BetaConstraints)betaConstraints, true, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        Person person1 = new Person("xxx1", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person1Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        cheese1.setPrice(30);
        Person person2 = new Person("xxx2", 30);
        FactHandle person2Handle = workingMemory.insert((Object)person2);
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person2Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        Assert.assertEquals((long)1L, (long)asserted.size());
        Tuple tuple = (Tuple)((Object[])asserted.get(0))[0];
        Assert.assertSame((Object)person2, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese1, (Object)tuple.getFactHandles()[0].getObject());
        cheese2.setPrice(30);
        Person person3 = new Person("xxx2", 30);
        FactHandle person3Handle = workingMemory.insert((Object)person3);
        LeftTuple tuple3 = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person3Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple3, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)asserted.size());
        tuple = (Tuple)((Object[])asserted.get(1))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese1, (Object)tuple.getFactHandles()[0].getObject());
        tuple = (Tuple)((Object[])asserted.get(2))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getFactHandles()[1].getObject());
        Assert.assertSame((Object)cheese2, (Object)tuple.getFactHandles()[0].getObject());
        Assert.assertNotSame((Object)cheese1, (Object)cheese2);
    }

    @Test
    public void testRestract() {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"stilton");
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), field);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("stilton", 5);
        Cheese cheese2 = new Cheese("stilton", 15);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        FromNode from = new FromNode(3, (DataProvider)dataProvider, null, new AlphaNodeFieldConstraint[]{constraint}, null, true, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        List asserted = sink.getAsserted();
        Person person1 = new Person("xxx2", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTuple tuple = new LeftTuple((InternalFactHandle)((DefaultFactHandle)person1Handle), (LeftTupleSink)from, true);
        from.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)asserted.size());
        FromNode.FromMemory memory = (FromNode.FromMemory)workingMemory.getNodeMemory((NodeMemory)from);
        Assert.assertEquals((long)1L, (long)memory.betaMemory.getLeftTupleMemory().size());
        Assert.assertNull((Object)memory.betaMemory.getRightTupleMemory());
        RightTuple rightTuple2 = tuple.firstChild.getRightParent();
        RightTuple rightTuple1 = tuple.firstChild.getLeftParentNext().getRightParent();
        Assert.assertFalse((boolean)rightTuple1.equals(rightTuple2));
        Assert.assertNull((Object)tuple.firstChild.getLeftParentNext().getLeftParentNext());
        InternalFactHandle handle2 = rightTuple2.getFactHandle();
        InternalFactHandle handle1 = rightTuple1.getFactHandle();
        Assert.assertEquals((Object)handle1.getObject(), (Object)cheese2);
        Assert.assertEquals((Object)handle2.getObject(), (Object)cheese1);
        from.retractLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)memory.betaMemory.getLeftTupleMemory().size());
        Assert.assertNull((Object)memory.betaMemory.getRightTupleMemory());
    }

    public static class Person {
        private String name;
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int getAge() {
            return this.age;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class MockDataProvider
    implements DataProvider {
        private static final long serialVersionUID = 510L;
        private Collection collection;

        public Declaration[] getRequiredDeclarations() {
            return null;
        }

        public MockDataProvider(Collection collection) {
            this.collection = collection;
        }

        public Iterator getResults(Tuple tuple, WorkingMemory wm, PropagationContext ctx, Object providerContext) {
            return this.collection.iterator();
        }

        public Object createContext() {
            return null;
        }

        public DataProvider clone() {
            return this;
        }

        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        }
    }
}

