/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.Agenda;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSink;
import org.drools.reteoo.MockRightTupleSink;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogicalAssertionTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach();
    }

    @Test
    public void testSingleLogicalRelationship() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockRightTupleSink sink = new MockRightTupleSink();
        Rule rule1 = new Rule("test-rule1");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = (DefaultFactHandle)workingMemory.insert((Object)"o1");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString = new String("logical");
        InternalFactHandle logicalHandle = (InternalFactHandle)workingMemory.insert((Object)logicalString, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Object[] values = (Object[])sink.getRetracted().get(0);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        logicalHandle = (InternalFactHandle)workingMemory.insert((Object)logicalString, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        agenda.fireNextItem(null);
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(2, sink.getRetracted());
        values = (Object[])sink.getRetracted().get(1);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
    }

    @Test
    public void testEqualsMap() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        logicalHandle1 = workingMemory.insert((Object)logicalString1);
        logicalHandle2 = workingMemory.insert((Object)logicalString2);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.ruleBase.getConfiguration().getAssertBehaviour())) {
            Assert.assertNotSame((Object)logicalHandle1, (Object)logicalHandle2);
        } else {
            Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        }
    }

    @Test
    public void testStatedOverrideDiscard() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2);
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        Assert.assertEquals((Object)logicalString1, (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        logicalString2 = new String("logical");
        logicalHandle2 = workingMemory.insert((Object)logicalString2);
        logicalString1 = new String("logical");
        logicalHandle1 = workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle1);
        logicalHandle1 = workingMemory.insert((Object)logicalString2, false, false, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        Assert.assertEquals((Object)logicalString1, (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
    }

    @Test
    public void testStatedOverridePreserve() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setLogicalOverride(RuleBaseConfiguration.LogicalOverride.PRESERVE);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)rete, buildContext);
        entryPoint.attach();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(String.class), buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2);
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getRetracted());
        Assert.assertNotSame((Object)logicalHandle2, (Object)logicalHandle1);
        Assert.assertEquals((Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle1), (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
        Assert.assertNotSame((Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle1), (Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)logicalHandle2));
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        logicalString2 = new String("logical");
        logicalHandle2 = workingMemory.insert((Object)logicalString2);
    }

    @Test
    public void testRetract() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(3), rule2, rule2.getLhs(), this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)handle2, null, true);
        node.assertLeftTuple(tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple(tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2, false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertEquals((long)1L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)logicalHandle2);
        Assert.assertEquals((long)0L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
    }

    @Test
    public void testMultipleLogicalRelationships() throws FactException {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockRightTupleSink sink = new MockRightTupleSink();
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule2, rule2.getLhs(), this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)handle2, null, true);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, null, null, null);
        node2.assertLeftTuple(tuple2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        InternalFactHandle logicalHandle1 = (InternalFactHandle)workingMemory.insert((Object)logicalString1, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle1, (RightTupleSink)sink);
        String logicalString2 = new String("logical");
        InternalFactHandle logicalHandle2 = (InternalFactHandle)workingMemory.insert((Object)logicalString2, false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        Assert.assertEquals((long)1L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
        node2.retractLeftTuple(tuple2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(0, sink.getRetracted());
        Assert.assertEquals((long)1L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
        node.retractLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Assert.assertEquals((long)0L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
    }

    @Test
    public void testMultipleAssert() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String statedString1 = new String("logical");
        FactHandle statedHandle1 = workingMemory.insert((Object)statedString1);
        String statedString2 = new String("logical");
        FactHandle statedHandle2 = workingMemory.insert((Object)statedString2);
        String logicalString3 = new String("logical");
        FactHandle logicalHandle3 = workingMemory.insert((Object)logicalString3, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle3);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.ruleBase.getConfiguration().getAssertBehaviour())) {
            workingMemory.retract((org.drools.runtime.rule.FactHandle)statedHandle2);
            logicalHandle3 = workingMemory.insert((Object)logicalString3, false, true, rule1, (Activation)tuple1.getObject());
            Assert.assertNull((Object)logicalHandle3);
        }
        workingMemory.retract((org.drools.runtime.rule.FactHandle)statedHandle1);
        logicalHandle3 = workingMemory.insert((Object)logicalString3, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNotNull((Object)logicalHandle3);
    }

    @Test
    public void testMutableObject() {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Cheese cheese = new Cheese("brie", 10);
        FactHandle cheeseHandle = workingMemory.insert((Object)cheese, false, true, rule1, (Activation)tuple1.getObject());
        cheese.setType("cheddar");
        cheese.setPrice(20);
        Assert.assertEquals((long)1L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
        Assert.assertEquals((long)1L, (long)workingMemory.getTruthMaintenanceSystem().getAssertMap().size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)cheeseHandle);
        Assert.assertEquals((long)0L, (long)workingMemory.getTruthMaintenanceSystem().getJustifiedMap().size());
        Assert.assertEquals((long)0L, (long)workingMemory.getTruthMaintenanceSystem().getAssertMap().size());
    }
}

