/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.drools.ClockType;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.EnabledBoolean;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Rule;
import org.drools.time.impl.PseudoClockScheduler;
import org.junit.Assert;
import org.junit.Test;

public class RuleTest {
    @Test
    public void testDateEffective() {
        StatefulSession wm = new ReteooRuleBase("x").newStatefulSession();
        Rule rule = new Rule("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateEffective(earlier);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        Assert.assertTrue((boolean)later.after(Calendar.getInstance()));
        rule.setDateEffective(later);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
    }

    @Test
    public void testDateExpires() throws Exception {
        StatefulSession wm = new ReteooRuleBase("x").newStatefulSession();
        Rule rule = new Rule("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateExpires(earlier);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        rule.setDateExpires(later);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
    }

    @Test
    public void testDateEffectiveExpires() {
        StatefulSession wm = new ReteooRuleBase("x").newStatefulSession();
        Rule rule = new Rule("myrule");
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(past);
        rule.setDateExpires(future);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
        rule.setDateExpires(past);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
        rule.setDateExpires(future);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
    }

    @Test
    public void testRuleEnabled() {
        StatefulSession wm = new ReteooRuleBase("x").newStatefulSession();
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        rule.setDateEffective(past);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
    }

    @Test
    public void testTimeMachine() {
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = new ReteooRuleBase("x").newStatefulSession(conf, null);
        Calendar future = Calendar.getInstance();
        ((PseudoClockScheduler)wm.getSessionClock()).setStartupTime(future.getTimeInMillis());
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, (WorkingMemory)wm));
        ((PseudoClockScheduler)wm.getSessionClock()).advanceTime(1000000000000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)rule.isEffective(null, (WorkingMemory)wm));
    }
}

