/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Collection;
import org.drools.core.util.PrimitiveLongMap;
import org.junit.Assert;
import org.junit.Test;

public class PrimitiveLongMapTest {
    @Test
    public void testValues() {
        PrimitiveLongMap map = new PrimitiveLongMap();
        Assert.assertNotNull((String)"MapNotNullTest ", (Object)map);
        Collection values = map.values();
        Assert.assertNotNull((String)"ValuesNotNullTest ", (Object)values);
        Assert.assertEquals((String)"ValuesZeroSizeTest ", (long)0L, (long)values.size());
    }

    @Test
    public void testPaging() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        for (int i = 0; i < 512; ++i) {
            Integer value = new Integer(i);
            Object oldValue = map.put((long)i, (Object)value);
            Assert.assertNull((String)"OldValueNullTest ", (Object)oldValue);
            Assert.assertEquals((String)"OldValueNullTest ", (Object)value, (Object)map.get((long)i));
        }
    }

    @Test
    public void testGetWithNegativeKeyReturnsNull() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        Assert.assertNull((Object)map.get(-1L));
    }

    @Test
    public void testRemoveWithNegativeReturnsNull() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        Assert.assertNull((Object)map.remove(-1L));
    }

    @Test
    public void testPutWithNegativeKeyThrowsIllegalArgumentException() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        try {
            map.put(-1L, new Object());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxKey() {
        PrimitiveLongMap map = new PrimitiveLongMap(8, 4);
        map.put(0L, (Object)new Integer(0));
        Assert.assertEquals((Object)new Integer(0), (Object)map.get(0L));
        Assert.assertNull((Object)map.remove(1L));
        Assert.assertEquals((Object)new Integer(0), (Object)map.get(0L));
        Assert.assertNotNull((Object)map.remove(0L));
        Assert.assertNull((Object)map.get(0L));
        map.put(1L, (Object)new Integer(1));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get(1L));
        Assert.assertNull((Object)map.remove(2L));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get(1L));
        Assert.assertNotNull((Object)map.remove(1L));
        Assert.assertNull((Object)map.get(1L));
        map.put(127L, (Object)new Integer(127));
        Assert.assertEquals((Object)new Integer(127), (Object)map.get(127L));
        Assert.assertNull((Object)map.remove(128L));
        Assert.assertEquals((Object)new Integer(127), (Object)map.get(127L));
        Assert.assertNotNull((Object)map.remove(127L));
        Assert.assertNull((Object)map.get(127L));
        map.put(128L, (Object)new Integer(128));
        Assert.assertEquals((Object)new Integer(128), (Object)map.get(128L));
        Assert.assertNull((Object)map.remove(129L));
        Assert.assertEquals((Object)new Integer(128), (Object)map.get(128L));
        Assert.assertNotNull((Object)map.remove(128L));
        Assert.assertNull((Object)map.get(128L));
    }

    @Test
    public void testLastIndexBoundary() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        map.put(8192L, new Object());
        map.remove(8192L);
        map.put(8192L, new Object());
        map.put(8191L, new Object());
    }

    @Test
    public void testSize() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        Object object = new Object();
        map.put(231L, object);
        Object string = new Object();
        map.put(211L, string);
        map.put(99822L, null);
        Assert.assertEquals((long)3L, (long)map.size());
        map.put(211L, null);
        map.put(99822L, string);
        Assert.assertEquals((long)3L, (long)map.size());
        map.remove(211L);
        Assert.assertEquals((long)2L, (long)map.size());
        map.remove(99822L);
        Assert.assertEquals((long)1L, (long)map.size());
        map.remove(231L);
        Assert.assertEquals((long)0L, (long)map.size());
    }
}

