/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger {
    private List<LogEvent> events = new ArrayList<LogEvent>();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;
    private boolean split = true;
    private boolean initialized = false;
    protected boolean terminate = false;

    public WorkingMemoryFileLogger() {
    }

    public WorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public WorkingMemoryFileLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.events = (List)in.readObject();
        this.fileName = (String)in.readObject();
        this.maxEventsInMemory = in.readInt();
        this.nbOfFile = in.readInt();
        this.split = in.readBoolean();
        this.initialized = in.readBoolean();
        this.terminate = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.events);
        out.writeObject(this.fileName);
        out.writeInt(this.maxEventsInMemory);
        out.writeInt(this.nbOfFile);
        out.writeBoolean(this.split);
        out.writeBoolean(this.initialized);
        out.writeBoolean(this.terminate);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        if (!this.initialized) {
            this.initializeLog();
        }
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
            XStream xstream = new XStream();
            ArrayList<LogEvent> eventsToWrite = null;
            List<LogEvent> list = this.events;
            synchronized (list) {
                eventsToWrite = new ArrayList<LogEvent>(this.events);
                this.clear();
            }
            for (LogEvent event : eventsToWrite) {
                fileWriter.write(xstream.toXML((Object)event) + "\n");
            }
            if (this.split) {
                fileWriter.write("</object-stream>");
                ++this.nbOfFile;
                this.initialized = false;
            }
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.terminate) {
            this.terminateLog();
        }
    }

    private void initializeLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false);
            writer.append("<object-stream>\n");
            writer.close();
            this.initialized = true;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private void terminateLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
            writer.append("</object-stream>\n");
            writer.close();
            this.terminate = false;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not terminate the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }

    public void setMaxEventsInMemory(int maxEventsInMemory) {
        this.maxEventsInMemory = maxEventsInMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEventCreated(LogEvent logEvent) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(logEvent);
            if (this.events.size() > this.maxEventsInMemory) {
                this.writeToDisk();
            }
        }
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public void stop() {
        this.terminate = true;
        this.writeToDisk();
    }
}

