/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ValueType;
import org.drools.base.extractors.BaseObjectClassFieldReader;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.MVELDialectRuntimeData;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;

public class MVELClassFieldReader
extends BaseObjectClassFieldReader
implements Externalizable,
MVELCompileable {
    private static final long serialVersionUID = 510L;
    private ExecutableStatement mvelExpression = null;
    private String className;
    private String expr;
    private boolean typesafe;

    public MVELClassFieldReader() {
    }

    public MVELClassFieldReader(String className, String expr, boolean typesafe) {
        this.className = className;
        this.expr = expr;
        this.typesafe = typesafe;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.expr = (String)in.readObject();
        this.typesafe = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.expr);
        out.writeBoolean(this.typesafe);
    }

    public void compile(MVELDialectRuntimeData runtimeData) {
        Class cls = null;
        try {
            cls = runtimeData.getRootClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to compile as Class could not b e found '" + this.className + "'");
        }
        ParserContext context = new ParserContext(runtimeData.getParserConfiguration());
        context.addInput("this", cls);
        context.setStrongTyping(this.typesafe);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.mvelExpression = (ExecutableStatement)MVEL.compileExpression((String)this.expr, (ParserContext)context);
        Class returnType = this.mvelExpression.getKnownEgressType();
        this.setFieldType(returnType);
        this.setValueType(ValueType.determineValueType(returnType));
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return MVEL.executeExpression((Object)this.mvelExpression, (Object)object);
    }
}

