/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.DroolsTestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.SalienceInteger;
import org.drools.common.ArrayAgendaGroup;
import org.drools.common.BinaryHeapQueueAgendaGroup;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.spi.Salience;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AgendaTest
extends DroolsTestCase {
    private InternalRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext(this.ruleBase, ((ReteooRuleBase)this.ruleBase).getReteooBuilder().getIdGenerator());
    }

    @Test
    public void testClearAgenda() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Rule rule1 = new Rule("test-rule1");
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node1 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule2, rule2.getLhs(), 0, this.buildContext);
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule2.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        rule1.setNoLoop(false);
        rule2.setTimer((Timer)new DurationTimer(5000L));
        node1.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.getScheduledActivations().length);
        agenda.clearAndCancel();
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.getScheduledActivations().length);
    }

    @Test
    public void testFilters() throws Exception {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final Boolean[] filtered = new Boolean[]{false};
        workingMemory.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                if (event.getCause() == ActivationCancelledCause.FILTER) {
                    filtered[0] = true;
                }
            }
        });
        Rule rule = new Rule("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        final HashMap results = new HashMap();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                results.put("fired", new Boolean(true));
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        AgendaFilter filterTrue = new AgendaFilter(){

            public boolean accept(Activation item) {
                return true;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        agenda.fireNextItem(filterTrue);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((Object)new Boolean(true), results.get("fired"));
        Assert.assertEquals((Object)false, (Object)filtered[0]);
        agenda.clearAndCancel();
        results.clear();
        AgendaFilter filterFalse = new AgendaFilter(){

            public boolean accept(Activation item) {
                return false;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        agenda.fireNextItem(filterFalse);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertNull(results.get("fired"));
        Assert.assertEquals((Object)true, (Object)filtered[0]);
    }

    @Test
    public void testFocusStack() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2", "agendaGroup2");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup1 = new BinaryHeapQueueAgendaGroup("agendaGroup1", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup1);
        BinaryHeapQueueAgendaGroup agendaGroup2 = new BinaryHeapQueueAgendaGroup("agendaGroup2", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup2);
        BinaryHeapQueueAgendaGroup agendaGroup3 = new BinaryHeapQueueAgendaGroup("agendaGroup3", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup3);
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        node0.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agendaGroup2.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agendaGroup2.size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        agenda.setFocus("agendaGroup3");
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)5L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup2);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testAutoFocus() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup = new BinaryHeapQueueAgendaGroup("agendaGroup", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        rule.setConsequence(consequence);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setAutoFocus(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.clearAndCancel();
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
        rule.setAutoFocus(true);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
    }

    @Test
    public void testAgendaGroupLockOnActive() {
        InternalRuleBase ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup = new BinaryHeapQueueAgendaGroup("agendaGroup", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setLockOnActive(true);
        agendaGroup.setActive(true);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        rule.setLockOnActive(true);
        agendaGroup.setActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)agendaGroup.size());
    }

    @Test
    public void testActivationGroup() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        rule0.setActivationGroup("activation-group-0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1");
        rule1.setActivationGroup("activation-group-0");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2");
        rule2.setSalience((Salience)new SalienceInteger(-5));
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        rule3.setSalience((Salience)new SalienceInteger(-10));
        rule3.setActivationGroup("activation-group-3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        node0.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        ActivationGroup activationGroup0 = agenda.getActivationGroup("activation-group-0");
        Assert.assertEquals((long)1L, (long)activationGroup0.size());
        node0.retractLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        node0.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)activationGroup0.size());
        node1.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)activationGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.focusStackSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)rule1, list.get(0));
        list.clear();
        node0.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        node3.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)activationGroup0.size());
        ActivationGroup activationGroup3 = agenda.getActivationGroup("activation-group-3");
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        Assert.assertEquals((long)1L, (long)activationGroup3.size());
        agenda.clearAndCancelAgendaGroup("agendaGroup3");
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        Assert.assertEquals((long)0L, (long)activationGroup3.size());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)rule1, list.get(0));
        Assert.assertEquals((Object)rule2, list.get(1));
    }

    @Test
    public void testRuleFlowGroup() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-1");
        rule1.setConsequence(consequence);
        RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        Rule rule2 = new Rule("test-rule2");
        rule2.setRuleFlowGroup("rule-flow-group-2");
        rule2.setConsequence(consequence);
        rule2.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(2), rule2, rule2.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        RuleFlowGroup ruleFlowGroup1 = agenda.getRuleFlowGroup("rule-flow-group-1");
        RuleFlowGroup ruleFlowGroup2 = agenda.getRuleFlowGroup("rule-flow-group-2");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node1.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTupleImpl tuple3 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node2.assertLeftTuple((LeftTuple)tuple3, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-1");
        agenda.activateRuleFlowGroup("rule-flow-group-2");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup1() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 510L;
            final /* synthetic */ PropagationContext val$context0;
            final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
                node1.assertLeftTuple((LeftTuple)tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup2() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, null);
        final LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 510L;
            final /* synthetic */ PropagationContext val$context0;
            final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                node1.retractLeftTuple((LeftTuple)tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        rule0.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup3() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.deactivateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup4() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        ruleFlowGroup0.setAutoDeactivate(false);
        Assert.assertFalse((boolean)ruleFlowGroup0.isAutoDeactivate());
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, workingMemory);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        Assert.assertTrue((boolean)ruleFlowGroup0.isActive());
        ruleFlowGroup0.setAutoDeactivate(true);
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        Assert.assertFalse((boolean)ruleFlowGroup0.isActive());
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, workingMemory);
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        Assert.assertTrue((boolean)ruleFlowGroup0.isActive());
        agenda.fireNextItem(null);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        workingMemory.executeQueuedActions();
        Assert.assertFalse((boolean)ruleFlowGroup0.isActive());
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context0, workingMemory);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup5() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        workingMemory.executeQueuedActions();
        Assert.assertFalse((boolean)ruleFlowGroup0.isActive());
    }

    @Test
    public void testRuleFlowGroupLockOnActive() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        RuleFlowGroupImpl ruleFlowGroup = (RuleFlowGroupImpl)agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule");
        rule.setRuleFlowGroup("rule-flow-group-0");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setLockOnActive(true);
        ruleFlowGroup.setAutoDeactivate(false);
        ruleFlowGroup.setActive(true);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup.size());
        rule.setLockOnActive(true);
        ruleFlowGroup.setActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)ruleFlowGroup.size());
    }

    @Test
    public void testSequentialAgenda() {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        InternalRuleBase ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        node0.setSequence(72);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        node1.setSequence(10);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2", "agendaGroup1");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        node2.setSequence(7);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup2");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        node3.setSequence(0);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        ruleBase.getAgendaGroupRuleTotals().put("MAIN", new Integer(100));
        ruleBase.getAgendaGroupRuleTotals().put("agendaGroup1", new Integer(10));
        ruleBase.getAgendaGroupRuleTotals().put("agendaGroup2", new Integer(1));
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(0, ruleBase);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        ArrayAgendaGroup agendaGroup1 = new ArrayAgendaGroup("agendaGroup1", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup1);
        ArrayAgendaGroup agendaGroup2 = new ArrayAgendaGroup("agendaGroup2", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup2);
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        node0.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agendaGroup1.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        node2.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agendaGroup1.size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)5L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testNullErrorOnGetScheduledActivations() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        try {
            ((DefaultAgenda)workingMemory.getAgenda()).getScheduledActivations();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Exception Should not have been thrown");
        }
    }
}

