/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.List;
import java.util.Map;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.SingleBetaConstraints;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.Step;
import org.drools.rule.BehaviorManager;
import org.drools.rule.Declaration;
import org.drools.spi.BetaNodeFieldConstraint;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNodeStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public NotNodeStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        EmptyBetaConstraints constraints;
        ObjectSource rightObjectSource;
        LeftTupleSource leftTupleSource;
        String name;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() != 0) {
            String[] a = args.get(0);
            name = a[0].trim();
            String leftInput = a[1].trim();
            String rightInput = a[2].trim();
            leftTupleSource = "mock".equals(leftInput) ? (LeftTupleSource)Mockito.mock(LeftTupleSource.class) : (LeftTupleSource)context.get(leftInput);
            rightObjectSource = "mock".equals(rightInput) ? (ObjectSource)Mockito.mock(ObjectSource.class) : (ObjectSource)context.get(rightInput);
            if (args.size() > 1) {
                BetaNodeFieldConstraint betaConstraint;
                a = args.get(1);
                String fieldName = a[0].trim();
                String operator = a[1].trim();
                String var = a[2].trim();
                Declaration declr = (Declaration)context.get(var);
                try {
                    betaConstraint = this.reteTesterHelper.getBoundVariableConstraint(declr.getPattern(), fieldName, declr, operator);
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException();
                }
                constraints = new SingleBetaConstraints(betaConstraint, buildContext.getRuleBase().getConfiguration());
            } else {
                constraints = new EmptyBetaConstraints();
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + args);
        }
        NotNode notNode = new NotNode(buildContext.getNextId(), leftTupleSource, rightObjectSource, (BetaConstraints)constraints, BehaviorManager.NO_BEHAVIORS, buildContext);
        notNode.attach();
        context.put(name, notNode);
    }
}

