/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.LIANodePropagation;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode {
    private static final long serialVersionUID = 510L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;
    protected boolean rootQueryNode;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
        ObjectSource current = source;
        while (!(current instanceof ObjectTypeNode)) {
            current = current.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)current;
        this.rootQueryNode = ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(otn.getObjectType());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectSource = (ObjectSource)in.readObject();
        this.leftTupleMemoryEnabled = in.readBoolean();
        this.rootQueryNode = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectSource);
        out.writeBoolean(this.leftTupleMemoryEnabled);
        out.writeBoolean(this.rootQueryNode);
    }

    public boolean isRootQueryNode() {
        return this.rootQueryNode;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.objectSource.networkUpdated();
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        boolean useLeftMemory = true;
        if (!this.leftTupleMemoryEnabled && (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            useLeftMemory = false;
        }
        if (!workingMemory.isSequential()) {
            this.sink.createAndPropagateAssertLeftTuple(factHandle, context, workingMemory, useLeftMemory, this);
        } else {
            workingMemory.addLIANodePropagation(new LIANodePropagation(this, factHandle, context));
        }
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTupleSinkAdapter adapter = new RightTupleSinkAdapter(sink, true);
        this.objectSource.updateSink(adapter, context, workingMemory);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        this.objectSource.remove(context, builder, this, workingMemories);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.objectSource.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode)) {
            return false;
        }
        LeftInputAdapterNode other = (LeftInputAdapterNode)object;
        return this.objectSource.equals(other.objectSource);
    }

    private static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private boolean leftTupleMemoryEnabled;

        public RightTupleSinkAdapter(LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            this.sink = sink;
            this.leftTupleMemoryEnabled = leftTupleMemoryEnabled;
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
            LeftTupleImpl tuple = new LeftTupleImpl(factHandle, this.sink, this.leftTupleMemoryEnabled);
            this.sink.assertLeftTuple(tuple, context, workingMemory);
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

