/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.drools.common.BaseNode;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.rule.Behavior;
import org.drools.rule.EntryPoint;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.RuleComponent;
import org.drools.time.TemporalDependencyMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContext {
    private LeftTupleSource tupleSource;
    private ObjectSource objectSource;
    private LinkedList objectType;
    private int currentPatternOffset;
    private InternalRuleBase rulebase;
    private Rule rule;
    private Stack<RuleComponent> ruleComponent;
    private InternalWorkingMemory[] workingMemories;
    private ReteooBuilder.IdGenerator idGenerator;
    private LinkedList<RuleConditionElement> buildstack;
    private List betaconstraints;
    private List alphaConstraints;
    private List<Behavior> behaviors;
    private EntryPoint currentEntryPoint;
    private boolean tupleMemoryEnabled;
    private boolean objectTypeNodeMemoryEnabled;
    private boolean terminalNodeMemoryEnabled;
    private boolean alphaNodeMemoryAllowed;
    private boolean query;
    private List<BaseNode> nodes;
    private RuleBasePartitionId partitionId;
    private TemporalDependencyMatrix temporal;
    private ObjectTypeNode rootObjectTypeNode;

    public BuildContext(InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        this.rulebase = rulebase;
        this.idGenerator = idGenerator;
        this.workingMemories = null;
        this.objectType = null;
        this.buildstack = null;
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
        this.tupleMemoryEnabled = true;
        this.objectTypeNodeMemoryEnabled = true;
        this.currentEntryPoint = EntryPoint.DEFAULT;
        this.nodes = new LinkedList<BaseNode>();
        this.partitionId = null;
        this.ruleComponent = new Stack();
    }

    public int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    public void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
        this.syncObjectTypesWithPatternOffset();
    }

    public void syncObjectTypesWithPatternOffset() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        while (this.objectType.size() > this.currentPatternOffset) {
            this.objectType.removeLast();
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public LinkedList getObjectType() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        return this.objectType;
    }

    public void setObjectType(LinkedList objectType) {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        this.objectType = objectType;
    }

    public LeftTupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    public void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
        this.syncObjectTypesWithPatternOffset();
    }

    public InternalRuleBase getRuleBase() {
        return this.rulebase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        if (this.workingMemories == null) {
            this.workingMemories = this.rulebase.getWorkingMemories();
        }
        return this.workingMemories;
    }

    public int getNextId() {
        return this.idGenerator.getNextId();
    }

    public void releaseId(int id) {
        this.idGenerator.releaseId(id);
    }

    public void push(RuleConditionElement rce) {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.getLast();
    }

    public ListIterator<RuleConditionElement> stackIterator() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.listIterator(this.buildstack.size());
    }

    public List getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public int getNextSequence(String groupName) {
        Integer seq = (Integer)this.rulebase.getAgendaGroupRuleTotals().get(groupName);
        if (seq == null) {
            seq = new Integer(0);
        }
        Integer newSeq = new Integer(seq + 1);
        this.rulebase.getAgendaGroupRuleTotals().put(groupName, newSeq);
        return newSeq;
    }

    public List getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public void setAlphaConstraints(List alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean hasLeftMemory) {
        this.tupleMemoryEnabled = hasLeftMemory;
    }

    public boolean isObjectTypeNodeMemoryEnabled() {
        return this.objectTypeNodeMemoryEnabled;
    }

    public void setObjectTypeNodeMemoryEnabled(boolean hasObjectTypeMemory) {
        this.objectTypeNodeMemoryEnabled = hasObjectTypeMemory;
    }

    public boolean isTerminalNodeMemoryEnabled() {
        return this.terminalNodeMemoryEnabled;
    }

    public void setTerminalNodeMemoryEnabled(boolean hasTerminalNodeMemory) {
        this.terminalNodeMemoryEnabled = hasTerminalNodeMemory;
    }

    public void setAlphaNodeMemoryAllowed(boolean alphaMemoryAllowed) {
        this.alphaNodeMemoryAllowed = alphaMemoryAllowed;
    }

    public boolean isAlphaMemoryAllowed() {
        return this.alphaNodeMemoryAllowed;
    }

    public boolean isQuery() {
        return this.query;
    }

    public EntryPoint getCurrentEntryPoint() {
        return this.currentEntryPoint;
    }

    public void setCurrentEntryPoint(EntryPoint currentEntryPoint) {
        this.currentEntryPoint = currentEntryPoint;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(List<Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    public List<BaseNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<BaseNode> nodes) {
        this.nodes = nodes;
    }

    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void setTemporalDistance(TemporalDependencyMatrix temporal) {
        this.temporal = temporal;
    }

    public TemporalDependencyMatrix getTemporalDistance() {
        return this.temporal;
    }

    public LinkedList<RuleConditionElement> getBuildStack() {
        return this.buildstack;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
        if (rule instanceof Query) {
            this.query = true;
        }
    }

    public RuleComponent popRuleComponent() {
        return this.ruleComponent.pop();
    }

    public RuleComponent peekRuleComponent() {
        return this.ruleComponent.isEmpty() ? null : this.ruleComponent.peek();
    }

    public void pushRuleComponent(RuleComponent ruleComponent) {
        this.ruleComponent.push(ruleComponent);
    }

    public void setRootObjectTypeNode(ObjectTypeNode source) {
        this.rootObjectTypeNode = source;
    }

    public ObjectTypeNode getRootObjectTypeNode() {
        return this.rootObjectTypeNode;
    }
}

