/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.DirectoryScanner;
import org.drools.agent.MockListener;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class DirectoryScannerTest {
    @Test
    public void testScan() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        Package p2 = new Package("p2");
        File p1f = new File(dir, "p1.pkg");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        DirectoryScanner scan = new DirectoryScanner();
        scan.listener = new MockListener();
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        scan.configure(props);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        Package p3 = new Package("p3");
        File p3f = new File(dir, "p3.pkg");
        RuleBaseAssemblerTest.writePackage(p3, p3f);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        Assert.assertEquals((long)3L, (long)rb.getPackages().length);
    }

    @Test
    public void testScanDRLFileReplace() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        Package p2 = new Package("p2");
        File p1f = new File(dir, "p1.pkg");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        DirectoryScanner scan = new DirectoryScanner();
        scan.listener = new MockListener();
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        scan.configure(props);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageChangeInfo info1 = scan.loadPackageChanges();
        Assert.assertEquals((long)2L, (long)info1.getChangedPackages().size());
        Assert.assertEquals((long)0L, (long)info1.getRemovedPackages().size());
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)info1.getChangedPackages(), (Collection)info1.getRemovedPackages(), (AgentEventListener)new MockListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        boolean fileDeleted = p2f.delete();
        Assert.assertTrue((boolean)fileDeleted);
        Package p3 = new Package("p3");
        File p3f = new File(dir, "p3.pkg");
        RuleBaseAssemblerTest.writePackage(p3, p3f);
        PackageChangeInfo info2 = scan.loadPackageChanges();
        Assert.assertEquals((long)1L, (long)info2.getChangedPackages().size());
        Assert.assertEquals((long)1L, (long)info2.getRemovedPackages().size());
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)info2.getChangedPackages(), (Collection)info2.getRemovedPackages(), (AgentEventListener)new MockListener());
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
    }
}

