/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;

public class WorkingMemoryEventSupportTest {
    @Test
    public void testIsSerializable() {
        Assert.assertTrue((boolean)Serializable.class.isAssignableFrom(WorkingMemoryEventSupport.class));
    }

    @Test
    public void testWorkingMemoryEventListener() {
        KnowledgeBase rb = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession wm = rb.newStatefulKnowledgeSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener workingMemoryListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Assert.assertEquals((long)1L, (long)wm.getWorkingMemoryEventListeners().size());
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        Assert.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        wm.update(stiltonHandle, (Object)cheddar);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        Assert.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        Assert.assertEquals((Object)cheddar, (Object)ome.getObject());
        Assert.assertEquals((Object)stilton, (Object)ome.getOldObject());
        wm.retract(stiltonHandle);
        ObjectRetractedEvent ore = (ObjectRetractedEvent)wmList.get(2);
        Assert.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        oae = (ObjectInsertedEvent)wmList.get(3);
        Assert.assertSame((Object)cheddarHandle, (Object)oae.getFactHandle());
    }
}

