/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.junit.Assert;
import org.junit.Test;

public class ResourceChangeScannerTest {
    @Test
    public void testValidPollIntervals() {
        ResourceFactory.getResourceChangeScannerService();
        ResourceChangeScannerConfiguration conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        ResourceFactory.getResourceChangeScannerService().configure(conf);
        conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        conf.setProperty("drools.resource.scanner.interval", "10");
        ResourceFactory.getResourceChangeScannerService().configure(conf);
        ResourceFactory.getResourceChangeScannerService().setInterval(5);
    }

    @Test
    public void testInvalidPollIntervals() {
        ResourceChangeScannerConfiguration conf;
        try {
            conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
            conf.setProperty("drools.resource.scanner.interval", "0");
            ResourceFactory.getResourceChangeScannerService().configure(conf);
            Assert.fail((String)"0 should not be allowed because of performance reasons.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
            conf.setProperty("drools.resource.scanner.interval", "-10");
            ResourceFactory.getResourceChangeScannerService().configure(conf);
            Assert.fail((String)"Negative values should not be allowed.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
            conf.setProperty("drools.resource.scanner.interval", "60");
            ResourceFactory.getResourceChangeScannerService().configure(conf);
            ResourceFactory.getResourceChangeScannerService().setInterval(0);
            Assert.fail((String)"0 should not be allowed because of performance reasons.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
            conf.setProperty("drools.resource.scanner.interval", "60");
            ResourceFactory.getResourceChangeScannerService().configure(conf);
            ResourceFactory.getResourceChangeScannerService().setInterval(-10);
            Assert.fail((String)"Negative values should not be allowed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

