/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.Otherwise;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassObjectType;
import org.drools.base.TestBean;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OtherwiseTest {
    @Test
    public void testOneRuleFiringNoOtherwise() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)1);
        Package pkg = new Package("Miss Manners");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        Rule rule1 = this.getRule("rule1");
        pkg.addRule(rule1);
        Rule ruleOtherwise = this.getOtherwise("rule2");
        pkg.addRule(ruleOtherwise);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new TestBean());
        workingMemory.fireAllRules();
        Assert.assertTrue((boolean)((MockConsequence)rule1.getConsequence()).fired);
        Assert.assertFalse((boolean)((MockConsequence)ruleOtherwise.getConsequence()).fired);
    }

    @Test
    public void testTwoRulesFiringNoOtherwise() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)1);
        Package pkg = new Package("Miss Manners");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        Rule rule1 = this.getRule("rule1");
        pkg.addRule(rule1);
        Rule rule2 = this.getRule("rule2");
        pkg.addRule(rule2);
        Rule ruleOtherwise = this.getOtherwise("ruleOtherwise");
        pkg.addRule(ruleOtherwise);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new TestBean());
        workingMemory.fireAllRules();
        Assert.assertFalse((boolean)((MockConsequence)ruleOtherwise.getConsequence()).fired);
        Assert.assertTrue((boolean)((MockConsequence)rule1.getConsequence()).fired);
        Assert.assertTrue((boolean)((MockConsequence)rule2.getConsequence()).fired);
    }

    @Test
    @Ignore
    public void testOtherwiseFiringWithOneRule() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)1);
        Package pkg = new Package("Miss Manners");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        Rule rule1 = this.getRule("rule1");
        pkg.addRule(rule1);
        Rule ruleOtherwise = this.getOtherwise("rule2");
        pkg.addRule(ruleOtherwise);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        Assert.assertFalse((boolean)((MockConsequence)rule1.getConsequence()).fired);
        Assert.assertTrue((boolean)((MockConsequence)ruleOtherwise.getConsequence()).fired);
    }

    @Test
    @Ignore
    public void testOtherwiseFiringMultipleRules() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)1);
        Package pkg = new Package("Miss Manners");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        Rule rule1 = this.getRule("rule1");
        pkg.addRule(rule1);
        Rule rule2 = this.getRule("rule2");
        pkg.addRule(rule2);
        Rule ruleOtherwise1 = this.getOtherwise("other1");
        pkg.addRule(ruleOtherwise1);
        Rule ruleOtherwise2 = this.getOtherwise("other2");
        pkg.addRule(ruleOtherwise2);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        Assert.assertFalse((boolean)((MockConsequence)rule1.getConsequence()).fired);
        Assert.assertFalse((boolean)((MockConsequence)rule2.getConsequence()).fired);
        Assert.assertTrue((boolean)((MockConsequence)ruleOtherwise1.getConsequence()).fired);
        Assert.assertTrue((boolean)((MockConsequence)ruleOtherwise2.getConsequence()).fired);
    }

    private Rule getOtherwise(String name) {
        Rule rule = new Rule(name);
        Pattern pat = new Pattern(0, (ObjectType)new ClassObjectType(Otherwise.class));
        rule.addPattern((RuleConditionElement)pat);
        rule.setConsequence((Consequence)new MockConsequence());
        return rule;
    }

    private Rule getRule(String name) {
        Rule rule = new Rule(name);
        Pattern pat = new Pattern(0, (ObjectType)new ClassObjectType(TestBean.class));
        rule.addPattern((RuleConditionElement)pat);
        rule.setConsequence((Consequence)new MockConsequence());
        return rule;
    }

    static class MockConsequence
    implements Consequence {
        public boolean fired = false;

        MockConsequence() {
        }

        public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            this.fired = true;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public String getName() {
            return "default";
        }
    }
}

