/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.Step;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactsStep
implements Step {
    ReteTesterHelper reteTesterHelper;

    public FactsStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        if (args.size() >= 1) {
            WorkingMemory wm = (WorkingMemory)context.get("WorkingMemory");
            ArrayList<FactHandle> handles = (ArrayList<FactHandle>)context.get("Handles");
            if (handles == null) {
                handles = new ArrayList<FactHandle>();
                context.put("Handles", handles);
            }
            NodeTestCase testCase = (NodeTestCase)context.get("TestCase");
            ParserConfiguration conf = new ParserConfiguration();
            for (String imp : testCase.getImports()) {
                if (imp.endsWith(".*")) {
                    conf.addPackageImport(imp.substring(0, imp.lastIndexOf(46)));
                    continue;
                }
                try {
                    conf.addImport(imp.substring(imp.lastIndexOf(".") + 1), this.reteTesterHelper.getTypeResolver().resolveType(imp));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to resolve import: " + imp);
                }
            }
            for (String[] str : args) {
                Serializable expr = MVEL.compileExpression((String)Arrays.asList(str).toString(), (ParserContext)new ParserContext(conf));
                List objects = (List)MVEL.executeExpression((Object)expr);
                for (Object object : objects) {
                    FactHandle handle = wm.insert(object);
                    handles.add(handle);
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + Arrays.asList(args));
        }
    }
}

