/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.HashMap;
import java.util.Iterator;
import org.drools.Cheese;
import org.drools.core.util.Entry;
import org.drools.core.util.ObjectHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ObjectHashMapTest {
    @Test
    public void testChechExistsFalse() {
        Entry entry;
        ObjectHashMap map = new ObjectHashMap();
        Cheese stilton = new Cheese("stilton", 5);
        map.put((Object)new Integer(1), (Object)stilton, false);
        Cheese c = (Cheese)map.get((Object)new Integer(1));
        Assert.assertSame((Object)stilton, (Object)c);
        Cheese cheddar = new Cheese("cheddar", 5);
        map.put((Object)new Integer(1), (Object)cheddar, false);
        c = (Cheese)map.get((Object)new Integer(1));
        Assert.assertSame((Object)cheddar, (Object)c);
        int size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        Assert.assertEquals((long)2L, (long)size);
        map.remove((Object)new Integer(1));
        size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        Assert.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testChechExistsTrue() {
        Entry entry;
        ObjectHashMap map = new ObjectHashMap();
        Cheese stilton = new Cheese("stilton", 5);
        map.put((Object)new Integer(1), (Object)stilton, true);
        Cheese c = (Cheese)map.get((Object)new Integer(1));
        Assert.assertSame((Object)stilton, (Object)c);
        Cheese cheddar = new Cheese("cheddar", 5);
        map.put((Object)new Integer(1), (Object)cheddar);
        c = (Cheese)map.get((Object)new Integer(1));
        Assert.assertSame((Object)cheddar, (Object)c);
        int size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        Assert.assertEquals((long)1L, (long)size);
        map.remove((Object)new Integer(1));
        size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test
    public void testEmptyIterator() {
        ObjectHashMap map = new ObjectHashMap();
        org.drools.core.util.Iterator it = map.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            Assert.fail((String)"Map is empty, there should be no iteration");
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    @Test
    public void testStringData() {
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val);
            Assert.assertEquals((Object)val, (Object)map.get((Object)key));
        }
    }

    @Test
    public void testIntegerData() {
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            Integer key = new Integer(idx);
            Integer val = new Integer(idx);
            map.put((Object)key, (Object)val);
            Assert.assertEquals((Object)val, (Object)map.get((Object)key));
        }
    }

    @Test
    public void testJUHashmap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertNotNull(map);
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put(key, val);
            Assert.assertEquals((Object)val, map.get(key));
        }
    }

    @Test
    public void testStringDataDupFalse() {
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        int count = 10000;
        for (int idx = 0; idx < 10000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val, false);
            Assert.assertEquals((Object)val, (Object)map.get((Object)key));
        }
    }

    @Test
    public void testJUHashMap1() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertNotNull(map);
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap put(key,value) ET - " + (end - start));
    }

    @Test
    public void testStringData2() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap put(key,value) ET - " + (end - start));
    }

    @Test
    public void testStringData3() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            map.get((Object)key);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap get(key) ET - " + (end - start));
    }

    @Test
    public void testJUHashMap2() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertNotNull(map);
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
        }
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            map.get(key);
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap get(key) ET - " + (end - start));
    }

    @Test
    public void testStringData4() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long start = System.currentTimeMillis();
        org.drools.core.util.Iterator itr = map.iterator();
        Object val = null;
        while ((val = itr.next()) != null) {
            val.hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap iterate ET - " + (end - start));
    }

    @Test
    public void testJUHashMap3() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertNotNull(map);
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
        }
        long start = System.currentTimeMillis();
        Iterator itr = map.values().iterator();
        while (itr.hasNext()) {
            itr.next().hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap iterate ET - " + (end - start));
    }

    @Test
    public void testStringData5() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assert.assertNotNull((Object)map);
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval, false);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap dup false ET - " + (end - start));
    }
}

