/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleImpl;
import org.drools.core.util.TripleStore;
import org.drools.runtime.rule.Variable;
import org.junit.Assert;
import org.junit.Test;

public class TripleStoreTest {
    private Variable V = Variable.v;

    @Test
    public void testPutAndGet() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assert.assertFalse((boolean)store.put((Triple)t));
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"mark", (Object)t.getValue());
    }

    @Test
    public void testPutAndGetWithExisting() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assert.assertFalse((boolean)store.put((Triple)t));
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"mark", (Object)t.getValue());
        t = new TripleImpl((Object)ind, "hasName", (Object)"davide");
        Assert.assertTrue((boolean)store.put((Triple)t));
        tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"davide", (Object)t.getValue());
    }

    @Test
    public void testPutAndGetandRemove() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assert.assertFalse((boolean)store.put((Triple)t));
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"mark", (Object)t.getValue());
        t = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Assert.assertEquals((long)1L, (long)store.removeAll((Triple)t));
        Assert.assertFalse((boolean)store.remove((Triple)t));
        tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Assert.assertNull((Object)store.get((Triple)tKey));
    }

    @Test
    public void testMassAddRemove() {
        int i;
        TripleStore store = new TripleStore();
        int instanceLength = 30000;
        int tripleLength = 70;
        TripleImpl t = null;
        ArrayList<Individual> inds = new ArrayList<Individual>(instanceLength);
        for (i = 0; i < instanceLength; ++i) {
            Individual ind = new Individual();
            inds.add(ind);
            for (int j = 0; j < tripleLength; ++j) {
                t = new TripleImpl((Object)ind, this.getPropertyName(j), (Object)(i * j));
                Assert.assertFalse((boolean)store.put((Triple)t));
            }
        }
        Assert.assertEquals((long)(instanceLength * tripleLength), (long)store.size());
        for (i = 0; i < instanceLength; ++i) {
            for (int j = 0; j < tripleLength; ++j) {
                t = new TripleImpl(inds.get(i), this.getPropertyName(j), (Object)this.V);
                store.removeAll((Triple)t);
            }
        }
        Assert.assertEquals((long)0L, (long)store.size());
    }

    public String getPropertyName(int i) {
        char c1 = (char)(65 + i / 3);
        char c2 = (char)(97 + i / 3);
        return c1 + "bl" + i + "" + c2 + "blah";
    }

    @Test
    public void testQueryVariable() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t1 = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assert.assertFalse((boolean)store.put((Triple)t1));
        TripleImpl t2 = new TripleImpl((Object)ind, "hasAge", (Object)"35");
        Assert.assertFalse((boolean)store.put((Triple)t2));
        TripleImpl t3 = new TripleImpl((Object)ind, "hasCity", (Object)"london");
        Assert.assertFalse((boolean)store.put((Triple)t3));
        Individual ind2 = new Individual();
        TripleImpl t4 = new TripleImpl((Object)ind2, "hasCity", (Object)"bologna");
        Assert.assertFalse((boolean)store.put((Triple)t4));
        TripleImpl t5 = new TripleImpl((Object)ind2, "hasCar", (Object)"lancia");
        Assert.assertFalse((boolean)store.put((Triple)t5));
        TripleImpl t6 = new TripleImpl((Object)ind2, "hasWeapon", (Object)"lancia");
        Assert.assertFalse((boolean)store.put((Triple)t6));
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Triple t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"mark", (Object)t.getValue());
        tKey = new TripleImpl((Object)ind2, "hasCity", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"bologna", (Object)t.getValue());
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertNull((Object)t);
        tKey = new TripleImpl((Object)ind2, "hasCar", (Object)this.V);
        t = store.get((Triple)tKey);
        Assert.assertEquals((Object)"lancia", (Object)t.getValue());
        tKey = new TripleImpl((Object)this.V, "hasCity", (Object)this.V);
        Collection coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(t3, t4)));
        Assert.assertEquals((long)2L, (long)coll.size());
        tKey = new TripleImpl((Object)ind, (Object)this.V, (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(t1, t2, t3)));
        Assert.assertEquals((long)3L, (long)coll.size());
        tKey = new TripleImpl((Object)ind2, (Object)this.V, (Object)"lancia");
        coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(t5, t6)));
        Assert.assertEquals((long)2L, (long)coll.size());
        tKey = new TripleImpl((Object)this.V, (Object)this.V, (Object)"lancia");
        coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(t5, t6)));
        Assert.assertEquals((long)2L, (long)coll.size());
        tKey = new TripleImpl((Object)this.V, (Object)this.V, (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(t1, t2, t3, t4, t5, t6)));
        Assert.assertEquals((long)6L, (long)coll.size());
    }

    @Test
    public void testAddNary() {
        TripleStore store = new TripleStore(200, 0.6f);
        Individual ind = new Individual();
        TripleImpl t1 = new TripleImpl((Object)ind, "hasName", (Object)"marc");
        Assert.assertFalse((boolean)store.put((Triple)t1));
        TripleImpl t2 = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assert.assertTrue((boolean)store.put((Triple)t2));
        TripleImpl t3 = new TripleImpl((Object)ind, "hasName", (Object)"daniel");
        store.add((Triple)t3);
        TripleImpl t4 = new TripleImpl((Object)ind, "hasCar", (Object)"mini");
        store.add((Triple)t4);
        TripleImpl t5 = new TripleImpl((Object)ind, "hasName", (Object)"oscar");
        store.add((Triple)t5);
        TripleImpl t6 = new TripleImpl((Object)ind, "hasCar", (Object)"ferrari");
        store.add((Triple)t6);
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Collection coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(new TripleImpl((Object)ind, "hasName", (Object)"oscar"), new TripleImpl((Object)ind, "hasName", (Object)"mark"), new TripleImpl((Object)ind, "hasName", (Object)"daniel"))));
        Assert.assertFalse((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"marc")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"mark")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"daniel")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"mini")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"oscar")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"ferrari")));
        Assert.assertTrue((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"oscar")));
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assert.assertTrue((boolean)coll.containsAll(Arrays.asList(new TripleImpl((Object)ind, "hasCar", (Object)"mini"), new TripleImpl((Object)ind, "hasCar", (Object)"ferrari"))));
        store.remove((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"mini"));
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assert.assertEquals((long)1L, (long)coll.size());
        store.remove((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"ferrari"));
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assert.assertEquals((long)0L, (long)coll.size());
    }

    public static class Individual {
    }
}

