/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.beans.IntrospectionException;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.ContextEntry;
import org.drools.rule.Rule;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class NotNodeTest
extends DroolsTestCase {
    Rule rule;
    PropagationContext context;
    ReteooWorkingMemory workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    NotNode node;
    RightInputAdapterNode ria;
    BetaMemory memory;
    BetaNodeFieldConstraint constraint;

    @Before
    public void setUp() throws IntrospectionException {
        this.constraint = (BetaNodeFieldConstraint)Mockito.mock(BetaNodeFieldConstraint.class);
        ContextEntry c = (ContextEntry)Mockito.mock(ContextEntry.class);
        Mockito.when((Object)this.constraint.createContextEntry()).thenReturn((Object)c);
        this.rule = new Rule("test-rule");
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.node = new NotNode(15, (LeftTupleSource)new MockTupleSource(5), (ObjectSource)new MockObjectSource(8), (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, configuration), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        this.sink = new MockLeftTupleSink();
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
    }

    @Test
    public void testNotStandard() throws FactException {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((LeftTuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getRetracted().get(0))[0]);
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
        this.node.retractRightTuple(f1.firstRightTuple, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getLeftTupleMemory().size());
        this.assertLength(3, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
    }

    @Test
    public void testNotWithConstraints() throws FactException {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)false);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((LeftTuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)false);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(2, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
    }

    public void TestNotMemoryManagement() throws FactException {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((LeftTuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        try {
            Cheese cheddar = new Cheese("cheddar", 10);
            DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
            LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
            this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Cheese brie = new Cheese("brie", 10);
            DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
            Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
            this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
            this.node.retractRightTuple(f1.firstRightTuple, this.context, (InternalWorkingMemory)this.workingMemory);
            this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
            this.node.retractRightTuple(f1.firstRightTuple, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
            Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
            this.node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
            this.node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        }
        catch (Exception e) {
            Assert.fail((String)("No exception should be raised in this procedure, but got: " + e.toString()));
        }
    }

    @Test
    public void testGetConstraints_ReturnsNullEvenWithEmptyBinder() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((LeftTuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        BetaConstraints nullConstraints = EmptyBetaConstraints.getInstance();
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        NotNode notNode = new NotNode(1, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, nullConstraints, Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        BetaNodeFieldConstraint[] constraints = notNode.getConstraints();
        Assert.assertEquals((long)0L, (long)constraints.length);
    }

    @Test
    public void testAssertTupleSequentialMode() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((LeftTuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        buildContext.setObjectTypeNodeMemoryEnabled(false);
        this.node = new NotNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, conf), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)f0), (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)0L, (long)this.sink.getAsserted().size());
        Assert.assertNull((Object)this.memory.getLeftTupleMemory());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
    }
}

