/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.lang.reflect.Field;
import java.util.Map;
import org.drools.FactHandle;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalRuleBase;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryTerminalNodeTest {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;
    private EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach();
    }

    @Test
    public void testQueryTerminalNode() {
        ClassObjectType queryObjectType = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode queryObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)queryObjectType, this.buildContext);
        queryObjectTypeNode.attach();
        ClassFieldReader extractor = this.store.getReader(DroolsQuery.class, "name", DroolsQuery.class.getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"query-1");
        Evaluator evaluator = this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        AlphaNode alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)queryObjectTypeNode, this.buildContext);
        alphaNode.attach();
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(this.buildContext.getNextId(), (ObjectSource)alphaNode, this.buildContext);
        liaNode.attach();
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        ObjectTypeNode cheeseObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)cheeseObjectType, this.buildContext);
        cheeseObjectTypeNode.attach();
        extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        field = FieldFactory.getFieldValue((Object)"stilton");
        constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)cheeseObjectTypeNode, this.buildContext);
        alphaNode.attach();
        BuildContext buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        JoinNode joinNode = new JoinNode(this.buildContext.getNextId(), (LeftTupleSource)liaNode, (ObjectSource)alphaNode, EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        joinNode.attach();
        Query query = new Query("query-1");
        QueryTerminalNode queryNode = new QueryTerminalNode(this.buildContext.getNextId(), (LeftTupleSource)joinNode, (Rule)query, query.getLhs(), 0, buildContext);
        queryNode.attach();
        Package pkg = new Package("com.drools.test");
        pkg.addRule((Rule)query);
        try {
            Field pkgField = this.ruleBase.getClass().getSuperclass().getDeclaredField("pkgs");
            pkgField.setAccessible(true);
            Map pkgs = (Map)pkgField.get(this.ruleBase);
            pkgs.put(pkg.getName(), pkg);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        StatefulSession workingMemory = this.ruleBase.newStatefulSession();
        QueryResults results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
        Cheese stilton1 = new Cheese("stilton", 100);
        FactHandle handle1 = workingMemory.insert((Object)stilton1);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese cheddar = new Cheese("cheddar", 55);
        workingMemory.insert((Object)cheddar);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese stilton2 = new Cheese("stilton", 5);
        FactHandle handle2 = workingMemory.insert((Object)stilton2);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        QueryResult result2 = results.get(0);
        Assert.assertEquals((long)1L, (long)result2.size());
        Assert.assertEquals((Object)stilton1, (Object)result2.get(0));
        result2 = results.get(1);
        Assert.assertEquals((long)1L, (long)result2.size());
        Assert.assertEquals((Object)stilton2, (Object)result2.get(0));
        int i = 0;
        for (QueryResult result2 : results) {
            Assert.assertEquals((long)1L, (long)result2.size());
            if (i == 1) {
                Assert.assertSame((Object)stilton2, (Object)result2.get(0));
            } else {
                Assert.assertSame((Object)stilton1, (Object)result2.get(0));
            }
            ++i;
        }
        workingMemory.retract((org.drools.runtime.rule.FactHandle)handle1);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)handle2);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    public class Cheese {
        private String type;
        private int price;

        public Cheese(String type, int price) {
            this.type = type;
            this.price = price;
        }

        public int getPrice() {
            return this.price;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "[Cheese type='" + this.type + "' price='" + this.price + "']";
        }
    }
}

