/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.base.ClassFieldAccessor;
import org.drools.definition.type.FactField;
import org.drools.factmodel.AnnotationDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinition
implements FactField,
Comparable<FieldDefinition> {
    private String name = null;
    private String type = null;
    private boolean key = false;
    private boolean inherited = false;
    private int index = -1;
    private String initExpr = null;
    private List<AnnotationDefinition> annotations;
    private ClassFieldAccessor accessor = null;

    public FieldDefinition() {
    }

    public FieldDefinition(String name, String type) {
        this(name, type, false);
    }

    public FieldDefinition(String name, String type, boolean key) {
        this.name = name;
        this.type = type;
        this.key = key;
    }

    public void setReadWriteAccessor(ClassFieldAccessor accessor) {
        this.accessor = accessor;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.type = (String)in.readObject();
        this.key = in.readBoolean();
        this.accessor = (ClassFieldAccessor)in.readObject();
        this.annotations = (List)in.readObject();
        this.inherited = in.readBoolean();
        this.index = in.readInt();
        this.initExpr = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.type);
        out.writeBoolean(this.key);
        out.writeObject(this.accessor);
        out.writeObject(this.annotations);
        out.writeBoolean(this.inherited);
        out.writeInt(this.index);
        out.writeObject(this.initExpr);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.accessor.getFieldType();
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getReadMethod() {
        String prefix = null;
        prefix = "boolean".equals(this.type) ? "is" : "get";
        return prefix + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public String getWriteMethod() {
        return "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public boolean equals(Object o) {
        return this.getName().equals(((FieldDefinition)o).getName());
    }

    public ClassFieldAccessor getFieldAccessor() {
        return this.accessor;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void setValue(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }

    public Object getValue(Object bean) {
        return this.accessor.getValue(bean);
    }

    public Object get(Object bean) {
        return this.accessor.getValue(bean);
    }

    public void set(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getInitExpr() {
        return this.initExpr;
    }

    public void setInitExpr(String initExpr) {
        this.initExpr = initExpr;
    }

    @Override
    public int compareTo(FieldDefinition other) {
        return this.index - other.index;
    }

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationDefinition>();
        }
        this.annotations.add(annotationDefinition);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.annotations;
    }

    public String getDefaultValueAsString() {
        return this.initExpr == null ? null : this.initExpr.substring(1, this.initExpr.length() - 1);
    }

    public Boolean getDefaultValueAsBoolean() {
        return "true".equals(this.initExpr);
    }

    public Byte getDefaultValueAsByte() {
        try {
            return this.initExpr == null ? (byte)0 : Byte.parseByte(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return (byte)0;
        }
    }

    public Character getDefaultValueAsChar() {
        return Character.valueOf(this.initExpr == null ? (char)'\u0000' : this.initExpr.charAt(0));
    }

    public Double getDefaultValueAsDouble() {
        try {
            return this.initExpr == null ? 0.0 : Double.parseDouble(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public Float getDefaultValueAsFloat() {
        try {
            return Float.valueOf(this.initExpr == null ? 0.0f : Float.parseFloat(this.initExpr));
        }
        catch (NumberFormatException nfe) {
            return Float.valueOf(0.0f);
        }
    }

    public Integer getDefaultValueAsInt() {
        try {
            return this.initExpr == null ? 0 : Integer.parseInt(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public Long getDefaultValueAsLong() {
        try {
            return this.initExpr == null ? 0L : Long.parseLong(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public Short getDefaultValueAsShort() {
        try {
            return this.initExpr == null ? (short)0 : Short.parseShort(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return (short)0;
        }
    }

    public boolean getDefaultValueAs_boolean() {
        return "true".equals(this.initExpr);
    }

    public byte getDefaultValueAs_byte() {
        try {
            return this.initExpr == null ? (byte)0 : Byte.parseByte(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public char getDefaultValueAs_char() {
        return this.initExpr == null ? (char)'\u0000' : this.initExpr.charAt(0);
    }

    public double getDefaultValueAs_double() {
        try {
            return this.initExpr == null ? 0.0 : Double.parseDouble(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public float getDefaultValueAs_float() {
        try {
            return this.initExpr == null ? 0.0f : Float.parseFloat(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    public int getDefaultValueAs_int() {
        try {
            return this.initExpr == null ? 0 : Integer.parseInt(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public long getDefaultValueAs_long() {
        try {
            return this.initExpr == null ? 0L : Long.parseLong(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public short getDefaultValueAs_short() {
        try {
            return this.initExpr == null ? (short)0 : Short.parseShort(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", key=" + this.key + ", inherited=" + this.inherited + ", index=" + this.index + ", initExpr='" + this.initExpr + '\'' + ", annotations=" + this.annotations + ", accessor=" + this.accessor + '}';
    }
}

