/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.agent.AgentEventListener;
import org.drools.agent.MockProvider;
import org.drools.agent.MockRuleAgent;
import org.drools.agent.RuleAgent;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.agent.URLScanner;
import org.drools.common.InternalRuleBase;
import org.drools.definition.KnowledgePackage;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class RuleAgentTest {
    @Test
    public void testLists() {
        String s = "\tfoo.bar\n baz.bar\t whee ";
        List result = RuleAgent.list((String)s);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"foo.bar", result.get(0));
        Assert.assertEquals((Object)"baz.bar", result.get(1));
        Assert.assertEquals((Object)"whee", result.get(2));
        s = null;
        result = RuleAgent.list((String)s);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
        s = "\"yeah man\" \"another one\"";
        result = RuleAgent.list((String)s);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"yeah man", result.get(0));
        Assert.assertEquals((Object)"another one", result.get(1));
        s = "\"yeah man\"";
        result = RuleAgent.list((String)s);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"yeah man", result.get(0));
        s = "YEAH";
        result = RuleAgent.list((String)s);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"YEAH", result.get(0));
    }

    @Test
    public void testFiles() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p1.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p1.pkg " + dir.getPath() + "/" + "p2.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleBase rb = ag.getRuleBase();
        Assert.assertNotNull((Object)rb);
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        Assert.assertFalse((boolean)ag.isPolling());
        props.setProperty("poll", "1");
        ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertTrue((boolean)ag.isPolling());
        ag.stopPolling();
        Assert.assertFalse((boolean)ag.isPolling());
    }

    @Test
    public void testFilesWithKnowledgePackage() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        KnowledgePackageImp kpackage1 = new KnowledgePackageImp(new Package("p1"));
        File p1f = new File(dir, "p1.pkg");
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage1, p1f);
        KnowledgePackageImp kpackage2 = new KnowledgePackageImp(new Package("p2"));
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage2, p2f);
        String path = dir.getPath() + "/" + "p1.pkg " + dir.getPath() + "/" + "p2.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleBase rb = ag.getRuleBase();
        Assert.assertNotNull((Object)rb);
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        Assert.assertFalse((boolean)ag.isPolling());
        props.setProperty("poll", "1");
        ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertTrue((boolean)ag.isPolling());
        ag.stopPolling();
        Assert.assertFalse((boolean)ag.isPolling());
    }

    @Test
    public void testPollingFilesRuleBaseUpdate() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Random rnd = new Random(System.currentTimeMillis());
        Package p1 = new Package("p1");
        File p1f = new File(dir, rnd.nextLong() + ".pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = p1f.getPath();
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleBase rb = ag.getRuleBase();
        Assert.assertEquals((long)1L, (long)rb.getPackages().length);
        Assert.assertEquals((long)0L, (long)rb.getPackages()[0].getGlobals().size());
        p1.addGlobal("goo", String.class);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBase rb_ = ag.getRuleBase();
        Assert.assertSame((Object)rb, (Object)rb_);
        Assert.assertEquals((long)1L, (long)rb.getPackages().length);
        Assert.assertEquals((long)0L, (long)rb.getPackages()[0].getGlobals().size());
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb2 = ag.getRuleBase();
        Assert.assertSame((Object)rb, (Object)rb2);
        Assert.assertEquals((long)1L, (long)rb2.getPackages().length);
        Assert.assertEquals((long)1L, (long)rb2.getPackages()[0].getGlobals().size());
        p1.addGlobal("goo2", String.class);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb2_ = ag.getRuleBase();
        Assert.assertSame((Object)rb2_, (Object)rb2);
        Assert.assertEquals((long)1L, (long)rb2_.getPackages().length);
        Assert.assertEquals((long)2L, (long)rb2_.getPackages()[0].getGlobals().size());
        ag.refreshRuleBase();
        RuleBase rb3 = ag.getRuleBase();
        Assert.assertSame((Object)rb3, (Object)rb2);
        Assert.assertEquals((long)1L, (long)rb3.getPackages().length);
        Assert.assertEquals((long)2L, (long)rb3.getPackages()[0].getGlobals().size());
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        Assert.assertEquals((long)1L, (long)rb3.getPackages().length);
        Assert.assertEquals((long)2L, (long)rb3.getPackages()[0].getGlobals().size());
    }

    @Test
    public void testPollingFilesRuleBaseReplace() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "true");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertTrue((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        RuleBase rb_ = ag.getRuleBase();
        Assert.assertSame((Object)rb, (Object)rb_);
        ag.refreshRuleBase();
        Assert.assertSame((Object)rb, (Object)ag.getRuleBase());
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        rb_ = ag.getRuleBase();
        Assert.assertNotSame((Object)rb, (Object)rb_);
        Assert.assertEquals((long)2L, (long)rb_.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleBase rb__ = ag.getRuleBase();
        Assert.assertSame((Object)rb_, (Object)rb__);
    }

    @Test
    public void testPollingFilesRuleBaseReplaceWithKnowledgePackages() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        KnowledgePackageImp kpackage1 = new KnowledgePackageImp(new Package("p1"));
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage1, p1f);
        KnowledgePackageImp kpackage2 = new KnowledgePackageImp(new Package("p2"));
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "true");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertTrue((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        RuleBase rb_ = ag.getRuleBase();
        Assert.assertSame((Object)rb, (Object)rb_);
        ag.refreshRuleBase();
        Assert.assertSame((Object)rb, (Object)ag.getRuleBase());
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        rb_ = ag.getRuleBase();
        Assert.assertNotSame((Object)rb, (Object)rb_);
        Assert.assertEquals((long)2L, (long)rb_.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleBase rb__ = ag.getRuleBase();
        Assert.assertSame((Object)rb_, (Object)rb__);
    }

    @Test
    public void testPollingFilesRuleBaseRemoveNewInstanceFalse() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "false");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertFalse((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        boolean success = p2f.delete();
        Assert.assertTrue((boolean)success);
        ag.refreshRuleBase();
        Assert.assertEquals((long)1L, (long)rb.getPackages().length);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        Assert.assertEquals((long)1L, (long)rb.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        Assert.assertEquals((long)1L, (long)rb.getPackages().length);
    }

    @Test
    public void testPollingFilesRuleBaseRemoveNewInstanceTrue() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "true");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        Assert.assertTrue((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        Assert.assertEquals((long)2L, (long)rb.getPackages().length);
        boolean success = p2f.delete();
        Assert.assertTrue((boolean)success);
        ag.refreshRuleBase();
        RuleBase rb_ = ag.getRuleBase();
        Assert.assertNotSame((Object)rb, (Object)rb_);
        Assert.assertEquals((long)1L, (long)rb_.getPackages().length);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb__ = ag.getRuleBase();
        Assert.assertNotSame((Object)rb, (Object)rb__);
        Assert.assertEquals((long)1L, (long)rb__.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleBase rb___ = ag.getRuleBase();
        Assert.assertEquals((long)1L, (long)rb___.getPackages().length);
    }

    @Test
    public void testDirectory() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        File junk = new File(dir, "xxx.poo");
        FileOutputStream ojunk = new FileOutputStream(junk);
        ojunk.write("ignore me".getBytes());
        ojunk.flush();
        ojunk.close();
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        props.setProperty("name", "goo");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        ag.refreshRuleBase();
        RuleBase rb = ag.getRuleBase();
        Assert.assertNotNull((Object)rb);
    }

    @Test
    public void testCustomRuleBaseConfiguration() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Random rnd = new Random(System.currentTimeMillis());
        Package p1 = new Package("p1");
        File p1f = new File(dir, rnd.nextLong() + ".pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = p1f.getPath();
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent agent = RuleAgent.newRuleAgent((Properties)props);
        RuleBaseConfiguration conf = ((InternalRuleBase)agent.getRuleBase()).getConfiguration();
        Assert.assertEquals((Object)false, (Object)conf.isSequential());
        conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        agent = RuleAgent.newRuleAgent((Properties)props, (RuleBaseConfiguration)conf);
        conf = ((InternalRuleBase)agent.getRuleBase()).getConfiguration();
        Assert.assertEquals((Object)true, (Object)conf.isSequential());
    }

    @Test
    public void testLoadSampleConfig() {
        RuleAgent ag = new RuleAgent(new RuleBaseConfiguration());
        Properties props = RuleAgent.loadFromProperties((String)"/sample-agent-config.properties");
        Assert.assertEquals((Object)"10", (Object)props.getProperty("poll"));
        Assert.assertEquals((Object)"/home/packages", (Object)props.getProperty("dir"));
        Assert.assertEquals((Object)"true", (Object)props.getProperty("newInstance"));
        this.assertEqualsIgnoreWhitespace("/foo/bar.pkg /wee/waa.pkg /wee/waa2.pkg", props.getProperty("file"));
    }

    @Test
    public void testLoadBasicAuthenticationSampleConfig() {
        RuleAgent ag = new RuleAgent(new RuleBaseConfiguration());
        Properties props = RuleAgent.loadFromProperties((String)"/basic-authentication-sample-agent-config.properties");
        Assert.assertEquals((Object)"30", (Object)props.getProperty("poll"));
        Assert.assertEquals((Object)"http://localhost:8080/guvnor-webapp/org.drools.guvnor.Guvnor/package/defaultPackage/LATEST", (Object)props.getProperty("url"));
        Assert.assertEquals((Object)"d:/drools", (Object)props.getProperty("localCacheDir"));
        Assert.assertEquals((Object)"true", (Object)props.getProperty("newInstance"));
        Assert.assertEquals((Object)"true", (Object)props.getProperty("enableBasicAuthentication"));
        Assert.assertEquals((Object)"admin", (Object)props.getProperty("username"));
        Assert.assertEquals((Object)"admin", (Object)props.getProperty("password"));
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testEventListenerSetup() throws Exception {
        RuleAgent ag = new RuleAgent(new RuleBaseConfiguration());
        Assert.assertNotNull((Object)ag.listener);
        final String[] name = new String[1];
        AgentEventListener list = new AgentEventListener(){

            public void debug(String message) {
            }

            public void exception(String message, Throwable e) {
            }

            public void exception(Throwable e) {
            }

            public void info(String message) {
            }

            public void warning(String message) {
            }

            public void setAgentName(String n) {
                name[0] = n;
            }

            public void debug(String message, Object object) {
            }

            public void info(String message, Object object) {
            }

            public void warning(String message, Object object) {
            }
        };
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p42_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = dir.getPath() + "/" + "p42_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("poll", "1");
        props.setProperty("name", "poo");
        ag = RuleAgent.newRuleAgent((Properties)props, (AgentEventListener)list);
        Assert.assertEquals((Object)list, (Object)ag.listener);
        Assert.assertEquals((Object)"poo", (Object)name[0]);
        ag.stopPolling();
    }

    @Test
    public void testPollSetup() throws Exception {
        Properties props = new Properties();
        props.setProperty("poll", "1");
        MockRuleAgent ag = new MockRuleAgent();
        ag.init(props);
        Assert.assertTrue((boolean)ag.isPolling());
        Assert.assertTrue((boolean)ag.refreshCalled);
        ag.refreshCalled = false;
        Assert.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(100L);
        Assert.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)ag.refreshCalled);
        ag.refreshCalled = false;
        Thread.sleep(100L);
        Assert.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)ag.refreshCalled);
        ag.stopPolling();
    }

    @Test
    public void testProviderMap() throws Exception {
        Assert.assertEquals((long)3L, (long)RuleAgent.PACKAGE_PROVIDERS.size());
        Assert.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("url"));
        Assert.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("file"));
        Assert.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("dir"));
        Assert.assertFalse((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("XXX"));
        Assert.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.get("url").equals(URLScanner.class));
    }

    @Test
    public void testLoadUpFromProperties() throws Exception {
        AnotherRuleAgentMock ag = new AnotherRuleAgentMock();
        Map oldMap = AnotherRuleAgentMock.PACKAGE_PROVIDERS;
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = new HashMap();
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("url", MockProvider.class);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("file", MockProvider.class);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("dir", MockProvider.class);
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream("/rule-agent-config.properties"));
        MockEventListener evl = new MockEventListener();
        ag.listener = evl;
        ag.init(props);
        Assert.assertTrue((boolean)ag.newInstance);
        Assert.assertEquals((long)3L, (long)ag.provs.size());
        Assert.assertEquals((long)30L, (long)ag.secondsToRefresh);
        Assert.assertEquals((Object)"MyConfig", (Object)evl.name);
        Assert.assertFalse((boolean)evl.exceptionCalled);
        Assert.assertFalse((boolean)evl.warningCalled);
        Assert.assertTrue((boolean)evl.infoCalled);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = oldMap;
    }

    @Test
    public void testLoadRuleBaseConfigurationProperties() throws Exception {
        AnotherRuleAgentMock ag = new AnotherRuleAgentMock();
        Map oldMap = AnotherRuleAgentMock.PACKAGE_PROVIDERS;
        RuleAgent.PACKAGE_PROVIDERS = new HashMap();
        RuleAgent.PACKAGE_PROVIDERS.put("url", MockProvider.class);
        RuleAgent.PACKAGE_PROVIDERS.put("file", MockProvider.class);
        RuleAgent.PACKAGE_PROVIDERS.put("dir", MockProvider.class);
        Properties props = new Properties();
        MockEventListener evl = new MockEventListener();
        ag.listener = evl;
        props.load(this.getClass().getResourceAsStream("/rule-agent-config.properties"));
        ag.init(props, true);
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().isMaintainTms());
        Assert.assertFalse((boolean)ag.getRuleBaseConfiguration().isSequential());
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().getSequentialAgenda().equals(RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL));
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareAlphaNodes());
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareBetaNodes());
        props.load(this.getClass().getResourceAsStream("/rule-base-rule-agent-config.properties"));
        ag.init(props, true);
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().isMaintainTms());
        Assert.assertFalse((boolean)ag.getRuleBaseConfiguration().isSequential());
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().getSequentialAgenda().equals(RuleBaseConfiguration.SequentialAgenda.DYNAMIC));
        Assert.assertFalse((boolean)ag.getRuleBaseConfiguration().isShareAlphaNodes());
        Assert.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareBetaNodes());
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = oldMap;
    }

    class MockEventListener
    implements AgentEventListener {
        public String name;
        boolean exceptionCalled = false;
        boolean infoCalled = false;
        boolean warningCalled;

        MockEventListener() {
        }

        public void debug(String message) {
        }

        public void exception(String message, Throwable e) {
            this.exceptionCalled = true;
        }

        public void exception(Throwable e) {
            this.exceptionCalled = true;
        }

        public void info(String message) {
            if (message != null) {
                this.infoCalled = true;
            }
        }

        public void setAgentName(String name) {
            this.name = name;
        }

        public void warning(String message) {
            this.warningCalled = false;
        }

        public void debug(String message, Object object) {
        }

        public void info(String message, Object object) {
        }

        public void warning(String message, Object object) {
        }
    }

    class AnotherRuleAgentMock
    extends RuleAgent {
        public int secondsToRefresh;
        public List provs;
        public boolean newInstance;

        public AnotherRuleAgentMock() {
            super(new RuleBaseConfiguration());
        }

        synchronized void configure(boolean newInstance, List provs, int secondsToRefresh) {
            this.newInstance = newInstance;
            this.provs = provs;
            this.secondsToRefresh = secondsToRefresh;
        }
    }
}

