/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DoubleBetaConstraints;
import org.drools.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QuadroupleBetaConstraints;
import org.drools.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.SingleNonIndexSkipBetaConstraints;
import org.drools.common.TripleBetaConstraints;
import org.drools.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ConcurrentRightTuple;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MemoryVisitor;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Behavior;
import org.drools.rule.BehaviorManager;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
NodeMemory {
    protected LeftTupleSource leftInput;
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    protected BehaviorManager behavior;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean concurrentRightTupleMemory = false;
    protected boolean lrUnlinkingEnabled = false;
    private boolean indexedUnificationJoin;

    public BetaNode() {
    }

    BetaNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, Behavior[] behaviors) {
        super(id, partitionId, partitionsEnabled);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.constraints = constraints;
        this.behavior = new BehaviorManager(behaviors);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.setUnificationJoin();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.behavior = (BehaviorManager)in.readObject();
        this.leftInput = (LeftTupleSource)in.readObject();
        this.rightInput = (ObjectSource)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        this.concurrentRightTupleMemory = in.readBoolean();
        this.lrUnlinkingEnabled = in.readBoolean();
        this.setUnificationJoin();
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        BetaNodeFieldConstraint c;
        LinkedList list = this.constraints.getConstraints();
        if (!list.isEmpty() && DefaultBetaConstraints.isIndexable(c = (BetaNodeFieldConstraint)((LinkedListEntry)list.getFirst()).getObject()) && ((VariableConstraint)c).getRestriction() instanceof UnificationRestriction) {
            this.constraints = this.constraints.getOriginalConstraint();
        }
        out.writeObject(this.constraints);
        out.writeObject(this.behavior);
        out.writeObject(this.leftInput);
        out.writeObject(this.rightInput);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.concurrentRightTupleMemory);
        out.writeBoolean(this.lrUnlinkingEnabled);
        super.writeExternal(out);
    }

    public void setUnificationJoin() {
        BetaNodeFieldConstraint c;
        LinkedList list = this.constraints.getConstraints();
        if (!list.isEmpty() && DefaultBetaConstraints.isIndexable(c = (BetaNodeFieldConstraint)((LinkedListEntry)list.getFirst()).getObject()) && ((VariableConstraint)c).getRestriction() instanceof UnificationRestriction) {
            if (this.constraints instanceof SingleBetaConstraints) {
                this.constraints = new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof DoubleBetaConstraints) {
                this.constraints = new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof TripleBetaConstraints) {
                this.constraints = new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                this.constraints = new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints);
            }
            this.indexedUnificationJoin = true;
        }
    }

    public FastIterator getRightIterator(RightTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public FastIterator getLeftIterator(LeftTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public RightTuple getFirstRightTuple(LeftTuple leftTuple, RightTupleMemory memory, PropagationContext context, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
        }
        return (RightTuple)it.next(null);
    }

    public LeftTuple getFirstLeftTuple(RightTuple rightTuple, LeftTupleMemory memory, PropagationContext context, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(rightTuple);
        }
        return (LeftTuple)it.next(null);
    }

    public static RightTuple getFirstRightTuple(RightTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null, null);
        }
        return (RightTuple)it.next(null);
    }

    public static LeftTuple getFirstLeftTuple(LeftTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return (LeftTuple)it.next(null);
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        LinkedList constraints = this.constraints.getConstraints();
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[constraints.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)constraints.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
        }
        return array;
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void attach() {
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this);
    }

    @Override
    public void networkUpdated() {
        this.rightInput.networkUpdated();
        this.leftInput.networkUpdated();
    }

    public List<String> getRules() {
        ArrayList<String> list = new ArrayList<String>();
        LeftTupleSink[] sinks = this.sink.getSinks();
        int length = sinks.length;
        for (int i = 0; i < length; ++i) {
            if (sinks[i] instanceof RuleTerminalNode) {
                list.add(((RuleTerminalNode)sinks[i]).getRule().getName());
                continue;
            }
            if (!(sinks[i] instanceof BetaNode)) continue;
            list.addAll(((BetaNode)sinks[i]).getRules());
        }
        return list;
    }

    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return (ObjectTypeNode)source;
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            if (!this.lrUnlinkingEnabled || this.lrUnlinkingEnabled && !(this instanceof JoinNode)) {
                this.rightInput.updateSink(this, propagationContext, workingMemory);
            }
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse() || context.getCleanupAdapter() != null) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                Entry tmp;
                BetaMemory memory = null;
                Memory object = workingMemory.getNodeMemory(this);
                memory = object instanceof AccumulateNode.AccumulateMemory ? ((AccumulateNode.AccumulateMemory)object).betaMemory : (BetaMemory)object;
                FastIterator it = memory.getLeftTupleMemory().fullFastIterator();
                LeftTuple leftTuple = BetaNode.getFirstLeftTuple(memory.getLeftTupleMemory(), it);
                while (leftTuple != null) {
                    tmp = (LeftTuple)it.next(leftTuple);
                    if (context.getCleanupAdapter() != null) {
                        LeftTuple child;
                        while ((child = leftTuple.getFirstChild()) != null) {
                            if (child.getLeftTupleSink() == this) {
                                child.unlinkFromLeftParent();
                                child.unlinkFromRightParent();
                                continue;
                            }
                            context.getCleanupAdapter().cleanUp(child, workingMemory);
                        }
                    }
                    memory.getLeftTupleMemory().remove(leftTuple);
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = tmp;
                }
                if (object instanceof AccumulateNode.AccumulateMemory) {
                    ((AccumulateNode)this).doRemove(workingMemory, (AccumulateNode.AccumulateMemory)object);
                }
                if (this.isInUse()) continue;
                it = memory.getRightTupleMemory().fullFastIterator();
                Entry rightTuple = BetaNode.getFirstRightTuple(memory.getRightTupleMemory(), it);
                while (rightTuple != null) {
                    tmp = (RightTuple)it.next(rightTuple);
                    if (rightTuple.getBlocked() != null) {
                        LeftTuple leftTuple2 = rightTuple.getBlocked();
                        while (leftTuple2 != null) {
                            LeftTuple temp = leftTuple2.getBlockedNext();
                            leftTuple2.setBlocker(null);
                            leftTuple2.setBlockedPrevious(null);
                            leftTuple2.setBlockedNext(null);
                            leftTuple2.unlinkFromLeftParent();
                            leftTuple2 = temp;
                        }
                    }
                    this.behavior.retractRightTuple(memory.getBehaviorContext(), (RightTuple)rightTuple, workingMemory);
                    memory.getRightTupleMemory().remove((RightTuple)rightTuple);
                    rightTuple.unlinkFromRightParent();
                    rightTuple = tmp;
                }
                workingMemory.clearNodeMemory(this);
            }
            context.setCleanupAdapter(null);
        }
        this.rightInput.remove(context, builder, this, workingMemories);
        this.leftInput.remove(context, builder, this, workingMemories);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = modifyPreviousTuples.removeRightTuple(this);
        if (rightTuple != null) {
            rightTuple.reAdd();
            this.modifyRightTuple(rightTuple, context, workingMemory);
        } else {
            this.assertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(this.createLeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public boolean isConcurrentRightTupleMemory() {
        return this.concurrentRightTupleMemory;
    }

    public void setConcurrentRightTupleMemory(boolean concurrentRightTupleMemory) {
        this.concurrentRightTupleMemory = concurrentRightTupleMemory;
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints);
    }

    protected Memory createMemory(RuleBaseConfiguration config, short nodeType) {
        BetaMemory memory = this.constraints.createBetaMemory(config, nodeType);
        memory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink) {
        if (!this.concurrentRightTupleMemory) {
            return new RightTuple(handle, sink);
        }
        return new ConcurrentRightTuple(handle, sink);
    }

    protected boolean leftUnlinked(PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory) {
        if (memory.isLeftUnlinked()) {
            return true;
        }
        if (memory.isRightUnlinked()) {
            memory.linkRight();
            context.setShouldPropagateAll(this);
            this.rightInput.updateSink(this, context, workingMemory);
        }
        return false;
    }

    protected boolean rightUnlinked(PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory) {
        if (memory.isRightUnlinked()) {
            return true;
        }
        if (memory.isLeftUnlinked()) {
            memory.linkLeft();
            context.setShouldPropagateAll(this);
            this.leftInput.updateSink(this, context, workingMemory);
        }
        return false;
    }
}

