/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.junit.Assert;
import org.junit.Test;

public class BigDecimalEqualityTest {
    @Test
    public void testEquality() {
        EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator d = new EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator();
        Assert.assertTrue((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("42"))));
        Assert.assertFalse((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("43"))));
        Assert.assertTrue((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42.0")), null, (FieldValue)new MockFieldValue(new BigDecimal("42"))));
        Assert.assertFalse((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("43.0"))));
        Assert.assertTrue((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)new BigDecimal("42"), (Object)new BigDecimal("42")));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)new BigDecimal("42"), (Object)new BigDecimal("43")));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)new BigDecimal("42"), (Object)43));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)new BigDecimal("42"), (Object)"43"));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)new BigDecimal("42"), (Object)42.0));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)43, (Object)43));
        Assert.assertFalse((boolean)EqualityEvaluatorsDefinition.BigDecimalEqualEvaluator.isEqual((Object)"43", (Object)new BigDecimal("43")));
    }

    @Test
    public void testNotEquals() {
        EqualityEvaluatorsDefinition.BigDecimalNotEqualEvaluator d = new EqualityEvaluatorsDefinition.BigDecimalNotEqualEvaluator();
        Assert.assertFalse((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("42"))));
        Assert.assertTrue((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("43"))));
        Assert.assertFalse((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42.0")), null, (FieldValue)new MockFieldValue(new BigDecimal("42"))));
        Assert.assertTrue((boolean)d.evaluate(null, (InternalReadAccessor)new MockInternalReadAcessor(new BigDecimal("42")), null, (FieldValue)new MockFieldValue(new BigDecimal("43.0"))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockInternalReadAcessor
    implements InternalReadAccessor {
        private Object val;

        MockInternalReadAcessor(Object val) {
            this.val = val;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return this.val;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }

        public Object getValue(Object object) {
            return null;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public ValueType getValueType() {
            return null;
        }

        public Class<?> getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIndex() {
            return 0;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return (BigDecimal)this.val;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return (BigInteger)this.val;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return (BigDecimal)this.val;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return (BigInteger)this.val;
        }
    }

    class MockFieldValue
    implements FieldValue {
        private BigDecimal val;

        MockFieldValue(BigDecimal bd) {
            this.val = bd;
        }

        public Object getValue() {
            return null;
        }

        public char getCharValue() {
            return '\u0000';
        }

        public BigDecimal getBigDecimalValue() {
            return this.val;
        }

        public BigInteger getBigIntegerValue() {
            return null;
        }

        public int getIntValue() {
            return 0;
        }

        public byte getByteValue() {
            return 0;
        }

        public short getShortValue() {
            return 0;
        }

        public long getLongValue() {
            return 0L;
        }

        public float getFloatValue() {
            return 0.0f;
        }

        public double getDoubleValue() {
            return 0.0;
        }

        public boolean getBooleanValue() {
            return false;
        }

        public boolean isNull() {
            return false;
        }

        public boolean isBooleanField() {
            return false;
        }

        public boolean isIntegerNumberField() {
            return false;
        }

        public boolean isFloatNumberField() {
            return false;
        }

        public boolean isObjectField() {
            return false;
        }

        public boolean isCollectionField() {
            return false;
        }

        public boolean isStringField() {
            return false;
        }
    }
}

