/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.ClassBuilderFactory;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.util.ClassLoaderUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassBuilderTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    ClassLoader classLoader;
    JavaDialectRuntimeData data;

    @Before
    public void setUp() throws Exception {
        this.data = new JavaDialectRuntimeData();
    }

    private Class build(ClassBuilder builder, ClassDefinition classDef) throws Exception {
        byte[] d = builder.buildClass(classDef);
        this.data.write(JavaDialectRuntimeData.convertClassToResourcePath((String)classDef.getClassName()), d);
        this.classLoader = new JavaDialectRuntimeData.PackageClassLoader(this.data, ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        this.store = new ClassFieldAccessorStore();
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.classLoader));
        this.store.setEagerWire(true);
        Class<?> clazz = this.classLoader.loadClass(classDef.getClassName());
        classDef.setDefinedClass(clazz);
        return clazz;
    }

    @Test
    public void testBuildClass() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass1", null, new String[]{"java.io.Serializable"});
            FieldDefinition intDef = new FieldDefinition("intAttr", "int");
            FieldDefinition stringDef = new FieldDefinition("stringAttr", "java.lang.String");
            classDef.addField(intDef);
            classDef.addField(stringDef);
            Class clazz = this.build(builder, classDef);
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            stringDef.setReadWriteAccessor(this.store.getAccessor(clazz, stringDef.getName(), this.classLoader));
            byte[] d = builder.buildClass(classDef);
            Assert.assertSame((String)"Returned class should be the same", (Object)clazz, (Object)classDef.getDefinedClass());
            Assert.assertEquals((String)"Class name should be equal", (Object)classDef.getClassName(), (Object)clazz.getName());
            Serializable instance = (Serializable)clazz.newInstance();
            String stringValue = "Atributo String ok";
            stringDef.setValue((Object)instance, (Object)stringValue);
            Assert.assertEquals((String)"Attribute should have been correctly set", (Object)stringValue, (Object)stringDef.getValue((Object)instance));
            int intValue = 50;
            intDef.setValue((Object)instance, (Object)new Integer(intValue));
            Assert.assertEquals((String)"Attribute should have been correctly set", (long)intValue, (long)((Integer)intDef.getValue((Object)instance)).intValue());
            clazz = this.build(builder, classDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Error creating class");
        }
    }

    private void writeJar(byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File("/Users/michaelneale/edson.jar"));
        JarOutputStream jout = new JarOutputStream(out);
        JarEntry je = new JarEntry("br/com/auster/TestClass1.class");
        jout.putNextEntry(je);
        jout.write(data);
        jout.closeEntry();
        jout.close();
    }

    @Test
    public void testEquals() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass2", null, new String[0]);
            FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
            FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
            FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
            FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
            FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
            classDef.addField(long1Def);
            classDef.addField(long2Def);
            classDef.addField(doubleDef);
            classDef.addField(intDef);
            classDef.addField(strDef);
            classDef.addField(dateDef);
            classDef.addField(str2Def);
            Class clazz = this.build(builder, classDef);
            long1Def.setReadWriteAccessor(this.store.getAccessor(clazz, long1Def.getName(), this.classLoader));
            long2Def.setReadWriteAccessor(this.store.getAccessor(clazz, long2Def.getName(), this.classLoader));
            doubleDef.setReadWriteAccessor(this.store.getAccessor(clazz, doubleDef.getName(), this.classLoader));
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            dateDef.setReadWriteAccessor(this.store.getAccessor(clazz, dateDef.getName(), this.classLoader));
            str2Def.setReadWriteAccessor(this.store.getAccessor(clazz, str2Def.getName(), this.classLoader));
            Object x = clazz.newInstance();
            Object y = clazz.newInstance();
            long1Def.setValue(x, (Object)new Long(20L));
            long2Def.setValue(x, (Object)new Long(30L));
            doubleDef.setValue(x, (Object)new Double(50.0));
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            dateDef.setValue(x, (Object)new Date(1000L));
            str2Def.setValue(x, (Object)"instance1");
            long1Def.setValue(y, (Object)new Long(20L));
            long2Def.setValue(y, (Object)new Long(30L));
            doubleDef.setValue(y, (Object)new Double(50.0));
            intDef.setValue(y, (Object)new Integer(10));
            strDef.setValue(y, (Object)"abc");
            dateDef.setValue(y, (Object)new Date(1000L));
            str2Def.setValue(y, (Object)"instance2");
            Object o = new Object();
            Assert.assertTrue((boolean)x.equals(x));
            Assert.assertFalse((boolean)x.equals(null));
            Assert.assertFalse((boolean)x.equals(o));
            Assert.assertTrue((boolean)x.equals(y));
            intDef.setValue(y, (Object)new Integer(1));
            Assert.assertFalse((boolean)x.equals(y));
            intDef.setValue(y, (Object)new Integer(10));
            strDef.setValue(y, (Object)"xyz");
            Assert.assertFalse((boolean)x.equals(y));
            strDef.setValue(y, null);
            Assert.assertFalse((boolean)x.equals(y));
            strDef.setValue(y, (Object)"abc");
            dateDef.setValue(y, (Object)new Date(1L));
            Assert.assertFalse((boolean)x.equals(y));
            dateDef.setValue(y, null);
            Assert.assertFalse((boolean)x.equals(y));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    @Test
    public void testHashCode() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass3", null, new String[0]);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", false);
            classDef.addField(intDef);
            classDef.addField(strDef);
            Class clazz = this.build(builder, classDef);
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            Object x = clazz.newInstance();
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            Assert.assertEquals((String)"Wrong hashcode calculation", (long)41L, (long)x.hashCode());
            Assert.assertEquals((String)"Wrong hashcode calculation", (long)x.hashCode(), (long)x.hashCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    @Test
    public void testToString() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass4", null, new String[0]);
            FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
            FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
            FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
            FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
            FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
            classDef.addField(long1Def);
            classDef.addField(long2Def);
            classDef.addField(doubleDef);
            classDef.addField(intDef);
            classDef.addField(strDef);
            classDef.addField(dateDef);
            classDef.addField(str2Def);
            Class clazz = this.build(builder, classDef);
            long1Def.setReadWriteAccessor(this.store.getAccessor(clazz, long1Def.getName(), this.classLoader));
            long2Def.setReadWriteAccessor(this.store.getAccessor(clazz, long2Def.getName(), this.classLoader));
            doubleDef.setReadWriteAccessor(this.store.getAccessor(clazz, doubleDef.getName(), this.classLoader));
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            dateDef.setReadWriteAccessor(this.store.getAccessor(clazz, dateDef.getName(), this.classLoader));
            str2Def.setReadWriteAccessor(this.store.getAccessor(clazz, str2Def.getName(), this.classLoader));
            Object x = clazz.newInstance();
            long1Def.setValue(x, (Object)new Long(20L));
            long2Def.setValue(x, (Object)new Long(30L));
            doubleDef.setValue(x, (Object)new Double(50.0));
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            dateDef.setValue(x, (Object)new Date(1000L));
            str2Def.setValue(x, (Object)"instance1");
            String result = x.toString();
            Assert.assertTrue((boolean)result.contains(long1Def.getName()));
            Assert.assertTrue((boolean)result.contains(long2Def.getName()));
            Assert.assertTrue((boolean)result.contains(doubleDef.getName()));
            Assert.assertTrue((boolean)result.contains(intDef.getName()));
            Assert.assertTrue((boolean)result.contains(strDef.getName()));
            Assert.assertTrue((boolean)result.contains(dateDef.getName()));
            Assert.assertTrue((boolean)result.contains(str2Def.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    @Test
    public void testConstructorWithFields() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass5", null, new String[0]);
            String[] types = new String[]{"byte", "short", "int", "long", "float", "double", "char", "java.lang.String", "boolean"};
            FieldDefinition[] fields = new FieldDefinition[types.length];
            for (int i = 0; i < types.length; ++i) {
                String attrName = types[i].substring(types[i].lastIndexOf(46) + 1);
                attrName = attrName.substring(0, 1).toLowerCase() + attrName.substring(1) + "Attr";
                fields[i] = new FieldDefinition(attrName, types[i], i % 2 == 0);
                classDef.addField(fields[i]);
            }
            Class clazz = this.build(builder, classDef);
            for (FieldDefinition field : fields) {
                field.setReadWriteAccessor(this.store.getAccessor(clazz, field.getName(), this.classLoader));
            }
            Constructor<?>[] cons = clazz.getConstructors();
            Assert.assertEquals((long)3L, (long)cons.length);
            for (Constructor<?> c : cons) {
                Class<?>[] ptypes = c.getParameterTypes();
                if (ptypes.length == 0) continue;
                if (ptypes.length == fields.length) {
                    for (int i = 0; i < ptypes.length; ++i) {
                        if (ptypes[i].equals(fields[i].getType())) continue;
                        Assert.fail((String)("Wrong parameter in constructor. index=" + i + " expected=" + fields[i].getType() + " found=" + ptypes[i]));
                    }
                    Object instance = c.newInstance((byte)1, (short)2, 3, 4L, Float.valueOf(5.0f), 6.0, Character.valueOf('a'), "xyz", true);
                    Assert.assertEquals((Object)1, (Object)fields[0].getValue(instance));
                    Assert.assertEquals((Object)2, (Object)fields[1].getValue(instance));
                    Assert.assertEquals((Object)3, (Object)fields[2].getValue(instance));
                    Assert.assertEquals((Object)4L, (Object)fields[3].getValue(instance));
                    Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)fields[4].getValue(instance));
                    Assert.assertEquals((Object)6.0, (Object)fields[5].getValue(instance));
                    Assert.assertEquals((Object)Character.valueOf('a'), (Object)fields[6].getValue(instance));
                    Assert.assertEquals((Object)"xyz", (Object)fields[7].getValue(instance));
                    Assert.assertEquals((Object)true, (Object)fields[8].getValue(instance));
                    continue;
                }
                if (ptypes.length == fields.length / 2 + 1) {
                    int i = 0;
                    for (FieldDefinition field : fields) {
                        if (!field.isKey() || ptypes[i++].equals(field.getType())) continue;
                        Assert.fail((String)("Wrong parameter in constructor. index=" + i + " expected=" + field.getType() + " found=" + ptypes[i]));
                    }
                    Object instance = c.newInstance((byte)1, 3, Float.valueOf(5.0f), Character.valueOf('a'), true);
                    Assert.assertEquals((Object)1, (Object)fields[0].getValue(instance));
                    Assert.assertEquals((Object)3, (Object)fields[2].getValue(instance));
                    Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)fields[4].getValue(instance));
                    Assert.assertEquals((Object)Character.valueOf('a'), (Object)fields[6].getValue(instance));
                    Assert.assertEquals((Object)true, (Object)fields[8].getValue(instance));
                    continue;
                }
                Assert.fail((String)("Unexpected constructor: " + c.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected Exception: " + e.getMessage()));
        }
    }

    @Test
    public void testGetResourcesJBRULES3122() {
        try {
            ClassBuilder builder = ClassBuilderFactory.getBeanClassBuilderService();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass4", null, new String[0]);
            Class clazz = this.build(builder, classDef);
            ClassLoader cl = clazz.getClassLoader();
            Assert.assertFalse((boolean)cl.getResources("not-there.txt").hasMoreElements());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception not expected: " + e.getMessage()));
        }
    }
}

