/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.BinaryHeapQueueAgendaGroup;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EqualityKey;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.NamedEntryPoint;
import org.drools.common.NodeMemory;
import org.drools.common.ObjectStore;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QueryElementFactHandle;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.concurrent.ExecutorService;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.StringUtils;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProcessMarshaller;
import org.drools.marshalling.impl.ProcessMarshallerFactory;
import org.drools.marshalling.impl.RightTupleKey;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryElementNode;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EntryPoint;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.SlidingLengthWindow;
import org.drools.rule.SlidingTimeWindow;
import org.drools.runtime.Environment;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.Activation;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.time.Trigger;
import org.drools.time.impl.CronTrigger;
import org.drools.time.impl.IntervalTrigger;
import org.drools.time.impl.PointInTimeTrigger;
import org.drools.time.impl.PseudoClockScheduler;

public class InputMarshaller {
    private static ProcessMarshaller processMarshaller = InputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ReteooStatefulSession readSession(ReteooStatefulSession session, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        long time = context.readLong();
        int handleId = context.readInt();
        long handleCounter = context.readLong();
        long propagationCounter = context.readLong();
        context.readInt();
        context.readLong();
        session.reset(handleId, handleCounter, propagationCounter);
        DefaultAgenda agenda = (DefaultAgenda)session.getAgenda();
        InputMarshaller.readAgenda(context, agenda);
        return InputMarshaller.readSession(session, agenda, time, multithread, context);
    }

    public static ReteooStatefulSession readSession(MarshallerReaderContext context, int id, ExecutorService executor) throws IOException, ClassNotFoundException {
        return InputMarshaller.readSession(context, id, executor, EnvironmentFactory.newEnvironment(), SessionConfiguration.getDefaultInstance());
    }

    public static ReteooStatefulSession readSession(MarshallerReaderContext context, int id, ExecutorService executor, Environment environment, SessionConfiguration config) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        long time = context.readLong();
        FactHandleFactory handleFactory = context.ruleBase.newFactHandleFactory(context.readInt(), context.readLong());
        long propagationCounter = context.readLong();
        DefaultFactHandle initialFactHandle = new DefaultFactHandle(context.readInt(), InitialFactImpl.getInstance(), context.readLong(), null);
        context.handles.put(initialFactHandle.getId(), initialFactHandle);
        DefaultAgenda agenda = new DefaultAgenda(context.ruleBase, false);
        InputMarshaller.readAgenda(context, agenda);
        ReteooStatefulSession session = new ReteooStatefulSession(id, context.ruleBase, executor, handleFactory, initialFactHandle, propagationCounter, config, agenda, environment);
        new StatefulKnowledgeSessionImpl(session);
        initialFactHandle.setEntryPoint(session.getEntryPoints().get(EntryPoint.DEFAULT.getEntryPointId()));
        return InputMarshaller.readSession(session, agenda, time, multithread, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReteooStatefulSession readSession(ReteooStatefulSession session, DefaultAgenda agenda, long time, boolean multithread, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        if (session.getTimerService() instanceof PseudoClockScheduler) {
            PseudoClockScheduler clock = (PseudoClockScheduler)session.getTimerService();
            clock.advanceTime(time, TimeUnit.MILLISECONDS);
        }
        for (RuleFlowGroup group : agenda.getRuleFlowGroupsMap().values()) {
            ((RuleFlowGroupImpl)group).setWorkingMemory(session);
        }
        context.wm = session;
        context.handles.put(context.wm.getInitialFactHandle().getId(), context.wm.getInitialFactHandle());
        if (context.stream.readBoolean()) {
            InternalFactHandle initialFactHandle = context.wm.getInitialFactHandle();
            int sinkId = context.stream.readInt();
            ObjectTypeNode initialFactNode = (ObjectTypeNode)context.sinks.get(sinkId);
            if (initialFactNode == null) {
                EntryPointNode defaultEPNode = context.ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT);
                BuildContext buildContext = new BuildContext(context.ruleBase, context.ruleBase.getReteooBuilder().getIdGenerator());
                buildContext.setPartitionId(RuleBasePartitionId.MAIN_PARTITION);
                buildContext.setObjectTypeNodeMemoryEnabled(true);
                initialFactNode = new ObjectTypeNode(sinkId, defaultEPNode, ClassObjectType.InitialFact_ObjectType, buildContext);
                context.ruleBase.lock();
                try {
                    InternalWorkingMemory[] wms = buildContext.getWorkingMemories();
                    if (wms.length > 0) {
                        initialFactNode.attach(wms);
                    } else {
                        initialFactNode.attach();
                    }
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    context.ruleBase.unlock();
                    throw throwable;
                }
                context.ruleBase.unlock();
                {
                }
            }
            ObjectHashSet initialFactMemory = (ObjectHashSet)((Object)context.wm.getNodeMemory(initialFactNode));
            initialFactMemory.add(initialFactHandle);
            InputMarshaller.readRightTuples(initialFactHandle, context);
        }
        while (context.readShort() == 90) {
            String entryPointId = context.stream.readUTF();
            WorkingMemoryEntryPoint wmep = context.wm.getEntryPoints().get(entryPointId);
            InputMarshaller.readFactHandles(context, ((NamedEntryPoint)wmep).getObjectStore());
        }
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        while (context.stream.readShort() == 3) {
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(context.stream.readInt()));
            LeftTuple leftTuple = sink.createLeftTuple(handle, sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
        InputMarshaller.readPropagationContexts(context);
        InputMarshaller.readActivations(context);
        InputMarshaller.readActionQueue(context);
        InputMarshaller.readTruthMaintenanceSystem(context);
        if (processMarshaller != null) {
            processMarshaller.readProcessInstances(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        if (processMarshaller != null) {
            processMarshaller.readWorkItems(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        if (processMarshaller != null) {
            processMarshaller.readProcessTimers(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        while (context.readShort() == 50) {
            InputMarshaller.readTimer(context);
        }
        if (multithread) {
            session.startPartitionManagers();
        }
        return session;
    }

    public static void readAgenda(MarshallerReaderContext context, DefaultAgenda agenda) throws IOException {
        MarshallerReaderContext stream = context.stream;
        agenda.setDormantActivations(stream.readInt());
        agenda.setActiveActivations(stream.readInt());
        while (stream.readShort() == 13) {
            BinaryHeapQueueAgendaGroup group = new BinaryHeapQueueAgendaGroup(stream.readUTF(), context.ruleBase);
            group.setActive(stream.readBoolean());
            agenda.getAgendaGroupsMap().put(group.getName(), group);
        }
        while (stream.readShort() == 13) {
            String agendaGroupName = stream.readUTF();
            agenda.addAgendaGroupOnStack(agenda.getAgendaGroup(agendaGroupName));
        }
        while (stream.readShort() == 15) {
            String rfgName = stream.readUTF();
            boolean active = stream.readBoolean();
            boolean autoDeactivate = stream.readBoolean();
            RuleFlowGroupImpl rfg = new RuleFlowGroupImpl(rfgName, active, autoDeactivate);
            agenda.getRuleFlowGroupsMap().put(rfgName, rfg);
            int nbNodeInstances = stream.readInt();
            for (int i = 0; i < nbNodeInstances; ++i) {
                Long processInstanceId = stream.readLong();
                String nodeInstanceId = stream.readUTF();
                rfg.addNodeInstance(processInstanceId, nodeInstanceId);
            }
        }
    }

    public static void readActionQueue(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        Queue<WorkingMemoryAction> actionQueue = wm.getActionQueue();
        while (context.readShort() == 10) {
            actionQueue.offer(PersisterHelper.readWorkingMemoryAction(context));
        }
    }

    public static void readTruthMaintenanceSystem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        TruthMaintenanceSystem tms = context.wm.getTruthMaintenanceSystem();
        while (stream.readShort() == 11) {
            int status = stream.readInt();
            int factHandleId = stream.readInt();
            InternalFactHandle handle = context.handles.get(factHandleId);
            ObjectTypeConf typeConf = context.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.wm.getEntryPoint(), handle.getObject());
            if (!typeConf.isTMSEnabled()) {
                typeConf.enableTMS();
            }
            EqualityKey key = new EqualityKey(handle, status);
            handle.setEqualityKey(key);
            while (stream.readShort() == 2) {
                factHandleId = stream.readInt();
                handle = context.handles.get(factHandleId);
                key.addFactHandle(handle);
                handle.setEqualityKey(key);
            }
            tms.put(key);
        }
    }

    public static void readFactHandles(MarshallerReaderContext context, ObjectStore objectStore) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        int size = stream.readInt();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        for (int i = 0; i < size; ++i) {
            InternalFactHandle handle = InputMarshaller.readFactHandle(context);
            context.handles.put(handle.getId(), handle);
            handles[i] = handle;
            if (handle.getObject() != null) {
                objectStore.addHandle(handle, handle.getObject());
            }
            InputMarshaller.readRightTuples(handle, context);
        }
        InputMarshaller.readLeftTuples(context);
        if (stream.readBoolean()) {
            InputMarshaller.readLeftTuples(context);
        }
        for (InternalFactHandle factHandle : handles) {
            Object object = factHandle.getObject();
            EntryPoint ep = ((InternalWorkingMemoryEntryPoint)factHandle.getEntryPoint()).getEntryPoint();
            ObjectTypeConf typeConf = ((InternalWorkingMemoryEntryPoint)factHandle.getEntryPoint()).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, object);
            ObjectTypeNode[] cachedNodes = typeConf.getObjectTypeNodes();
            int length = cachedNodes.length;
            for (int i = 0; i < length; ++i) {
                ObjectHashSet set = (ObjectHashSet)((Object)wm.getNodeMemory(cachedNodes[i]));
                set.add(factHandle, false);
            }
        }
    }

    public static InternalFactHandle readFactHandle(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        String entryPointId;
        String strategyClassName;
        int type = context.stream.readInt();
        int id = context.stream.readInt();
        long recency = context.stream.readLong();
        long startTimeStamp = 0L;
        long duration = 0L;
        boolean expired = false;
        long activationsCount = 0L;
        if (type == 2) {
            startTimeStamp = context.stream.readLong();
            duration = context.stream.readLong();
            expired = context.stream.readBoolean();
            activationsCount = context.stream.readLong();
        }
        int strategyIndex = context.stream.readInt();
        Object object = null;
        ObjectMarshallingStrategy strategy = null;
        if (strategyIndex >= 0) {
            strategy = context.resolverStrategyFactory.getStrategy(strategyIndex);
        } else if (strategyIndex == -2 && !StringUtils.isEmpty(strategyClassName = context.stream.readUTF()) && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName)) == null) {
            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
        }
        if (strategy != null) {
            object = strategy.read((ObjectInputStream)context.stream);
        }
        WorkingMemoryEntryPoint entryPoint = null;
        if (context.readBoolean() && (entryPointId = context.readUTF()) != null && !entryPointId.equals("")) {
            entryPoint = context.wm.getEntryPoints().get(entryPointId);
        }
        InternalFactHandle handle = null;
        switch (type) {
            case 0: {
                handle = new DefaultFactHandle(id, object, recency, entryPoint);
                break;
            }
            case 1: {
                handle = new QueryElementFactHandle(object, id, recency);
                break;
            }
            case 2: {
                handle = new EventFactHandle(id, object, recency, startTimeStamp, duration, entryPoint);
                ((EventFactHandle)handle).setExpired(expired);
                ((EventFactHandle)handle).setActivationsCount(activationsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to marshal FactHandle, as type does not exist:" + type);
            }
        }
        return handle;
    }

    public static void readRightTuples(InternalFactHandle factHandle, MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 4) {
            InputMarshaller.readRightTuple(context, factHandle);
        }
    }

    public static void readRightTuple(MarshallerReaderContext context, InternalFactHandle factHandle) throws IOException {
        MarshallerReaderContext stream = context.stream;
        int sinkId = stream.readInt();
        RightTupleSink sink = sinkId >= 0 ? (RightTupleSink)((Object)context.sinks.get(sinkId)) : null;
        RightTuple rightTuple = new RightTuple(factHandle, sink);
        context.rightTuples.put(new RightTupleKey(factHandle.getId(), sink), rightTuple);
        if (sink != null) {
            BetaMemory memory = null;
            switch (sink.getType()) {
                case 6: {
                    memory = ((AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((NodeMemory)((BetaNode)sink))).betaMemory;
                    break;
                }
                default: {
                    memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                }
            }
            memory.getRightTupleMemory().add(rightTuple);
            memory.linkLeft();
        }
    }

    public static void readLeftTuples(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 3) {
            int nodeId = stream.readInt();
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(nodeId));
            int factHandleId = stream.readInt();
            LeftTuple leftTuple = sink.createLeftTuple(context.handles.get(factHandleId), sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
    }

    public static void readLeftTuple(LeftTuple parentLeftTuple, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        Map<Integer, BaseNode> sinks = context.sinks;
        LeftTupleSink sink = parentLeftTuple.getLeftTupleSink();
        block0 : switch (sink.getType()) {
            case 0: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                InputMarshaller.readBehaviors((BetaNode)sink, memory, context);
                InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                while (stream.readShort() == 4) {
                    int childSinkId = stream.readInt();
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(childSinkId));
                    int factHandleId = stream.readInt();
                    RightTupleKey key = new RightTupleKey(factHandleId, sink);
                    RightTuple rightTuple = context.rightTuples.get(key);
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, rightTuple, null, null, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 3: {
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 1: 
            case 10: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                InputMarshaller.readBehaviors((BetaNode)sink, memory, context);
                short type = stream.readShort();
                if (type == 7) {
                    InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                    while (stream.readShort() == 3) {
                        LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                        LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, true);
                        InputMarshaller.readLeftTuple(childLeftTuple, context);
                    }
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(parentLeftTuple);
                break;
            }
            case 2: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                InputMarshaller.readBehaviors((BetaNode)sink, memory, context);
                short type = stream.readShort();
                if (type == 7) {
                    InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(parentLeftTuple);
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 6: {
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                InputMarshaller.readBehaviors((BetaNode)sink, memory.betaMemory, context);
                AccumulateNode.AccumulateContext accctx = new AccumulateNode.AccumulateContext();
                parentLeftTuple.setObject(accctx);
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                accctx.result = new RightTuple(handle, (RightTupleSink)((Object)sink));
                accctx.context = (Serializable[])stream.readObject();
                accctx.propagated = stream.readBoolean();
                int head = -1;
                block20: while (true) {
                    short s = stream.readShort();
                    head = s;
                    if (s == 1) break block0;
                    switch (head) {
                        case 4: {
                            int factHandleId = stream.readInt();
                            RightTupleKey key = new RightTupleKey(factHandleId, sink);
                            RightTuple rightTuple = context.rightTuples.get(key);
                            sink.createLeftTuple(parentLeftTuple, rightTuple, null, null, sink, true);
                            continue block20;
                        }
                        case 3: {
                            int sinkId = stream.readInt();
                            LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(sinkId));
                            LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, accctx.result, childSink, true);
                            InputMarshaller.readLeftTuple(childLeftTuple, context);
                            continue block20;
                        }
                    }
                    break;
                }
                throw new RuntimeDroolsException("Marshalling error. This is a bug. Please contact the development team.");
            }
            case 7: {
                ObjectHashMap memory = (ObjectHashMap)((Object)context.wm.getNodeMemory((NodeMemory)((Object)sink)));
                int id = stream.readInt();
                long recency = stream.readLong();
                DefaultFactHandle handle = new DefaultFactHandle(id, parentLeftTuple, recency, context.wm.getEntryPoints().get(EntryPoint.DEFAULT.getEntryPointId()));
                memory.put(parentLeftTuple, handle);
                InputMarshaller.readRightTuples(handle, context);
                stream.readShort();
                break;
            }
            case 4: {
                FromNode.FromMemory memory = (FromNode.FromMemory)context.wm.getNodeMemory((NodeMemory)((Object)sink));
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                LinkedHashMap<Object, RightTuple> matches = new LinkedHashMap<Object, RightTuple>();
                parentLeftTuple.setObject(matches);
                while (stream.readShort() == 2) {
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    InputMarshaller.readRightTuples(handle, context);
                    matches.put(handle.getObject(), handle.getFirstRightTuple());
                }
                while (stream.readShort() == 4) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    int factHandleId = stream.readInt();
                    RightTupleKey key = new RightTupleKey(factHandleId, null);
                    RightTuple rightTuple = context.rightTuples.get(key);
                    LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, rightTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 11: {
                boolean isOpen = context.readBoolean();
                if (isOpen) {
                    QueryElementNode node = (QueryElementNode)sink;
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    node.createDroolsQuery(parentLeftTuple, handle, context.wm);
                    InputMarshaller.readLeftTuples(context);
                    break;
                }
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    RightTuple rightTuple = new RightTuple(handle);
                    LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, rightTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 9: {
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(pos, parentLeftTuple);
                break;
            }
            case 8: {
                boolean unificationNode = context.readBoolean();
                if (!unificationNode) break;
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                context.handles.put(handle.getId(), handle);
                RightTuple rightTuple = new RightTuple(handle);
                parentLeftTuple.setObject(rightTuple);
                LeftTuple entry = parentLeftTuple;
                while (entry.getParent() != null) {
                    entry = entry.getParent();
                }
                DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
                LeftTuple leftTuple = ((QueryElementNode.UnificationNodeViewChangedEventListener)query.getQueryResultCollector()).getLeftTuple();
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(leftTuple, rightTuple, childSink);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
        }
    }

    public static void readBehaviors(BetaNode betaNode, BetaMemory betaMemory, MarshallerReaderContext inCtx) throws IOException {
        int token = -1;
        while (true) {
            short s = inCtx.readShort();
            token = s;
            if (s == 1) break;
            int i = inCtx.readInt();
            Object object = ((Object[])betaMemory.getBehaviorContext())[i];
            switch (token) {
                case 100: {
                    InputMarshaller.readSlidingTimeWindowBehaviour(betaNode, betaMemory, (SlidingTimeWindow)betaNode.getBehaviors()[i], (SlidingTimeWindow.SlidingTimeWindowContext)object, inCtx);
                    break;
                }
                case 101: {
                    InputMarshaller.readSlidingLengthWindowBehaviour(betaNode, betaMemory, (SlidingLengthWindow)betaNode.getBehaviors()[i], (SlidingLengthWindow.SlidingLengthWindowContext)object, inCtx);
                }
            }
        }
    }

    public static void readSlidingTimeWindowBehaviour(BetaNode betaNode, BetaMemory betaMemory, SlidingTimeWindow stw, SlidingTimeWindow.SlidingTimeWindowContext stwCtx, MarshallerReaderContext inCtx) throws IOException {
        if (inCtx.readBoolean()) {
            RightTuple rightTuple;
            int sinkId = inCtx.readInt();
            int factId = inCtx.readInt();
            RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
            RightTupleKey key = new RightTupleKey(factId, sink);
            stwCtx.expiringTuple = rightTuple = inCtx.rightTuples.get(key);
        }
        if (inCtx.readBoolean()) {
            int size = inCtx.readInt();
            for (int i = 0; i < size; ++i) {
                int sinkId = inCtx.readInt();
                int factId = inCtx.readInt();
                RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
                RightTupleKey key = new RightTupleKey(factId, sink);
                RightTuple rightTuple = inCtx.rightTuples.get(key);
                stwCtx.queue.add(rightTuple);
            }
        }
    }

    public static void readSlidingLengthWindowBehaviour(BetaNode betaNode, BetaMemory betaMemory, SlidingLengthWindow slw, SlidingLengthWindow.SlidingLengthWindowContext slwCtx, MarshallerReaderContext inCtx) throws IOException {
        int pos = inCtx.readInt();
        int length = inCtx.readInt();
        slwCtx.pos = pos;
        slwCtx.rightTuples = new RightTuple[length];
        for (int i = 0; i < length; ++i) {
            RightTuple rightTuple;
            int factId = inCtx.readInt();
            if (factId < 0) continue;
            int sinkId = inCtx.readInt();
            RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
            RightTupleKey key = new RightTupleKey(factId, sink);
            slwCtx.rightTuples[i] = rightTuple = inCtx.rightTuples.get(key);
        }
    }

    private static void addToLeftMemory(LeftTuple parentLeftTuple, BetaMemory memory) {
        memory.getLeftTupleMemory().add(parentLeftTuple);
        memory.linkRight();
    }

    public static void readActivations(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 8) {
            InputMarshaller.readActivation(context);
        }
    }

    public static Activation readActivation(MarshallerReaderContext context) throws IOException {
        AgendaItem activation;
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        long activationNumber = stream.readLong();
        int pos = stream.readInt();
        LeftTuple leftTuple = context.terminalTupleMap.get(pos);
        int salience = stream.readInt();
        String pkgName = stream.readUTF();
        String ruleName = stream.readUTF();
        Package pkg = ruleBase.getPackage(pkgName);
        Rule rule = pkg.getRule(ruleName);
        RuleTerminalNode ruleTerminalNode = (RuleTerminalNode)leftTuple.getLeftTupleSink();
        PropagationContext pc = context.propagationContexts.get(stream.readLong());
        boolean scheduled = false;
        if (rule.getTimer() != null) {
            activation = new ScheduledAgendaItem(activationNumber, leftTuple, (InternalAgenda)wm.getAgenda(), pc, ruleTerminalNode);
            scheduled = true;
        } else {
            activation = new AgendaItem(activationNumber, leftTuple, salience, pc, ruleTerminalNode);
        }
        leftTuple.setObject(activation);
        if (stream.readBoolean()) {
            String activationGroupName = stream.readUTF();
            ((DefaultAgenda)wm.getAgenda()).getActivationGroup(activationGroupName).addActivation(activation);
        }
        boolean activated = stream.readBoolean();
        activation.setActivated(activated);
        if (stream.readBoolean()) {
            InternalFactHandle handle = context.handles.get(stream.readInt());
            activation.setFactHandle(handle);
            handle.setObject(activation);
        }
        InternalAgendaGroup agendaGroup = rule.getAgendaGroup() == null || rule.getAgendaGroup().equals("") || rule.getAgendaGroup().equals("MAIN") ? (InternalAgendaGroup)((DefaultAgenda)wm.getAgenda()).getAgendaGroup("MAIN") : (InternalAgendaGroup)((DefaultAgenda)wm.getAgenda()).getAgendaGroup(rule.getAgendaGroup());
        activation.setAgendaGroup(agendaGroup);
        if (!scheduled && activated) {
            if (rule.getRuleFlowGroup() == null) {
                agendaGroup.add(activation);
            } else {
                InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)((DefaultAgenda)wm.getAgenda()).getRuleFlowGroup(rule.getRuleFlowGroup());
                rfg.addActivation(activation);
            }
        }
        TruthMaintenanceSystem tms = context.wm.getTruthMaintenanceSystem();
        while (stream.readShort() == 12) {
            int factHandleId = stream.readInt();
            InternalFactHandle handle = context.handles.get(factHandleId);
            tms.addLogicalDependency(handle, activation, pc, rule);
        }
        return activation;
    }

    public static void readPropagationContexts(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 9) {
            InputMarshaller.readPropagationContext(context);
        }
    }

    public static void readPropagationContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        int type = stream.readInt();
        Rule rule = null;
        if (stream.readBoolean()) {
            String pkgName = stream.readUTF();
            String ruleName = stream.readUTF();
            Package pkg = ruleBase.getPackage(pkgName);
            rule = pkg.getRule(ruleName);
        }
        LeftTuple leftTuple = null;
        if (stream.readBoolean()) {
            int tuplePos = stream.readInt();
            leftTuple = context.terminalTupleMap.get(tuplePos);
        }
        long propagationNumber = stream.readLong();
        int factHandleId = stream.readInt();
        InternalFactHandle factHandle = context.handles.get(factHandleId);
        int activeActivations = stream.readInt();
        int dormantActivations = stream.readInt();
        String entryPointId = stream.readUTF();
        EntryPoint entryPoint = context.entryPoints.get(entryPointId);
        if (entryPoint == null) {
            entryPoint = new EntryPoint(entryPointId);
            context.entryPoints.put(entryPointId, entryPoint);
        }
        PropagationContextImpl pc = new PropagationContextImpl(propagationNumber, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint);
        context.propagationContexts.put(propagationNumber, pc);
    }

    public static WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readLong());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    String strategyClassName;
                    int index = stream.readInt();
                    ObjectMarshallingStrategy strategy = null;
                    if (index >= 0) {
                        strategy = context.resolverStrategyFactory.getStrategy(index);
                        if (strategy == null) {
                            throw new IllegalStateException("No strategy of with index " + index + " available.");
                        }
                    } else if (index == -2 && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName = stream.readUTF())) == null) {
                        throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                    }
                    Object value = strategy.read((ObjectInputStream)stream);
                    workItem.setParameter(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        return workItem;
    }

    public static void readTimer(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        short timerType = inCtx.readShort();
        TimersInputMarshaller reader = inCtx.readersByInt.get(timerType);
        reader.read(inCtx);
    }

    public static Trigger readTrigger(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        short triggerInt = inCtx.readShort();
        switch (triggerInt) {
            case 70: {
                long startTime = inCtx.readLong();
                CronTrigger trigger = new CronTrigger();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                String expr = inCtx.readUTF();
                trigger.setCronExpression(expr);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 71: {
                IntervalTrigger trigger = new IntervalTrigger();
                long startTime = inCtx.readLong();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                long period = inCtx.readLong();
                trigger.setPeriod(period);
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 72: {
                long startTime = inCtx.readLong();
                PointInTimeTrigger trigger = new PointInTimeTrigger(startTime, null, null);
                return trigger;
            }
        }
        throw new RuntimeException("Unable to persist Trigger for type: " + triggerInt);
    }
}

