/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UpgradableReentrantReadWriteLock {
    private final boolean shouldTryAtomicUpgrade;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Long, Integer> readCounters = new ConcurrentHashMap<Long, Integer>();
    private final Map<Long, Integer> upgradedReadCounters = new ConcurrentHashMap<Long, Integer>();
    private AtomicBoolean tryingLockUpgrade = new AtomicBoolean(false);
    private final Integer lowPriotityMonitor = 42;
    private final Integer highPriorityMonitor = 43;

    public UpgradableReentrantReadWriteLock() {
        this(false);
    }

    public UpgradableReentrantReadWriteLock(boolean shouldTryAtomicUpgrade) {
        this.shouldTryAtomicUpgrade = shouldTryAtomicUpgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLock() {
        if (this.increaseUpgradedReadCounter()) {
            return;
        }
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get() && this.getReadCount() == 0) {
            try {
                Integer n = this.lowPriotityMonitor;
                synchronized (n) {
                    this.lowPriotityMonitor.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.lock.readLock().lock();
        this.increaseReadCounter();
    }

    public void readUnlock() {
        if (this.decreaseUpgradedReadCounter()) {
            return;
        }
        this.lock.readLock().unlock();
        this.decreaseReadCounters();
        this.notifyUpgradingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpgradingThread() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.highPriorityMonitor;
            synchronized (n) {
                if (this.lock.getReadLockCount() < 2 && !this.lock.isWriteLocked()) {
                    this.highPriorityMonitor.notifyAll();
                }
            }
        }
    }

    public void writeLock() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return;
        }
        int readHoldCount = this.getReadCount();
        if (readHoldCount > 0) {
            if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.compareAndSet(false, true)) {
                this.atomicLockUpgrade(readHoldCount);
            } else {
                this.upgradedReadCounters.put(Thread.currentThread().getId(), readHoldCount);
                for (int i = readHoldCount; i > 0; --i) {
                    this.lock.readLock().unlock();
                }
                this.notifyUpgradingThread();
                this.lowPriorityWriteLock();
            }
        } else {
            this.lowPriorityWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowPriorityWriteLock() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.lowPriotityMonitor;
            synchronized (n) {
                try {
                    this.lowPriotityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomicLockUpgrade(int readHoldCount) {
        this.upgradedReadCounters.put(Thread.currentThread().getId(), readHoldCount);
        for (int i = readHoldCount; i > 1; --i) {
            this.lock.readLock().unlock();
        }
        Integer n = this.highPriorityMonitor;
        synchronized (n) {
            if (this.lock.getReadLockCount() > readHoldCount || this.lock.isWriteLocked()) {
                try {
                    this.highPriorityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        this.tryingLockUpgrade.set(false);
        n = this.lowPriotityMonitor;
        synchronized (n) {
            this.lowPriotityMonitor.notifyAll();
        }
    }

    public void writeUnlock() {
        if (this.lock.getWriteHoldCount() == 1) {
            for (int i = this.getUpgradedReadCount(); i > 0; --i) {
                this.lock.readLock().lock();
            }
            this.upgradedReadCounters.remove(Thread.currentThread().getId());
        }
        this.lock.writeLock().unlock();
        this.notifyUpgradingThread();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.lock.getWriteHoldCount();
    }

    private void increaseReadCounter() {
        long threadId = Thread.currentThread().getId();
        Integer readCount = this.readCounters.get(threadId);
        if (readCount != null) {
            this.readCounters.put(threadId, readCount + 1);
        } else {
            this.readCounters.put(threadId, 1);
        }
    }

    private boolean increaseUpgradedReadCounter() {
        long threadId = Thread.currentThread().getId();
        Integer upgradedReadCount = this.upgradedReadCounters.get(threadId);
        if (upgradedReadCount == null) {
            return false;
        }
        this.upgradedReadCounters.put(threadId, upgradedReadCount + 1);
        return true;
    }

    private void decreaseReadCounters() {
        long threadId = Thread.currentThread().getId();
        Integer readCount = this.readCounters.get(threadId);
        if (readCount != null) {
            if (readCount < 2) {
                this.readCounters.remove(threadId);
            } else {
                this.readCounters.put(threadId, readCount - 1);
            }
        }
    }

    private boolean decreaseUpgradedReadCounter() {
        long threadId = Thread.currentThread().getId();
        Integer upgradedReadCount = this.upgradedReadCounters.get(threadId);
        if (upgradedReadCount == null) {
            return false;
        }
        if (upgradedReadCount < 2) {
            this.upgradedReadCounters.remove(threadId);
        } else {
            this.upgradedReadCounters.put(threadId, upgradedReadCount - 1);
        }
        return true;
    }

    private int getReadCount() {
        Integer readCount = this.readCounters.get(Thread.currentThread().getId());
        return readCount == null ? 0 : readCount;
    }

    private int getUpgradedReadCount() {
        Integer upgradedReadCount = this.upgradedReadCounters.get(Thread.currentThread().getId());
        return upgradedReadCount == null ? 0 : upgradedReadCount;
    }
}

