/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.Contains;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.RegExMatch;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.optimizers.dynamic.DynamicGetAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ConstructorAccessor;
import org.mvel2.optimizers.impl.refl.nodes.FieldAccessor;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MapAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticReferenceAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticVarAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ThisValueAccessor;
import org.mvel2.optimizers.impl.refl.nodes.VariableAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzedCondition {
    private boolean negated;
    private Expression left;
    private BooleanOperator operation;
    private Expression right;
    private ParserContext parserContext;

    public AnalyzedCondition(ExecutableStatement stmt) {
        ASTNode node;
        if (stmt instanceof CompiledExpression) {
            this.parserContext = ((CompiledExpression)stmt).getParserContext();
            node = ((CompiledExpression)stmt).getFirstNode();
        } else {
            node = ((ExecutableAccessor)stmt).getNode();
        }
        this.analyzeExpression(node);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public boolean isBinary() {
        return this.operation != null;
    }

    public BooleanOperator getOperation() {
        return this.operation;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void toggleNegation() {
        this.negated = !this.negated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append("not ");
        }
        sb.append(this.left);
        if (this.isBinary()) {
            sb.append(" ").append((Object)this.operation);
            sb.append(" ").append(this.right);
        }
        return sb.toString();
    }

    private void analyzeExpression(ASTNode node) {
        while (node.nextASTNode != null) {
            node = node.nextASTNode;
        }
        node = this.analyzeNegation(node);
        if ((node = this.analyzeSubstatement(node)) instanceof BinaryOperation) {
            BinaryOperation binaryOperation = (BinaryOperation)node;
            this.left = this.analyzeNode(binaryOperation.getLeft());
            this.operation = BooleanOperator.fromMvelOpCode(binaryOperation.getOperation());
            this.right = this.analyzeNode(binaryOperation.getRight());
        } else if (node instanceof RegExMatch) {
            this.left = this.analyzeNode(node);
            this.operation = BooleanOperator.MATCHES;
            Pattern pattern = (Pattern)this.getFieldValue(RegExMatch.class, "p", (RegExMatch)node);
            this.right = new FixedExpression(String.class, pattern.pattern());
        } else if (node instanceof Contains) {
            this.left = this.analyzeNode((ASTNode)this.getFieldValue(Contains.class, "stmt", (Contains)node));
            this.operation = BooleanOperator.CONTAINS;
            this.right = this.analyzeNode((ASTNode)this.getFieldValue(Contains.class, "stmt2", (Contains)node));
        } else {
            this.left = this.analyzeNode(node);
        }
    }

    private ASTNode analyzeNegation(ASTNode node) {
        if (node instanceof Negation) {
            this.negated = true;
            ExecutableAccessor executableAccessor = (ExecutableAccessor)this.getFieldValue(Negation.class, "stmt", (Negation)node);
            node = executableAccessor.getNode();
        }
        return node;
    }

    private ASTNode analyzeSubstatement(ASTNode node) {
        if (node instanceof Substatement) {
            ExecutableAccessor executableAccessor = (ExecutableAccessor)((Substatement)node).getStatement();
            node = executableAccessor.getNode();
        }
        return node;
    }

    private Expression analyzeNode(ASTNode node) {
        if (node instanceof RegExMatch) {
            ExecutableAccessor executableAccessor = (ExecutableAccessor)this.getFieldValue(RegExMatch.class, "stmt", (RegExMatch)node);
            node = executableAccessor.getNode();
        }
        if (node instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)node;
            return new FixedExpression(literalNode.getEgressType(), literalNode.getLiteralValue());
        }
        if (node instanceof BinaryOperation) {
            BinaryOperation binaryOperation = (BinaryOperation)node;
            Object value = binaryOperation.getReducedValue((Object)this.parserContext, null, (VariableResolverFactory)new ImmutableDefaultFactory());
            return new FixedExpression(binaryOperation.getEgressType(), value);
        }
        Accessor accessor = node.getAccessor();
        if (accessor == null && node instanceof NewObjectNode) {
            accessor = (Accessor)this.getFieldValue(NewObjectNode.class, "newObjectOptimizer", (NewObjectNode)node);
        }
        AccessorNode accessorNode = null;
        if (accessor instanceof DynamicGetAccessor) {
            accessorNode = (AccessorNode)this.getFieldValue(DynamicGetAccessor.class, "_accessor", (DynamicGetAccessor)accessor);
        } else if (accessor instanceof AccessorNode) {
            accessorNode = (AccessorNode)accessor;
        } else {
            if (accessor instanceof CompiledExpression) {
                return this.analyzeNode(((CompiledExpression)accessor).getFirstNode());
            }
            throw new RuntimeException("Unknown expression type: " + node);
        }
        while (accessorNode != null && accessorNode instanceof VariableAccessor) {
            accessorNode = accessorNode.getNextNode();
        }
        while (accessorNode instanceof StaticReferenceAccessor) {
            StaticReferenceAccessor staticReferenceAccessor = (StaticReferenceAccessor)accessorNode;
            Object literal = staticReferenceAccessor.getLiteral();
            if ((accessorNode = accessorNode.getNextNode()) != null) continue;
            return new FixedExpression(literal.getClass(), literal);
        }
        EvaluatedExpression expression = new EvaluatedExpression();
        Invocation invocation = null;
        while (accessorNode != null) {
            if ((invocation = this.analyzeAccessor(accessorNode, invocation)) != null) {
                expression.addInvocation(invocation);
            }
            accessorNode = accessorNode.getNextNode();
        }
        return expression;
    }

    private Invocation analyzeAccessor(AccessorNode accessorNode, Invocation formerInvocation) {
        if (accessorNode instanceof GetterAccessor) {
            return new MethodInvocation(((GetterAccessor)accessorNode).getMethod());
        }
        if (accessorNode instanceof MethodAccessor) {
            MethodAccessor methodAccessor = (MethodAccessor)accessorNode;
            MethodInvocation invocation = new MethodInvocation(methodAccessor.getMethod());
            ExecutableStatement[] params = methodAccessor.getParms();
            Class[] paramTypes = (Class[])this.getFieldValue(MethodAccessor.class, "parameterTypes", methodAccessor);
            this.readInvocationParams(invocation, params, paramTypes);
            return invocation;
        }
        if (accessorNode instanceof ConstructorAccessor) {
            ConstructorAccessor constructorAccessor = (ConstructorAccessor)accessorNode;
            Constructor constructor = (Constructor)this.getFieldValue(ConstructorAccessor.class, "constructor", constructorAccessor);
            ConstructorInvocation invocation = new ConstructorInvocation(constructor);
            ExecutableStatement[] params = (ExecutableStatement[])this.getFieldValue(ConstructorAccessor.class, "parms", constructorAccessor);
            Class[] paramTypes = (Class[])this.getFieldValue(ConstructorAccessor.class, "parmTypes", constructorAccessor);
            this.readInvocationParams(invocation, params, paramTypes);
            return invocation;
        }
        if (accessorNode instanceof ListAccessor) {
            Class<?> listType = this.getListType(formerInvocation);
            ListAccessor listAccessor = (ListAccessor)accessorNode;
            return new ListAccessInvocation(listType, new FixedExpression(Integer.TYPE, listAccessor.getIndex()));
        }
        if (accessorNode instanceof ListAccessorNest) {
            Class<?> listType = this.getListType(formerInvocation);
            ListAccessorNest listAccessorNest = (ListAccessorNest)accessorNode;
            ExecutableAccessor index = (ExecutableAccessor)listAccessorNest.getIndex();
            return new ListAccessInvocation(listType, this.analyzeNode(index.getNode()));
        }
        if (accessorNode instanceof MapAccessorNest) {
            MapAccessorNest mapAccessor;
            ExecutableStatement statement;
            Class keyType = Object.class;
            Class valueType = Object.class;
            Type[] generics = this.getGenerics(formerInvocation);
            if (generics != null && generics.length == 2 && generics[0] instanceof Class) {
                if (generics[0] instanceof Class) {
                    keyType = (Class)generics[0];
                }
                if (generics[1] instanceof Class) {
                    valueType = (Class)generics[1];
                }
            }
            if ((statement = (mapAccessor = (MapAccessorNest)accessorNode).getProperty()) instanceof ExecutableLiteral) {
                return new MapAccessInvocation(keyType, valueType, new FixedExpression(keyType, ((ExecutableLiteral)statement).getLiteral()));
            }
            return new MapAccessInvocation(keyType, valueType, this.analyzeNode(((ExecutableAccessor)statement).getNode()));
        }
        if (accessorNode instanceof FieldAccessor) {
            return new FieldAccessInvocation(((FieldAccessor)accessorNode).getField());
        }
        if (accessorNode instanceof StaticVarAccessor) {
            StaticVarAccessor staticVarAccessor = (StaticVarAccessor)accessorNode;
            Field field = (Field)this.getFieldValue(StaticVarAccessor.class, "field", staticVarAccessor);
            return new FieldAccessInvocation(field);
        }
        if (accessorNode instanceof ThisValueAccessor) {
            return new MethodInvocation(null);
        }
        throw new RuntimeException("Unknown AccessorNode type: " + accessorNode.getClass().getName());
    }

    private Class<?> getListType(Invocation formerInvocation) {
        Class listType = Object.class;
        Type[] generics = this.getGenerics(formerInvocation);
        if (generics != null && generics.length == 1 && generics[0] instanceof Class) {
            listType = (Class)generics[0];
        }
        return listType;
    }

    private Type[] getGenerics(Invocation invocation) {
        Type returnType;
        if (invocation != null && invocation instanceof MethodInvocation && (returnType = ((MethodInvocation)invocation).getMethod().getGenericReturnType()) instanceof ParameterizedType) {
            return ((ParameterizedType)returnType).getActualTypeArguments();
        }
        return null;
    }

    private void readInvocationParams(Invocation invocation, ExecutableStatement[] params, Class[] paramTypes) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ExecutableStatement param = params[i];
                if (param instanceof ExecutableLiteral) {
                    invocation.addArgument(new FixedExpression(paramTypes[i], ((ExecutableLiteral)param).getLiteral()));
                    continue;
                }
                if (!(param instanceof ExecutableAccessor)) continue;
                invocation.addArgument(this.analyzeNode(((ExecutableAccessor)param).getNode()));
            }
        }
    }

    private <T, V> V getFieldValue(Class<T> clazz, String fieldName, T object) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (V)f.get(object);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanOperator {
        EQ("=="),
        NE("!="),
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        MATCHES("~="),
        CONTAINS("in");

        private String symbol;

        private BooleanOperator(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public boolean isEquality() {
            return this == EQ || this == NE;
        }

        public boolean needsSameType() {
            return this != CONTAINS;
        }

        public static BooleanOperator fromMvelOpCode(int opCode) {
            switch (opCode) {
                case 18: {
                    return EQ;
                }
                case 19: {
                    return NE;
                }
                case 15: {
                    return GT;
                }
                case 17: {
                    return GE;
                }
                case 14: {
                    return LT;
                }
                case 16: {
                    return LE;
                }
            }
            throw new RuntimeException("Unknown opeation");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypedValue {
        Class<?> type;
        Object value;

        TypedValue(Class<?> type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.getSimpleName() + " " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldAccessInvocation
    extends Invocation {
        private final Field field;

        public FieldAccessInvocation(Field field) {
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        @Override
        public Class<?> getReturnType() {
            return this.field.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapAccessInvocation
    extends Invocation {
        private final Class<?> keyType;
        private final Class<?> valueType;
        private final Expression key;

        public MapAccessInvocation(Class<?> keyType, Class<?> valueType, Expression key) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.key = key;
        }

        public Expression getKey() {
            return this.key;
        }

        public String toString() {
            return "[\"" + this.key + "\"]";
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        @Override
        public Class<?> getReturnType() {
            return this.valueType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAccessInvocation
    extends Invocation {
        private final Class<?> listType;
        private final Expression index;

        public ListAccessInvocation(Class<?> listType, Expression index) {
            this.listType = listType;
            this.index = index;
        }

        public Expression getIndex() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }

        @Override
        public Class<?> getReturnType() {
            return this.listType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorInvocation
    extends Invocation {
        private final Constructor constructor;

        public ConstructorInvocation(Constructor constructor) {
            this.constructor = constructor;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public String toString() {
            return "new " + this.getReturnType() + (!this.getArguments().isEmpty() ? " with " + this.getArguments() : "");
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodInvocation
    extends Invocation {
        private final Method method;

        public MethodInvocation(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            if (this.method == null) {
                return "this";
            }
            return this.method + (!this.getArguments().isEmpty() ? " with " + this.getArguments() : "");
        }

        @Override
        public Class<?> getReturnType() {
            return this.method != null ? this.method.getReturnType() : Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Invocation {
        private final List<Expression> arguments = new ArrayList<Expression>();

        public List<Expression> getArguments() {
            return this.arguments;
        }

        public void addArgument(Expression argument) {
            this.arguments.add(argument);
        }

        public abstract Class<?> getReturnType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EvaluatedExpression
    implements Expression {
        List<Invocation> invocations = new ArrayList<Invocation>();

        void addInvocation(Invocation invocation) {
            this.invocations.add(invocation);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Invocation> i = this.invocations.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(" . ");
            }
            return sb.toString();
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public boolean canBeNull() {
            return true;
        }

        @Override
        public Class<?> getType() {
            return this.invocations.get(this.invocations.size() - 1).getReturnType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FixedExpression
    implements Expression {
        TypedValue typedValue;

        FixedExpression(TypedValue value) {
            this.typedValue = value;
        }

        FixedExpression(Class<?> type, Object value) {
            this(new TypedValue(type, value));
        }

        public String toString() {
            return this.typedValue.toString();
        }

        @Override
        public boolean isFixed() {
            return true;
        }

        @Override
        public boolean canBeNull() {
            return this.typedValue.value == null;
        }

        @Override
        public Class<?> getType() {
            return this.typedValue.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Expression {
        public boolean isFixed();

        public boolean canBeNull();

        public Class<?> getType();
    }
}

