/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.Cheese;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.field.LongFieldImpl;
import org.drools.base.field.ObjectFieldImpl;
import org.drools.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooFactHandleFactory;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.PredicateConstraint;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeObjectSinkAdapterTest {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    public int la;
    public int blah;
    public String wah;

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
    }

    @Test
    public void testBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), null, null);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getSinks()[0]);
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        Assert.assertNull((Object)ad.hashableSinks);
        Assert.assertNull((Object)ad.hashedFieldIndexes);
        Assert.assertNull((Object)ad.hashedSinkMap);
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
    }

    @Test
    public void testAlphaWithPredicate() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)new PredicateConstraint(null, null), null, this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
        Assert.assertNull((Object)ad.otherSinks);
    }

    @Test
    public void testSingleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNull((Object)ad.hashableSinks);
    }

    @Test
    public void testDoubleAlphaWithBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"cheddar"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        Assert.assertEquals((Object)al2, (Object)ad.getSinks()[1]);
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), null, null);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertNotNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
    }

    @Test
    public void testTripleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"cheddar"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stinky"));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charType", this.getClass().getClassLoader());
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(65L));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(66L));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(67L));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        Cheese cheese = new Cheese();
        cheese.setCharType('B');
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharType('X');
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charObjectType", this.getClass().getClassLoader());
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(65L));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(66L));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(67L));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf('B'));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharObjectType(Character.valueOf('X'));
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testPropagationWithNullValue() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        LiteralConstraint lit1 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al1 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit1, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"brie"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"muzzarela"));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al1);
        ad.addObjectSink((ObjectSink)al2);
        ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    static class MockBetaNode
    extends BetaNode {
        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, RuleBasePartitionId.MAIN_PARTITION, false, leftInput, rightInput, EmptyBetaConstraints.getInstance());
        }

        public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(factHandle, sink, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, sink, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
            return new LeftTupleImpl(leftTuple, rightTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        }
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int getIndex() {
            return 0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public boolean isNullValue(Object object, InternalWorkingMemory workingMemory) {
            return false;
        }

        public ValueType getValueType() {
            return ValueType.STRING_TYPE;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }
    }
}

