/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.drools.RuleBaseConfiguration;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.Sink;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.test.dsl.AccumulateNodeStep;
import org.drools.reteoo.test.dsl.BetaNodeStep;
import org.drools.reteoo.test.dsl.BindingStep;
import org.drools.reteoo.test.dsl.ConfigStep;
import org.drools.reteoo.test.dsl.DSLMock;
import org.drools.reteoo.test.dsl.DslStep;
import org.drools.reteoo.test.dsl.EvalNodeStep;
import org.drools.reteoo.test.dsl.ExistsNodeStep;
import org.drools.reteoo.test.dsl.FactsStep;
import org.drools.reteoo.test.dsl.JoinNodeStep;
import org.drools.reteoo.test.dsl.LeftInputAdapterNodeStep;
import org.drools.reteoo.test.dsl.LeftTupleSinkStep;
import org.drools.reteoo.test.dsl.MockitoHelper;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestCaseResult;
import org.drools.reteoo.test.dsl.NodeTestDef;
import org.drools.reteoo.test.dsl.NotNodeStep;
import org.drools.reteoo.test.dsl.ObjectTypeNodeStep;
import org.drools.reteoo.test.dsl.RIANodeStep;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.RuleTerminalNodeStep;
import org.drools.reteoo.test.dsl.Step;
import org.drools.reteoo.test.dsl.WithStep;
import org.drools.reteoo.test.parser.NodeTestDSLLexer;
import org.drools.reteoo.test.parser.NodeTestDSLParser;
import org.drools.reteoo.test.parser.NodeTestDSLTree;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteDslTestEngine {
    public static final String WORKING_MEMORY = "WorkingMemory";
    public static final String BUILD_CONTEXT = "BuildContext";
    private static final String CONFIG = "Config";
    private static final String OBJECT_TYPE_NODE = "ObjectTypeNode";
    private static final String LEFT_INPUT_ADAPTER_NODE = "LeftInputAdapterNode";
    private static final String BINDING = "Binding";
    private static final String JOIN_NODE = "JoinNode";
    private static final String NOT_NODE = "NotNode";
    private static final String EXISTS_NODE = "ExistsNode";
    private static final String ACCUMULATE_NODE = "AccumulateNode";
    private static final String RULE_TERMINAL_NODE = "RuleTerminalNode";
    private static final String EVAL_NODE = "EvalNode";
    private static final String WITH = "With";
    private static final String FACTS = "Facts";
    private static final String RIGHT_INPUT_ADAPTER_NODE = "RightInputAdapterNode";
    private static final String LEFT_TUPLE_SINK_STEP = "LeftTupleSink";
    private static final String BETA_NODE_STEP = "BetaNodeStep";
    private ReteTesterHelper reteTesterHelper = new ReteTesterHelper();
    private Map<String, Object> steps = new HashMap<String, Object>();

    public ReteDslTestEngine() {
        this.steps.put(CONFIG, new ConfigStep());
        this.steps.put(OBJECT_TYPE_NODE, new ObjectTypeNodeStep(this.reteTesterHelper));
        this.steps.put(LEFT_INPUT_ADAPTER_NODE, new LeftInputAdapterNodeStep(this.reteTesterHelper));
        this.steps.put(BINDING, new BindingStep(this.reteTesterHelper));
        this.steps.put(JOIN_NODE, new JoinNodeStep(this.reteTesterHelper));
        this.steps.put(NOT_NODE, new NotNodeStep(this.reteTesterHelper));
        this.steps.put(EXISTS_NODE, new ExistsNodeStep(this.reteTesterHelper));
        this.steps.put(ACCUMULATE_NODE, new AccumulateNodeStep(this.reteTesterHelper));
        this.steps.put(RULE_TERMINAL_NODE, new RuleTerminalNodeStep(this.reteTesterHelper));
        this.steps.put(EVAL_NODE, new EvalNodeStep(this.reteTesterHelper));
        this.steps.put(RIGHT_INPUT_ADAPTER_NODE, new RIANodeStep(this.reteTesterHelper));
        this.steps.put(FACTS, new FactsStep(this.reteTesterHelper));
        this.steps.put(WITH, new WithStep(this.reteTesterHelper));
        this.steps.put(LEFT_TUPLE_SINK_STEP, new LeftTupleSinkStep(this.reteTesterHelper));
        this.steps.put(BETA_NODE_STEP, new BetaNodeStep(this.reteTesterHelper));
    }

    public NodeTestCaseResult run(NodeTestCase testCase, RunNotifier notifier) {
        if (testCase == null || testCase.hasErrors()) {
            throw new IllegalArgumentException("Impossible to execute test case due to existing errors: " + testCase.getErrors());
        }
        if (notifier == null) {
            notifier = EmptyNotifier.INSTANCE;
        }
        this.reteTesterHelper.addImports(testCase.getImports());
        NodeTestCaseResult result = new NodeTestCaseResult(testCase);
        for (NodeTestDef test : testCase.getTests()) {
            notifier.fireTestStarted(test.getDescription());
            NodeTestCaseResult.NodeTestResult testResult = this.createTestResult(test, null);
            try {
                testResult = this.run(testCase, test);
                switch (testResult.result) {
                    case SUCCESS: {
                        notifier.fireTestFinished(test.getDescription());
                        break;
                    }
                    case ERROR: 
                    case FAILURE: {
                        notifier.fireTestFailure(new Failure(test.getDescription(), (Throwable)((Object)new AssertionError(testResult.errorMsgs))));
                    }
                }
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(test.getDescription(), e));
            }
            result.add(testResult);
        }
        return result;
    }

    private NodeTestCaseResult.NodeTestResult run(NodeTestCase testCase, NodeTestDef test) {
        Map<String, Object> context = this.createContext(testCase);
        NodeTestCaseResult.NodeTestResult result = this.createTestResult(test, context);
        try {
            this.run(context, testCase.getSetup(), result);
            this.run(context, test.getSteps(), result);
            this.run(context, testCase.getTearDown(), result);
            result.result = NodeTestCaseResult.Result.SUCCESS;
        }
        catch (Throwable e) {
            result.result = NodeTestCaseResult.Result.ERROR;
            result.errorMsgs.add(e.toString());
        }
        return result;
    }

    private NodeTestCaseResult.NodeTestResult createTestResult(NodeTestDef test, Map<String, Object> context) {
        NodeTestCaseResult.NodeTestResult result = new NodeTestCaseResult.NodeTestResult(test, NodeTestCaseResult.Result.NOT_EXECUTED, context, new LinkedList<String>());
        return result;
    }

    private Map<String, Object> createContext(NodeTestCase testCase) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("TestCase", testCase);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        ReteooRuleBase rbase = new ReteooRuleBase("ID", conf);
        BuildContext buildContext = new BuildContext((InternalRuleBase)rbase, rbase.getReteooBuilder().getIdGenerator());
        Rule rule = new Rule("rule1", "org.pkg1", null);
        Package pkg = new Package("org.pkg1");
        pkg.getDialectRuntimeRegistry().setDialectData("mvel", (DialectRuntimeData)new MVELDialectRuntimeData());
        pkg.addRule(rule);
        buildContext.setRule(rule);
        rbase.addPackage(pkg);
        context.put(BUILD_CONTEXT, buildContext);
        context.put("ClassFieldAccessorStore", this.reteTesterHelper.getStore());
        InternalWorkingMemory wm = (InternalWorkingMemory)rbase.newStatefulSession(true);
        context.put(WORKING_MEMORY, wm);
        return context;
    }

    public Map<String, Object> run(Map<String, Object> context, List<DslStep> steps, NodeTestCaseResult.NodeTestResult result) {
        InternalWorkingMemory wm = (InternalWorkingMemory)context.get(WORKING_MEMORY);
        for (DslStep step : steps) {
            String name = step.getName();
            Object object = this.steps.get(name);
            if (object != null && object instanceof Step) {
                Step stepImpl = (Step)object;
                try {
                    stepImpl.execute(context, step.getCommands());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
                }
            }
            if ("assert".equals(name.trim())) {
                this.assertObject(step, context, wm);
                continue;
            }
            if ("retract".equals(name.trim())) {
                this.retractObject(step, context, wm);
                continue;
            }
            if ("modify".equals(name.trim())) {
                this.modifyObject(step, context, wm);
                continue;
            }
            Object node = context.get(name.trim());
            if (node == null) {
                throw new IllegalArgumentException("line " + step.getLine() + ": step " + name + " does not exist");
            }
            if (node instanceof DSLMock) {
                MockitoHelper.process(step, (Sink)((LeftTupleSink)node), context, wm);
                continue;
            }
            if (node instanceof BetaNode) {
                this.betaNode(step, (BetaNode)node, context, wm);
                continue;
            }
            if (node instanceof RightInputAdapterNode) {
                this.riaNode(step, (RightInputAdapterNode)node, context, wm);
                continue;
            }
            if (node instanceof RuleTerminalNode) {
                this.ruleTerminalNode(step, (RuleTerminalNode)node, context, wm);
                continue;
            }
            throw new IllegalArgumentException("line " + step.getLine() + ": unknown node " + node);
        }
        return context;
    }

    private void betaNode(DslStep step, BetaNode node, Map<String, Object> context, InternalWorkingMemory wm) {
        boolean lrUnlinkingEnabled = ((BuildContext)context.get(BUILD_CONTEXT)).getRuleBase().getConfiguration().isLRUnlinkingEnabled();
        try {
            List<String[]> cmds = step.getCommands();
            List handles = (List)context.get("Handles");
            BetaMemory memory = null;
            if (node instanceof AccumulateNode) {
                AccumulateNode.AccumulateMemory accmem = (AccumulateNode.AccumulateMemory)wm.getNodeMemory((NodeMemory)node);
                memory = accmem.betaMemory;
            } else {
                memory = (BetaMemory)wm.getNodeMemory((NodeMemory)node);
            }
            for (Object[] objectArray : cmds) {
                List first;
                HashMap<String, List> vars;
                String listString;
                String args;
                if (objectArray[0].equals("leftMemory")) {
                    List<List<InternalFactHandle>> actualLeftTuples;
                    args = objectArray[1];
                    listString = args.replaceAll("h(\\d+)", "h[$1]");
                    vars = new HashMap<String, List>();
                    vars.put("h", handles);
                    List expectedLeftTuples = (List)MVEL.eval((String)listString, vars);
                    LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
                    if (expectedLeftTuples.isEmpty() && leftMemory.size() != 0) {
                        throw new AssertionFailedError("line " + step.getLine() + ": left Memory expected [] actually " + this.print(leftMemory, lrUnlinkingEnabled));
                    }
                    if (expectedLeftTuples.isEmpty() && leftMemory.size() == 0) continue;
                    first = (List)expectedLeftTuples.get(0);
                    LeftTupleImpl firstTuple = new LeftTupleImpl((InternalFactHandle)first.get(0), null, false);
                    for (int i = 1; i < first.size(); ++i) {
                        firstTuple = new LeftTupleImpl((LeftTuple)firstTuple, new RightTuple((InternalFactHandle)first.get(i)), null, false);
                    }
                    ArrayList<LeftTuple> leftTuples = new ArrayList<LeftTuple>();
                    for (LeftTuple leftTuple = this.getFirst(memory.getLeftTupleMemory(), (LeftTuple)firstTuple); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getNext()) {
                        leftTuples.add(leftTuple);
                    }
                    if (lrUnlinkingEnabled) {
                        Collections.sort(leftTuples, new LeftTupleComparator());
                    }
                    if (!((Object)expectedLeftTuples).equals(actualLeftTuples = this.getHandlesList(leftTuples))) {
                        throw new AssertionError((Object)("line " + step.getLine() + ": left Memory expected " + expectedLeftTuples + " actually " + actualLeftTuples));
                    }
                    continue;
                }
                if (objectArray[0].equals("rightMemory")) {
                    args = objectArray[1];
                    listString = args.replaceAll("h(\\d+)", "h[$1]");
                    vars = new HashMap();
                    vars.put("h", handles);
                    List expectedFactHandles = (List)MVEL.eval((String)listString, vars);
                    RightTupleMemory rightMemory = memory.getRightTupleMemory();
                    if (expectedFactHandles.isEmpty() && rightMemory.size() != 0) {
                        throw new AssertionError((Object)("line " + step.getLine() + ": right Memory expected [] actually " + this.print(rightMemory)));
                    }
                    if (expectedFactHandles.isEmpty() && rightMemory.size() == 0) continue;
                    first = new RightTuple((InternalFactHandle)expectedFactHandles.get(0));
                    ArrayList<RightTuple> actualRightTuples = new ArrayList<RightTuple>();
                    for (RightTuple rightTuple = this.getFirst(memory.getRightTupleMemory(), (RightTuple)first); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
                        actualRightTuples.add(rightTuple);
                    }
                    if (expectedFactHandles.size() != actualRightTuples.size()) {
                        throw new AssertionError((Object)("line " + step.getLine() + ": right Memory expected " + this.print(expectedFactHandles) + " actually " + this.print(actualRightTuples)));
                    }
                    int length = actualRightTuples.size();
                    for (int i = 0; i < length; ++i) {
                        if (expectedFactHandles.get(i) != ((RightTuple)actualRightTuples.get(i)).getFactHandle()) {
                            throw new AssertionError((Object)("line " + step.getLine() + ": right Memory expected " + this.print(expectedFactHandles) + " actually " + this.print(actualRightTuples)));
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(objectArray));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    private LeftTuple getFirst(LeftTupleMemory memory, LeftTuple leftTuple) {
        org.drools.core.util.Iterator it = memory.iterator();
        LeftTuple next = (LeftTuple)it.next();
        while (next != null) {
            if (next.equals(leftTuple)) {
                return next.getMemory().getFirst();
            }
            next = (LeftTuple)it.next();
        }
        return null;
    }

    private RightTuple getFirst(RightTupleMemory memory, RightTuple rightTuple) {
        org.drools.core.util.Iterator it = memory.iterator();
        RightTuple next = (RightTuple)it.next();
        while (next != null) {
            if (next.equals(rightTuple)) {
                return next.getMemory().getFirst();
            }
            next = (RightTuple)it.next();
        }
        return null;
    }

    private List<List<InternalFactHandle>> getHandlesList(List<LeftTuple> leftTuples) {
        ArrayList<List<InternalFactHandle>> actualLeftTuples = new ArrayList<List<InternalFactHandle>>(leftTuples.size());
        for (LeftTuple leftTuple : leftTuples) {
            List<InternalFactHandle> tupleHandles = Arrays.asList(leftTuple.toFactHandles());
            actualLeftTuples.add(tupleHandles);
        }
        return actualLeftTuples;
    }

    private String print(LeftTupleMemory leftMemory, boolean lrUnlinkingEnabled) {
        ArrayList<LeftTuple> tuples = new ArrayList<LeftTuple>();
        org.drools.core.util.Iterator it = leftMemory.iterator();
        LeftTuple tuple = (LeftTuple)it.next();
        while (tuple != null) {
            tuples.add(tuple);
            tuple = (LeftTuple)it.next();
        }
        if (lrUnlinkingEnabled) {
            Collections.sort(tuples, new LeftTupleComparator());
        }
        return this.print(this.getHandlesList(tuples));
    }

    private String print(RightTupleMemory memory) {
        ArrayList<RightTuple> tuples = new ArrayList<RightTuple>();
        org.drools.core.util.Iterator it = memory.iterator();
        RightTuple tuple = (RightTuple)it.next();
        while (tuple != null) {
            tuples.add(tuple);
            tuple = (RightTuple)it.next();
        }
        return "[" + this.print(tuples) + "]";
    }

    protected String print(List<?> tuples) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = tuples.iterator();
        while (iterator.hasNext()) {
            InternalFactHandle h;
            Object tuple = iterator.next();
            if (tuple instanceof List) {
                b.append("[");
                b.append(this.print((List)tuple));
                b.append("]");
            } else if (tuple instanceof InternalFactHandle) {
                h = (InternalFactHandle)tuple;
                b.append("h").append(h.getId() - 1);
            } else if (tuple instanceof RightTuple) {
                h = ((RightTuple)tuple).getFactHandle();
                b.append("h").append(h.getId() - 1);
            }
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        if (b.length() == 0) {
            return "[]";
        }
        return b.toString();
    }

    /*
     * Could not resolve type clashes
     */
    private void riaNode(DslStep step, RightInputAdapterNode node, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            List handles = (List)context.get("Handles");
            ObjectHashMap memory = (ObjectHashMap)wm.getNodeMemory((NodeMemory)node);
            for (Object[] cmd : cmds) {
                if (cmd[0].equals("leftMemory")) {
                    String args = cmd[1];
                    String listString = args.replaceAll("h(\\d+)", "h[$1]");
                    HashMap<String, List> vars = new HashMap<String, List>();
                    vars.put("h", handles);
                    List expectedLeftTuples = (List)MVEL.eval((String)listString, vars);
                    if (expectedLeftTuples.isEmpty() && memory.size() != 0) {
                        throw new AssertionError((Object)("line " + step.getLine() + ": left Memory expected [] actually " + memory));
                    }
                    if (expectedLeftTuples.isEmpty() && memory.size() == 0) {
                        return;
                    }
                    ArrayList<LeftTupleImpl> leftTuples = new ArrayList<LeftTupleImpl>();
                    for (List tlist : expectedLeftTuples) {
                        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)tlist.get(0), null, false);
                        for (int i = 1; i < tlist.size(); ++i) {
                            tuple = new LeftTupleImpl((LeftTuple)tuple, new RightTuple((InternalFactHandle)tlist.get(i)), null, false);
                        }
                        leftTuples.add(tuple);
                    }
                    ArrayList<LeftTuple> actualTuples = new ArrayList<LeftTuple>();
                    org.drools.core.util.Iterator it = memory.iterator();
                    ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                    while (entry != null) {
                        actualTuples.add((LeftTuple)entry.getKey());
                        entry = (ObjectHashMap.ObjectEntry)it.next();
                    }
                    for (LeftTuple tuple : leftTuples) {
                        if (!actualTuples.remove(tuple)) {
                            throw new AssertionError((Object)("line " + step.getLine() + ": left Memory expected " + tuple + " not found in memory."));
                        }
                    }
                    if (!actualTuples.isEmpty()) {
                        throw new AssertionError((Object)("line " + step.getLine() + ": left Memory unexpected tuples in the node memory " + actualTuples));
                    }
                    continue;
                }
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(cmd));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    private void ruleTerminalNode(DslStep step, RuleTerminalNode node, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            Iterator<String[]> i$ = cmds.iterator();
            if (i$.hasNext()) {
                Object[] cmd = i$.next();
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(cmd));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertObject(DslStep step, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            List handles = (List)context.get("Handles");
            for (String[] cmd : cmds) {
                try {
                    String nodeName = cmd[0];
                    Sink sink = (Sink)context.get(nodeName);
                    if (sink == null) {
                        throw new IllegalArgumentException("line " + step.getLine() + ": node " + nodeName + " does not exist");
                    }
                    HashMap<String, List> vars = new HashMap<String, List>();
                    vars.put("h", handles);
                    String args = cmd[1];
                    String listString = args.replaceAll("h(\\d+)", "h[$1]");
                    List list = (List)MVEL.eval((String)listString, vars);
                    if (list == null) {
                        throw new IllegalArgumentException(cmd + " does not specify an existing fact handle");
                    }
                    for (Object element : list) {
                        if (element == null) {
                            throw new IllegalArgumentException(cmd + " does not specify an existing fact handle");
                        }
                        if (element instanceof InternalFactHandle) {
                            InternalFactHandle handle = (InternalFactHandle)element;
                            PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 0, null, null, handle);
                            ((ObjectSink)sink).assertObject(handle, (PropagationContext)pContext, wm);
                            pContext.evaluateActionQueue(wm);
                            continue;
                        }
                        List tlist = (List)element;
                        LeftTuple tuple = this.createTuple(context, tlist);
                        PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 0, null, tuple, null);
                        ((LeftTupleSink)sink).assertLeftTuple(tuple, (PropagationContext)pContext, wm);
                        pContext.evaluateActionQueue(wm);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute command " + cmd, e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    private LeftTuple createTuple(Map<String, Object> context, List<InternalFactHandle> tlist) {
        LeftTupleImpl tuple = null;
        String id = this.getTupleId(tlist);
        for (InternalFactHandle handle : tlist) {
            if (tuple == null) {
                tuple = new LeftTupleImpl(handle, null, false);
                continue;
            }
            tuple = new LeftTupleImpl((LeftTuple)tuple, new RightTuple(handle), null, true);
        }
        context.put(id, tuple);
        return tuple;
    }

    private String getTupleId(List<InternalFactHandle> tlist) {
        StringBuilder id = new StringBuilder();
        id.append("T.");
        for (InternalFactHandle handle : tlist) {
            id.append(handle.getId());
            id.append(".");
        }
        return id.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retractObject(DslStep step, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            List handles = (List)context.get("Handles");
            for (Object[] objectArray : cmds) {
                try {
                    String nodeName = objectArray[0];
                    Sink sink = (Sink)context.get(nodeName);
                    if (sink == null) {
                        throw new IllegalArgumentException("line " + step.getLine() + ": node " + nodeName + " does not exist");
                    }
                    String args = objectArray[1];
                    String listString = args.replaceAll("h(\\d+)", "h[$1]");
                    HashMap<String, List> vars = new HashMap<String, List>();
                    vars.put("h", handles);
                    List list = (List)MVEL.eval((String)listString, vars);
                    if (list == null) {
                        throw new IllegalArgumentException(Arrays.toString(objectArray) + " does not specify an existing fact handle");
                    }
                    for (Object element : list) {
                        if (element == null) {
                            throw new IllegalArgumentException(Arrays.toString(objectArray) + " does not specify an existing fact handle");
                        }
                        if (element instanceof InternalFactHandle) {
                            InternalFactHandle handle = (InternalFactHandle)element;
                            PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 1, null, null, handle);
                            if (sink instanceof ObjectTypeNode) {
                                ((ObjectTypeNode)sink).retractObject(handle, (PropagationContext)pContext, wm);
                            } else {
                                for (RightTuple rightTuple = handle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
                                    rightTuple.getRightTupleSink().retractRightTuple(rightTuple, (PropagationContext)pContext, wm);
                                }
                                handle.clearRightTuples();
                                for (LeftTuple leftTuple = handle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                                    leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, (PropagationContext)pContext, wm);
                                }
                                handle.clearLeftTuples();
                            }
                            pContext.evaluateActionQueue(wm);
                            continue;
                        }
                        List tlist = (List)element;
                        String id = this.getTupleId(tlist);
                        LeftTuple tuple = (LeftTuple)context.remove(id);
                        if (tuple == null) {
                            throw new IllegalArgumentException("Tuple not found: " + id + " : " + tlist.toString());
                        }
                        PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 1, null, tuple, null);
                        ((LeftTupleSink)sink).retractLeftTuple(tuple, (PropagationContext)pContext, wm);
                        pContext.evaluateActionQueue(wm);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute command " + Arrays.toString(objectArray), e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyObject(DslStep step, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            List handles = (List)context.get("Handles");
            for (Object[] objectArray : cmds) {
                try {
                    String nodeName = objectArray[0];
                    Sink sink = (Sink)context.get(nodeName);
                    if (sink == null) {
                        throw new IllegalArgumentException("line " + step.getLine() + ": node " + nodeName + " does not exist");
                    }
                    String args = objectArray[1];
                    String listString = args.replaceAll("h(\\d+)", "h[$1]");
                    HashMap<String, List> vars = new HashMap<String, List>();
                    vars.put("h", handles);
                    List list = (List)MVEL.eval((String)listString, vars);
                    if (list == null) {
                        throw new IllegalArgumentException(Arrays.toString(objectArray) + " does not specify an existing fact handle");
                    }
                    for (Object element : list) {
                        if (element == null) {
                            throw new IllegalArgumentException(Arrays.toString(objectArray) + " does not specify an existing fact handle");
                        }
                        if (element instanceof InternalFactHandle) {
                            InternalFactHandle handle = (InternalFactHandle)element;
                            PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 2, null, null, handle);
                            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(handle.getFirstLeftTuple(), handle.getFirstRightTuple());
                            handle.clearRightTuples();
                            handle.clearLeftTuples();
                            ((ObjectSink)sink).modifyObject(handle, modifyPreviousTuples, (PropagationContext)pContext, wm);
                            modifyPreviousTuples.retractTuples((PropagationContext)pContext, wm);
                            pContext.evaluateActionQueue(wm);
                            continue;
                        }
                        List tlist = (List)element;
                        String id = this.getTupleId(tlist);
                        LeftTuple tuple = (LeftTuple)context.get(id);
                        if (tuple == null) {
                            throw new IllegalArgumentException("Tuple not found: " + id + " : " + tlist.toString());
                        }
                        PropagationContextImpl pContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 2, null, tuple, (InternalFactHandle)new DefaultFactHandle(1, (Object)""));
                        ((LeftTupleSink)sink).modifyLeftTuple(tuple, (PropagationContext)pContext, wm);
                        pContext.evaluateActionQueue(wm);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute command " + objectArray, e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    public static NodeTestCase compile(Reader reader) throws IOException {
        NodeTestDSLParser parser = ReteDslTestEngine.getParser(reader);
        return ReteDslTestEngine.compile(parser);
    }

    public static NodeTestCase compile(InputStream is) throws IOException {
        NodeTestDSLParser parser = ReteDslTestEngine.getParser(is);
        return ReteDslTestEngine.compile(parser);
    }

    public static NodeTestCase compile(String source) throws IOException {
        NodeTestDSLParser parser = ReteDslTestEngine.getParser(source);
        return ReteDslTestEngine.compile(parser);
    }

    private static NodeTestCase compile(NodeTestDSLParser parser) {
        try {
            NodeTestDSLParser.compilation_unit_return cur = parser.compilation_unit();
            if (parser.hasErrors()) {
                NodeTestCase result = new NodeTestCase();
                result.setErrors(parser.getErrorMessages());
                return result;
            }
            NodeTestCase testCase = ReteDslTestEngine.walk(parser.getTokenStream(), (Tree)((CommonTree)cur.getTree()));
            return testCase;
        }
        catch (RecognitionException e) {
            NodeTestCase result = new NodeTestCase();
            result.setErrors(Collections.singletonList(e.getMessage()));
            return result;
        }
    }

    private static NodeTestCase walk(TokenStream tokenStream, Tree resultTree) throws RecognitionException {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)resultTree);
        nodes.setTokenStream(tokenStream);
        NodeTestDSLTree walker = new NodeTestDSLTree((TreeNodeStream)nodes);
        walker.compilation_unit();
        return walker.getTestCase();
    }

    private static NodeTestDSLParser getParser(Reader reader) throws IOException {
        NodeTestDSLLexer lexer = new NodeTestDSLLexer((CharStream)new ANTLRReaderStream(reader));
        NodeTestDSLParser parser = new NodeTestDSLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return parser;
    }

    private static NodeTestDSLParser getParser(InputStream is) throws IOException {
        NodeTestDSLLexer lexer = new NodeTestDSLLexer((CharStream)new ANTLRInputStream(is));
        NodeTestDSLParser parser = new NodeTestDSLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return parser;
    }

    private static NodeTestDSLParser getParser(String source) throws IOException {
        NodeTestDSLLexer lexer = new NodeTestDSLLexer((CharStream)new ANTLRStringStream(source));
        NodeTestDSLParser parser = new NodeTestDSLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return parser;
    }

    public static class EmptyNotifier
    extends RunNotifier {
        public static final EmptyNotifier INSTANCE = new EmptyNotifier();

        public void fireTestAssumptionFailed(Failure failure) {
        }

        public void fireTestFailure(Failure failure) {
        }

        public void fireTestFinished(Description description) {
        }

        public void fireTestIgnored(Description description) {
        }

        public void fireTestRunFinished(Result result) {
        }

        public void fireTestRunStarted(Description description) {
        }

        public void fireTestStarted(Description description) throws StoppedByUserException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LeftTupleComparator
    implements Comparator<LeftTuple> {
        private LeftTupleComparator() {
        }

        @Override
        public int compare(LeftTuple o1, LeftTuple o2) {
            InternalFactHandle[] h1 = o1.getFactHandles();
            InternalFactHandle[] h2 = o2.getFactHandles();
            for (int i = h1.length - 1; i >= 0; --i) {
                int diff = h1[i].getId() - h2[i].getId();
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }
}

