/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.util.Date;
import org.drools.time.Trigger;
import org.drools.time.impl.CompositeMaxDurationTimer;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.IntervalTimer;
import org.drools.time.impl.Timer;
import org.junit.Assert;
import org.junit.Test;

public class CompositeMaxDurationTimerTest {
    @Test
    public void testJustMaxDuration() {
        CompositeMaxDurationTimer timer = new CompositeMaxDurationTimer();
        timer.addDurationTimer(new DurationTimer(25L));
        timer.addDurationTimer(new DurationTimer(50L));
        timer.addDurationTimer(new DurationTimer(70L));
        Date timestamp = new Date();
        Trigger trigger = timer.createTrigger(timestamp.getTime(), null, null);
        Assert.assertEquals((Object)new Date(timestamp.getTime() + 70L), (Object)trigger.hasNextFireTime());
        Assert.assertNull((Object)trigger.nextFireTime());
        Assert.assertNull((Object)trigger.hasNextFireTime());
    }

    @Test
    public void testMixedDurationAndTimer() {
        CompositeMaxDurationTimer timer = new CompositeMaxDurationTimer();
        timer.addDurationTimer(new DurationTimer(25L));
        timer.addDurationTimer(new DurationTimer(50L));
        timer.addDurationTimer(new DurationTimer(70L));
        timer.setTimer((Timer)new IntervalTimer(null, null, 6, 40L, 25L));
        Date timestamp = new Date();
        Trigger trigger = timer.createTrigger(timestamp.getTime(), null, null);
        Assert.assertEquals((Object)new Date(timestamp.getTime() + 70L), (Object)trigger.hasNextFireTime());
        Assert.assertEquals((Object)new Date(timestamp.getTime() + 90L), (Object)trigger.nextFireTime());
        Assert.assertEquals((Object)new Date(timestamp.getTime() + 115L), (Object)trigger.nextFireTime());
        Assert.assertEquals((Object)new Date(timestamp.getTime() + 140L), (Object)trigger.nextFireTime());
        Assert.assertNull((Object)trigger.nextFireTime());
        Assert.assertNull((Object)trigger.hasNextFireTime());
    }
}

