/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.ArrayList;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.evaluators.ComparableEvaluatorsDefinition;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.base.evaluators.SoundslikeEvaluatorsDefinition;
import org.drools.common.InternalFactHandle;
import org.drools.common.SingleBetaConstraints;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LeftTupleIndexHashTableIteratorTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    @Test
    public void test1() {
        VariableConstraint constraint0 = (VariableConstraint)this.getConstraint("d", Operator.EQUAL, "this", Foo.class);
        VariableConstraint[] constraints = new VariableConstraint[]{constraint0};
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        SingleBetaConstraints betaConstraints = null;
        betaConstraints = new SingleBetaConstraints((BetaNodeFieldConstraint[])constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        StatefulSession ss = rb.newStatefulSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh1, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh2, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh3, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh4, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh5, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh6, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh7, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh8, null, true));
        betaMemory.getLeftTupleMemory().add((LeftTuple)new LeftTupleImpl(fh9, null, true));
        LeftTupleIndexHashTable hashTable = (LeftTupleIndexHashTable)betaMemory.getLeftTupleMemory();
        LeftTupleList leftTupleList = new LeftTupleList();
        leftTupleList.add((LeftTuple)new LeftTupleImpl(fh10, null, true));
        hashTable.getTable()[0] = leftTupleList;
        leftTupleList = new LeftTupleList();
        leftTupleList.add((LeftTuple)new LeftTupleImpl(fh11, null, true));
        leftTupleList.add((LeftTuple)new LeftTupleImpl(fh12, null, true));
        leftTupleList.add((LeftTuple)new LeftTupleImpl(fh13, null, true));
        ((LeftTupleList)hashTable.getTable()[0]).setNext((Entry)leftTupleList);
        Entry[] table = hashTable.getTable();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            ArrayList<Integer> entries = new ArrayList<Integer>();
            entries.add(i);
            for (Entry entry = table[i]; entry != null; entry = entry.getNext()) {
                entries.add((Integer)entry);
            }
            list.add(entries.toArray());
        }
        Assert.assertEquals((long)5L, (long)list.size());
        Object[] entries = (Object[])list.get(0);
        Assert.assertEquals((Object)0, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        entries = (Object[])list.get(1);
        Assert.assertEquals((Object)102, (Object)entries[0]);
        Assert.assertEquals((long)2L, (long)entries.length);
        entries = (Object[])list.get(2);
        Assert.assertEquals((Object)103, (Object)entries[0]);
        Assert.assertEquals((long)2L, (long)entries.length);
        entries = (Object[])list.get(3);
        Assert.assertEquals((Object)115, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        entries = (Object[])list.get(4);
        Assert.assertEquals((Object)117, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        list = new ArrayList();
        Iterator it = betaMemory.getLeftTupleMemory().iterator();
        LeftTupleImpl leftTuple = (LeftTupleImpl)it.next();
        while (leftTuple != null) {
            list.add(leftTuple);
            leftTuple = (LeftTupleImpl)it.next();
        }
        Assert.assertEquals((long)13L, (long)list.size());
    }

    @Test
    public void testLastBucketInTheTable() {
        Entry[] entries = new Entry[10];
        entries[0] = (Entry)Mockito.mock(LeftTupleList.class);
        entries[5] = (Entry)Mockito.mock(LeftTupleList.class);
        entries[9] = (Entry)Mockito.mock(LeftTupleList.class);
        LeftTupleImpl[] tuples = new LeftTupleImpl[]{(LeftTupleImpl)Mockito.mock(LeftTupleImpl.class), (LeftTupleImpl)Mockito.mock(LeftTupleImpl.class), (LeftTupleImpl)Mockito.mock(LeftTupleImpl.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)((LeftTupleList)entries[0]).getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)((LeftTupleList)entries[5]).getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)((LeftTupleList)entries[9]).getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        LeftTupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new LeftTupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[0]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[1]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[2]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.is((Object)null));
    }

    protected BetaNodeFieldConstraint getConstraint(String identifier, Operator operator, String fieldName, Class clazz) {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(clazz, fieldName, this.getClass().getClassLoader());
        Declaration declaration = new Declaration(identifier, (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(clazz)));
        Evaluator evaluator = registry.getEvaluatorDefinition(operator.getOperatorString()).getEvaluator(extractor.getValueType(), operator.getOperatorString(), operator.isNegated(), null);
        return new VariableConstraint((InternalReadAccessor)extractor, declaration, evaluator);
    }

    static {
        registry.addEvaluatorDefinition((EvaluatorDefinition)new EqualityEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new ComparableEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SetEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new MatchesEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SoundslikeEvaluatorsDefinition());
    }

    public static class Foo {
        private String val;
        private int hashCode;

        public Foo(String val, int hashCode) {
            this.val = val;
            this.hashCode = hashCode;
        }

        public String getVal() {
            return this.val;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Foo other = (Foo)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return !(this.val == null ? other.val != null : !this.val.equals(other.val));
        }
    }
}

