/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.constraint.ConditionAnalyzer;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.EvaluatorHelper;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

public class ASMConditionEvaluatorJitter {
    public static ConditionEvaluator jit(ConditionAnalyzer.Condition condition, ClassLoader classLoader) {
        ClassGenerator generator = new ClassGenerator(ASMConditionEvaluatorJitter.getUniqueClassName(), classLoader).setInterfaces(ConditionEvaluator.class).addDefaultConstructor();
        generator.addMethod(1, "evaluate", generator.methodDescr(Boolean.TYPE, Object.class, Map.class), new EvaluateMethodGenerator(condition));
        return (ConditionEvaluator)generator.newInstance();
    }

    private static String getUniqueClassName() {
        return "ConditionEvaluator" + StringUtils.generateUUID();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvaluateMethodGenerator
    extends ClassGenerator.MethodBody {
        private static final int LEFT_OPERAND = 3;
        private static final int RIGHT_OPERAND = 5;
        private final ConditionAnalyzer.Condition condition;

        public EvaluateMethodGenerator(ConditionAnalyzer.Condition condition) {
            this.condition = condition;
        }

        @Override
        public void body(MethodVisitor mv) {
            this.jitCondition(this.condition);
            mv.visitInsn(172);
        }

        private void jitCondition(ConditionAnalyzer.Condition condition) {
            if (condition instanceof ConditionAnalyzer.SingleCondition) {
                this.jitSingleCondition((ConditionAnalyzer.SingleCondition)condition);
            } else {
                this.jitCombinedCondition((ConditionAnalyzer.CombinedCondition)condition);
            }
            if (condition.isNegated()) {
                this.jitNegation();
            }
        }

        private void jitSingleCondition(ConditionAnalyzer.SingleCondition singleCondition) {
            if (singleCondition.isBinary()) {
                this.jitBinary(singleCondition);
            } else {
                this.jitUnary(singleCondition);
            }
        }

        private void jitCombinedCondition(ConditionAnalyzer.CombinedCondition combinedCondition) {
            boolean isAnd = combinedCondition.isAnd();
            Label shortcut = new Label();
            Label noShortcut = new Label();
            for (ConditionAnalyzer.Condition condition : combinedCondition.getConditions()) {
                this.jitCondition(condition);
                this.mv.visitJumpInsn(isAnd ? 153 : 154, shortcut);
            }
            this.mv.visitInsn(isAnd ? 4 : 3);
            this.mv.visitJumpInsn(167, noShortcut);
            this.mv.visitLabel(shortcut);
            this.mv.visitInsn(isAnd ? 3 : 4);
            this.mv.visitLabel(noShortcut);
        }

        private void jitUnary(ConditionAnalyzer.SingleCondition singleCondition) {
            this.jitExpression(singleCondition.getLeft());
        }

        private void jitBinary(ConditionAnalyzer.SingleCondition singleCondition) {
            Class<Comparable> commonType;
            ConditionAnalyzer.Expression left = singleCondition.getLeft();
            ConditionAnalyzer.Expression right = singleCondition.getRight();
            Class clazz = singleCondition.getOperation().needsSameType() ? this.findCommonClass(left.getType(), !left.canBeNull(), right.getType(), !right.canBeNull()) : (commonType = null);
            if (commonType == Object.class && singleCondition.getOperation().isComparison()) {
                commonType = Comparable.class;
            }
            if (commonType != null && commonType.isPrimitive()) {
                this.jitPrimitiveBinary(singleCondition, left, right, commonType);
            } else {
                this.jitObjectBinary(singleCondition, left, right, commonType);
            }
        }

        private void jitPrimitiveBinary(ConditionAnalyzer.SingleCondition singleCondition, ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right, Class<?> type) {
            if (right.isFixed() && right.canBeNull()) {
                this.mv.visitInsn(singleCondition.getOperation() == ConditionAnalyzer.BooleanOperator.NE ? 4 : 3);
                return;
            }
            this.jitExpression(left, type);
            this.castPrimitiveToPrimitive(left.getType(), type);
            this.jitExpression(right, type);
            this.castPrimitiveToPrimitive(right.getType(), type);
            this.jitPrimitiveOperation(singleCondition.getOperation(), type);
        }

        private void jitObjectBinary(ConditionAnalyzer.SingleCondition singleCondition, ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right, Class<?> type) {
            if (left.isFixed()) {
                throw new RuntimeException("Unmanaged fixed left");
            }
            Class<?> leftType = left.getType();
            Class<?> rightType = right.getType();
            this.jitExpression(left, type != null ? type : leftType);
            this.store(3, leftType);
            this.jitExpression(right, type != null ? type : rightType);
            this.store(5, rightType);
            ConditionAnalyzer.BooleanOperator operation = singleCondition.getOperation();
            this.prepareLeftOperand(operation, type, leftType, rightType);
            this.prepareRightOperand(operation, right, type, rightType);
            this.load(3);
            this.load(5);
            if (operation == ConditionAnalyzer.BooleanOperator.CONTAINS) {
                this.invokeStatic(EvaluatorHelper.class, "contains", Boolean.TYPE, Object.class, rightType.isPrimitive() ? rightType : Object.class);
            } else if (operation == ConditionAnalyzer.BooleanOperator.MATCHES) {
                this.invokeVirtual(type, "matches", Boolean.TYPE, String.class);
            } else if (operation.isEquality()) {
                if (type.isInterface()) {
                    this.invokeInterface(type, "equals", Boolean.TYPE, Object.class);
                } else {
                    this.invokeVirtual(type, "equals", Boolean.TYPE, Object.class);
                }
                if (operation == ConditionAnalyzer.BooleanOperator.NE) {
                    singleCondition.toggleNegation();
                }
            } else {
                if (type.isInterface()) {
                    this.invokeInterface(type, "compareTo", Integer.TYPE, type == Comparable.class ? Object.class : type);
                } else {
                    this.invokeVirtual(type, "compareTo", Integer.TYPE, type);
                }
                this.mv.visitInsn(3);
                this.jitPrimitiveOperation(operation, Integer.TYPE);
            }
        }

        private void prepareLeftOperand(ConditionAnalyzer.BooleanOperator operation, Class<?> type, Class<?> leftType, Class<?> rightType) {
            if (leftType.isPrimitive()) {
                if (type != null) {
                    this.castOrCoercePrimitive(3, leftType, type);
                }
                return;
            }
            Label notNullLabel = this.jitLeftIsNull(type == null || leftType == type ? this.jitNullSafeOperationStart() : this.jitNullSafeCoercion(leftType, type));
            if (operation.isEquality() && !rightType.isPrimitive()) {
                this.checkNullEquality(operation);
            } else {
                this.mv.visitInsn(3);
            }
            this.mv.visitInsn(172);
            this.mv.visitLabel(notNullLabel);
        }

        private void prepareRightOperand(ConditionAnalyzer.BooleanOperator operation, ConditionAnalyzer.Expression right, Class<?> type, Class<?> rightType) {
            if (rightType.isPrimitive()) {
                if (type != null) {
                    this.castOrCoercePrimitive(5, rightType, type);
                }
                return;
            }
            Label nullLabel = new Label();
            Label notNullLabel = new Label();
            this.load(5);
            this.mv.visitJumpInsn(198, nullLabel);
            if (type != null && !right.isFixed() && rightType != type) {
                this.castOrCoerceTo(5, rightType, type, nullLabel);
            }
            this.mv.visitJumpInsn(167, notNullLabel);
            this.mv.visitLabel(nullLabel);
            this.mv.visitInsn(operation == ConditionAnalyzer.BooleanOperator.NE ? 4 : 3);
            this.mv.visitInsn(172);
            this.mv.visitLabel(notNullLabel);
        }

        private void checkNullEquality(ConditionAnalyzer.BooleanOperator operation) {
            Label rightNullLabel = new Label();
            Label rightNotNullLabel = new Label();
            this.load(5);
            this.mv.visitJumpInsn(198, rightNullLabel);
            this.mv.visitInsn(operation == ConditionAnalyzer.BooleanOperator.EQ ? 3 : 4);
            this.mv.visitJumpInsn(167, rightNotNullLabel);
            this.mv.visitLabel(rightNullLabel);
            this.mv.visitInsn(operation == ConditionAnalyzer.BooleanOperator.EQ ? 4 : 3);
            this.mv.visitLabel(rightNotNullLabel);
        }

        private Label jitNullSafeOperationStart() {
            Label nullLabel = new Label();
            this.load(3);
            this.mv.visitJumpInsn(198, nullLabel);
            return nullLabel;
        }

        private Label jitNullSafeCoercion(Class<?> fromType, Class<?> toType) {
            Label nullLabel = new Label();
            this.load(3);
            this.mv.visitJumpInsn(198, nullLabel);
            this.castOrCoerceTo(3, fromType, toType, nullLabel);
            return nullLabel;
        }

        private Label jitLeftIsNull(Label nullLabel) {
            Label notNullLabel = new Label();
            this.mv.visitJumpInsn(167, notNullLabel);
            this.mv.visitLabel(nullLabel);
            return notNullLabel;
        }

        private void castOrCoerceTo(int regNr, Class<?> fromType, Class<?> toType, Label nullLabel) {
            Label nonInstanceOfLabel = new Label();
            Label endOfCoercionLabel = new Label();
            this.load(regNr);
            this.instanceOf(toType);
            this.mv.visitJumpInsn(153, nonInstanceOfLabel);
            this.load(regNr);
            this.cast(toType);
            this.store(regNr, toType);
            this.mv.visitJumpInsn(167, endOfCoercionLabel);
            this.mv.visitLabel(nonInstanceOfLabel);
            boolean isNumber = Number.class.isAssignableFrom(toType);
            Label tryOk = null;
            Label inCatch = null;
            if (isNumber) {
                Label beforeTry = new Label();
                tryOk = new Label();
                inCatch = new Label();
                this.mv.visitTryCatchBlock(beforeTry, tryOk, inCatch, "java/lang/NumberFormatException");
                this.mv.visitLabel(beforeTry);
            }
            this.mv.visitTypeInsn(187, this.internalName(toType));
            this.mv.visitInsn(89);
            this.load(regNr);
            this.coerceByConstructor(fromType, toType);
            this.store(regNr, toType);
            if (isNumber) {
                Label afterCatch = new Label();
                this.mv.visitLabel(tryOk);
                this.mv.visitJumpInsn(167, afterCatch);
                this.mv.visitLabel(inCatch);
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                this.mv.visitVarInsn(58, regNr);
                this.mv.visitJumpInsn(167, nullLabel);
                this.mv.visitLabel(afterCatch);
            }
            this.mv.visitLabel(endOfCoercionLabel);
        }

        private void coerceByConstructor(Class<?> fromType, Class<?> toType) {
            this.invokeVirtual(fromType, "toString", String.class, new Class[0]);
            if (toType == Character.class) {
                this.mv.visitInsn(3);
                this.invokeVirtual(String.class, "charAt", Character.TYPE, Integer.TYPE);
                this.invokeSpecial(Character.class, "<init>", null, Character.TYPE);
            } else {
                this.invokeSpecial(toType, "<init>", null, String.class);
            }
        }

        private void castOrCoercePrimitive(int regNr, Class<?> fromType, Class<?> toType) {
            if (fromType == toType) {
                return;
            }
            this.load(regNr);
            if (toType.isPrimitive()) {
                this.castPrimitiveToPrimitive(fromType, toType);
            } else {
                Class<?> toTypeAsPrimitive = this.convertToPrimitiveType(toType);
                this.castPrimitiveToPrimitive(fromType, toTypeAsPrimitive);
                this.invokeStatic(toType, "valueOf", toType, toTypeAsPrimitive);
            }
            this.store(regNr, toType);
        }

        private void jitExpression(ConditionAnalyzer.Expression exp) {
            this.jitExpression(exp, exp.getType());
        }

        private void jitExpression(ConditionAnalyzer.Expression exp, Class<?> requiredClass) {
            if (exp.isFixed()) {
                this.push(((ConditionAnalyzer.FixedExpression)exp).typedValue.value, requiredClass);
            } else if (exp instanceof ConditionAnalyzer.EvaluatedExpression) {
                this.jitEvaluatedExpression((ConditionAnalyzer.EvaluatedExpression)exp, true);
            } else if (exp instanceof ConditionAnalyzer.VariableExpression) {
                this.jitVariableExpression((ConditionAnalyzer.VariableExpression)exp, requiredClass);
            } else {
                this.jitAritmeticExpression((ConditionAnalyzer.AritmeticExpression)exp);
            }
        }

        private void jitEvaluatedExpression(ConditionAnalyzer.EvaluatedExpression exp, boolean firstInvocation) {
            Iterator<ConditionAnalyzer.Invocation> invocations = exp.invocations.iterator();
            Class<?> currentClass = this.jitInvocation(invocations.next(), Object.class, firstInvocation);
            while (invocations.hasNext()) {
                currentClass = this.jitInvocation(invocations.next(), currentClass, false);
            }
        }

        private void jitVariableExpression(ConditionAnalyzer.VariableExpression exp, Class<?> requiredClass) {
            this.mv.visitVarInsn(25, 2);
            this.push(exp.variableName, String.class);
            this.invokeInterface(Map.class, "get", Object.class, Object.class);
            if (exp.subsequentInvocations != null) {
                this.jitEvaluatedExpression(exp.subsequentInvocations, false);
            } else if (requiredClass.isPrimitive()) {
                this.castToPrimitive(requiredClass);
            }
        }

        private void jitAritmeticExpression(ConditionAnalyzer.AritmeticExpression aritmeticExpression) {
            if (aritmeticExpression.isStringConcat()) {
                this.jitStringConcat(aritmeticExpression.left, aritmeticExpression.right);
            } else {
                Class<Number> operationType = Double.TYPE;
                if (aritmeticExpression.type == Integer.class) {
                    operationType = Integer.TYPE;
                } else if (aritmeticExpression.type == Long.class) {
                    operationType = Long.TYPE;
                }
                this.jitExpressionToPrimitiveType(aritmeticExpression.left, operationType);
                this.jitExpressionToPrimitiveType(aritmeticExpression.right, aritmeticExpression.operator.isBitwiseOperation() ? Integer.TYPE : operationType);
                this.jitAritmeticOperation(operationType, aritmeticExpression.operator);
            }
        }

        private void jitStringConcat(ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right) {
            this.invokeConstructor(StringBuilder.class);
            this.jitExpression(left, String.class);
            this.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, left.getType());
            this.jitExpression(right, String.class);
            this.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, right.getType());
            this.invokeVirtual(StringBuilder.class, "toString", String.class, new Class[0]);
        }

        private void jitExpressionToPrimitiveType(ConditionAnalyzer.Expression expression, Class<?> primitiveType) {
            this.jitExpression(expression, Object.class);
            if (expression.isFixed() || expression.getType().isPrimitive()) {
                this.castPrimitiveToPrimitive(this.convertToPrimitiveType(expression.getType()), primitiveType);
            } else {
                this.castToPrimitive(primitiveType);
            }
        }

        private void jitAritmeticOperation(Class<?> operationType, ConditionAnalyzer.AritmeticOperator operator) {
            if (operationType == Integer.TYPE) {
                switch (operator) {
                    case ADD: {
                        this.mv.visitInsn(96);
                        break;
                    }
                    case SUB: {
                        this.mv.visitInsn(100);
                        break;
                    }
                    case MUL: {
                        this.mv.visitInsn(104);
                        break;
                    }
                    case DIV: {
                        this.mv.visitInsn(108);
                        break;
                    }
                    case BW_SHIFT_LEFT: {
                        this.mv.visitInsn(120);
                        break;
                    }
                    case BW_SHIFT_RIGHT: {
                        this.mv.visitInsn(122);
                    }
                }
            } else if (operationType == Long.TYPE) {
                switch (operator) {
                    case ADD: {
                        this.mv.visitInsn(97);
                        break;
                    }
                    case SUB: {
                        this.mv.visitInsn(101);
                        break;
                    }
                    case MUL: {
                        this.mv.visitInsn(105);
                        break;
                    }
                    case DIV: {
                        this.mv.visitInsn(109);
                        break;
                    }
                    case BW_SHIFT_LEFT: {
                        this.mv.visitInsn(121);
                        break;
                    }
                    case BW_SHIFT_RIGHT: {
                        this.mv.visitInsn(123);
                    }
                }
            } else {
                switch (operator) {
                    case ADD: {
                        this.mv.visitInsn(99);
                        break;
                    }
                    case SUB: {
                        this.mv.visitInsn(103);
                        break;
                    }
                    case MUL: {
                        this.mv.visitInsn(107);
                        break;
                    }
                    case DIV: {
                        this.mv.visitInsn(111);
                    }
                }
            }
        }

        private Class<?> jitInvocation(ConditionAnalyzer.Invocation invocation, Class<?> currentClass, boolean firstInvocation) {
            if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                this.jitMethodInvocation((ConditionAnalyzer.MethodInvocation)invocation, currentClass, firstInvocation);
            } else if (invocation instanceof ConditionAnalyzer.ConstructorInvocation) {
                this.jitConstructorInvocation((ConditionAnalyzer.ConstructorInvocation)invocation);
            } else if (invocation instanceof ConditionAnalyzer.ListAccessInvocation) {
                this.jitListAccessInvocation((ConditionAnalyzer.ListAccessInvocation)invocation);
            } else if (invocation instanceof ConditionAnalyzer.MapAccessInvocation) {
                this.jitMapAccessInvocation((ConditionAnalyzer.MapAccessInvocation)invocation);
            } else {
                this.jitFieldAccessInvocation((ConditionAnalyzer.FieldAccessInvocation)invocation, currentClass, firstInvocation);
            }
            return invocation.getReturnType();
        }

        private void jitMethodInvocation(ConditionAnalyzer.MethodInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            Method method = invocation.getMethod();
            if (firstInvocation && (method == null || (method.getModifiers() & 8) == 0)) {
                this.mv.visitVarInsn(25, 1);
            }
            if (method == null) {
                if (firstInvocation) {
                    return;
                }
                throw new RuntimeException("access to this not in first position");
            }
            if (!method.getDeclaringClass().isAssignableFrom(currentClass) && (method.getModifiers() & 8) == 0) {
                this.cast(method.getDeclaringClass());
            }
            for (ConditionAnalyzer.Expression argument : invocation.getArguments()) {
                this.jitExpression(argument);
            }
            this.invoke(method);
        }

        private void jitConstructorInvocation(ConditionAnalyzer.ConstructorInvocation invocation) {
            Constructor constructor = invocation.getConstructor();
            Class<?> clazz = invocation.getReturnType();
            this.mv.visitTypeInsn(187, this.internalName(clazz));
            this.mv.visitInsn(89);
            for (ConditionAnalyzer.Expression argument : invocation.getArguments()) {
                this.jitExpression(argument);
            }
            this.invokeSpecial(clazz, "<init>", null, constructor.getParameterTypes());
        }

        private void jitListAccessInvocation(ConditionAnalyzer.ListAccessInvocation invocation) {
            this.jitExpression(invocation.getIndex(), Integer.TYPE);
            this.invokeInterface(List.class, "get", Object.class, Integer.TYPE);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitMapAccessInvocation(ConditionAnalyzer.MapAccessInvocation invocation) {
            this.jitExpression(invocation.getKey(), invocation.getKeyType());
            this.invokeInterface(Map.class, "get", Object.class, Object.class);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitFieldAccessInvocation(ConditionAnalyzer.FieldAccessInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            boolean isStatic;
            Field field = invocation.getField();
            boolean bl = isStatic = (field.getModifiers() & 8) != 0;
            if (firstInvocation && !isStatic) {
                this.mv.visitVarInsn(25, 1);
            }
            if (!isStatic && !field.getDeclaringClass().isAssignableFrom(currentClass)) {
                this.cast(field.getDeclaringClass());
            }
            this.readField(field);
        }

        private void jitPrimitiveOperation(ConditionAnalyzer.BooleanOperator op, Class<?> type) {
            int opCode = this.toOpCode(op, type);
            Label trueBranchLabel = new Label();
            Label returnLabel = new Label();
            if (type == Double.TYPE) {
                this.mv.visitInsn(151);
            } else if (type == Long.TYPE) {
                this.mv.visitInsn(148);
            } else if (type == Float.TYPE) {
                this.mv.visitInsn(149);
            }
            this.mv.visitJumpInsn(opCode, trueBranchLabel);
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, returnLabel);
            this.mv.visitLabel(trueBranchLabel);
            this.mv.visitInsn(4);
            this.mv.visitLabel(returnLabel);
        }

        private void jitNegation() {
            Label trueBranch = new Label();
            Label falseBranch = new Label();
            this.mv.visitJumpInsn(154, trueBranch);
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, falseBranch);
            this.mv.visitLabel(trueBranch);
            this.mv.visitInsn(3);
            this.mv.visitLabel(falseBranch);
        }

        private int toOpCode(ConditionAnalyzer.BooleanOperator op, Class<?> type) {
            if (type == Double.TYPE || type == Long.TYPE || type == Float.TYPE) {
                switch (op) {
                    case EQ: {
                        return 153;
                    }
                    case NE: {
                        return 154;
                    }
                    case GT: {
                        return 157;
                    }
                    case GE: {
                        return 156;
                    }
                    case LT: {
                        return 155;
                    }
                    case LE: {
                        return 158;
                    }
                }
            } else {
                switch (op) {
                    case EQ: {
                        return 159;
                    }
                    case NE: {
                        return 160;
                    }
                    case GT: {
                        return 163;
                    }
                    case GE: {
                        return 162;
                    }
                    case LT: {
                        return 161;
                    }
                    case LE: {
                        return 164;
                    }
                }
            }
            throw new RuntimeException("Unknown operator: " + (Object)((Object)op));
        }

        private Class<?> findCommonClass(Class<?> class1, boolean primitive1, Class<?> class2, boolean primitive2) {
            Class<?> result = null;
            if (class1 == class2) {
                result = class1;
            } else if (class1 == Object.class) {
                result = this.convertFromPrimitiveType(class2);
            } else if (class2 == Object.class) {
                result = this.convertFromPrimitiveType(class1);
            } else if (class1 == String.class) {
                result = this.convertFromPrimitiveType(class2);
            } else if (class2 == String.class) {
                result = this.convertFromPrimitiveType(class1);
            }
            if (result == null) {
                result = this.findCommonClass(class1, class2, primitive2);
            }
            if (result == null) {
                result = this.findCommonClass(class2, class1, primitive1);
            }
            if (result == null) {
                throw new RuntimeException("Cannot find a common class between " + class1.getName() + " and " + class2.getName());
            }
            return result == Number.class ? Double.class : result;
        }

        private Class<?> findCommonClass(Class<?> class1, Class<?> class2, boolean canBePrimitive) {
            if (class1.isAssignableFrom(class2)) {
                return class1;
            }
            if (class1 == Boolean.TYPE && class2 == Boolean.class) {
                return canBePrimitive ? Boolean.TYPE : Boolean.class;
            }
            if (class1 == Character.TYPE && class2 == Character.class) {
                return canBePrimitive ? Character.TYPE : Character.class;
            }
            if (class1 == Byte.TYPE && class2 == Byte.class) {
                return canBePrimitive ? Byte.TYPE : Byte.class;
            }
            if (class1 == Short.TYPE && class2 == Short.class) {
                return canBePrimitive ? Short.TYPE : Short.class;
            }
            if (class1 == Number.class && class2.isPrimitive()) {
                return Double.class;
            }
            if (class1 == Integer.TYPE || class1 == Short.TYPE || class1 == Byte.TYPE) {
                if (class2 == Integer.class) {
                    return canBePrimitive ? Integer.TYPE : Integer.class;
                }
                if (class2 == Long.TYPE) {
                    return Long.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Float.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Long.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Long.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Float.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Float.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Long.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Double.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Long.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Float.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Integer.class) {
                if (class2 == Long.class) {
                    return Long.class;
                }
                if (class2 == Float.class) {
                    return Float.class;
                }
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Long.class) {
                if (class2 == Float.class) {
                    return Double.class;
                }
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Float.class) {
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Double.class) {
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == BigInteger.class && class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
            return null;
        }
    }
}

