/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Properties;
import org.drools.RuleBaseConfiguration;
import org.drools.common.ArrayAgendaGroupFactory;
import org.drools.common.PriorityQueueAgendaGroupFactory;
import org.junit.Assert;
import org.junit.Test;

public class RuleBaseConfigurationTest {
    @Test
    public void testSystemProperties() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        System.setProperty("drools.assertBehaviour", "EQUALITY");
        cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
        System.getProperties().remove("drools.assertBehaviour");
    }

    @Test
    public void testProgrammaticPropertiesFile() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)true, (Object)cfg.isIndexLeftBetaMemory());
        Properties properties = new Properties();
        properties.setProperty("drools.indexLeftBetaMemory", "false");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)false, (Object)cfg.isIndexLeftBetaMemory());
        System.getProperties().remove("drools.indexLeftBetaMemory");
    }

    @Test
    public void testAssertBehaviour() {
        Properties properties = new Properties();
        properties.setProperty("drools.assertBehaviour", "identity");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        properties = new Properties();
        properties.setProperty("drools.assertBehaviour", "equality");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
    }

    @Test
    public void testLogicalOverride() {
        Properties properties = new Properties();
        properties.setProperty("drools.logicalOverride", "preserve");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.LogicalOverride.PRESERVE, (Object)cfg.getLogicalOverride());
        properties = new Properties();
        properties.setProperty("drools.logicalOverride", "discard");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.LogicalOverride.DISCARD, (Object)cfg.getLogicalOverride());
    }

    @Test
    public void testSequential() {
        Properties properties = new Properties();
        properties.setProperty("drools.sequential", "false");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assert.assertFalse((boolean)cfg.isSequential());
        Assert.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "sequential");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertTrue((boolean)cfg.isSequential());
        Assert.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL, (Object)cfg.getSequentialAgenda());
        Assert.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof ArrayAgendaGroupFactory));
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "dynamic");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertTrue((boolean)cfg.isSequential());
        Assert.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.DYNAMIC, (Object)cfg.getSequentialAgenda());
        Assert.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
    }

    @Test
    public void testLRUnlinking() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)false, (Object)cfg.isLRUnlinkingEnabled());
        Properties properties = new Properties();
        properties.setProperty("drools.lrUnlinkingEnabled", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)true, (Object)cfg.isLRUnlinkingEnabled());
    }
}

