/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.List;
import java.util.Map;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassObjectType;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.MockObjectSink;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EntryPoint;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObjectTypeNodeTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach();
    }

    @Test
    public void testAttach() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete source = this.ruleBase.getRete();
        ClassObjectType objectType = new ClassObjectType(String.class);
        int id = idGenerator.getNextId();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(id, this.entryPoint, (ObjectType)objectType, this.buildContext);
        Assert.assertEquals((long)id, (long)objectTypeNode.getId());
        Map map = source.getObjectTypeNodes(EntryPoint.DEFAULT);
        Assert.assertEquals((long)0L, (long)map.size());
        objectTypeNode.attach();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertSame((Object)objectTypeNode, map.get(objectType));
    }

    @Test
    public void testAssertObject() throws Exception {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)string1);
        objectTypeNode.assertObject(handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectSequentialMode() {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        this.buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.buildContext.setObjectTypeNodeMemoryEnabled(false);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)string1);
        objectTypeNode.assertObject(handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
    }

    @Test
    public void testMemory() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testIsAssignableFrom() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
        objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(Object.class), this.buildContext);
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
    }

    @Test
    public void testRetractObject() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        objectTypeNode.assertObject((InternalFactHandle)handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        objectTypeNode.retractObject((InternalFactHandle)handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
        List retracted = sink.getRetracted();
        this.assertLength(1, retracted);
        Assert.assertSame((Object)handle1, (Object)((Object[])retracted.get(0))[0]);
    }

    @Test
    public void testUpdateSink() throws FactException {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)ruleBase));
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string1 = "cheese";
        String string2 = "bread";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)string2);
        objectTypeNode.assertObject((InternalFactHandle)handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        objectTypeNode.assertObject((InternalFactHandle)handle2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink1.getAsserted().size());
        MockObjectSink sink2 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink2);
        Assert.assertEquals((long)0L, (long)sink2.getAsserted().size());
        objectTypeNode.updateSink((ObjectSink)sink2, (PropagationContext)new PropagationContextImpl(), (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink2.getAsserted().size());
        String string3 = "water";
        DefaultFactHandle handle3 = new DefaultFactHandle(3, (Object)string3);
        objectTypeNode.assertObject((InternalFactHandle)handle3, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)sink1.getAsserted().size());
        Assert.assertEquals((long)3L, (long)sink2.getAsserted().size());
    }

    @Test
    public void testAssertObjectWithShadowEnabled() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        entryPoint.addObjectSink((ObjectSink)objectTypeNode);
        Cheese cheese = new Cheese("muzzarela", 5);
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)cheese);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)cheese, (Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject());
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectWithShadowEnabledNoDefaultConstr() throws Exception {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(Person.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        Person person = new Person("bob", 25);
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)person);
        objectTypeNode.assertObject(handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject(), (Object)person);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((NodeMemory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }
}

