/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleImpl;
import org.drools.core.util.TripleStore;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.runtime.rule.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TripleBasedStruct
implements Map<String, Object> {
    protected TripleStore store;

    protected TripleImpl propertyKey(Object property) {
        return new TripleImpl(this.getObject(), property.toString(), (Object)Variable.v);
    }

    protected TripleImpl propertyKey(String property) {
        return new TripleImpl(this.getObject(), property, (Object)Variable.v);
    }

    protected TripleImpl property(String property, Object value) {
        return new TripleImpl(this.getObject(), property, value);
    }

    @Override
    public int size() {
        return this.getTriplesForSubject(this.getObject()).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.get(this.propertyKey(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            if (!(t.getValue() == null ? value == null : t.getValue().equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Triple t = this.store.get(this.propertyKey(key));
        return t == null ? null : t.getValue();
    }

    @Override
    public Object put(String key, Object value) {
        return this.store.put(this.property(key, value));
    }

    @Override
    public Object remove(Object key) {
        return this.store.remove(this.store.get(this.propertyKey(key)));
    }

    @Override
    public void clear() {
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            this.store.remove(t);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            set.add((String)t.getProperty());
        }
        return set;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            values.add(t.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            set.add(TraitProxy.buildEntry((String)t.getProperty(), t.getValue()));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        Object other;
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Object obj = this.getObject();
        if (obj == (other = ((TripleBasedStruct)o).getObject())) {
            return true;
        }
        Collection<Triple> l1 = this.getTriplesForSubject(obj);
        Collection<Triple> l2 = this.getTriplesForSubject(other);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (Triple t : l1) {
            if (l2.contains(t)) continue;
            return false;
        }
        return true;
    }

    protected Collection<Triple> getTriplesForSubject(Object subj) {
        Collection<Triple> coll = this.store.getAll(new TripleImpl(subj, Variable.v, (Object)Variable.v));
        Iterator<Triple> iter = coll.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getProperty().equals("rdfs:type")) continue;
            iter.remove();
        }
        return coll;
    }

    protected abstract Object getObject();
}

