/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.BitMaskUtil;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.AsyncCompositeLeftTupleSinkAdapter;
import org.drools.reteoo.AsyncSingleLeftTupleSinkAdapter;
import org.drools.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropertySpecificUtil;
import org.drools.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Pattern;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

public abstract class LeftTupleSource
extends BaseNode
implements Externalizable {
    private long leftDeclaredMask;
    private long leftInferredMask;
    private long leftNegativeMask;
    protected LeftTupleSinkPropagator sink;
    private transient int leftInputOtnId;

    public LeftTupleSource() {
    }

    LeftTupleSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        super(id, partitionId, partitionsEnabled);
        this.sink = EmptyLeftTupleSinkAdapter.getInstance();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSinkPropagator)in.readObject();
        this.leftDeclaredMask = in.readLong();
        this.leftInferredMask = in.readLong();
        this.leftNegativeMask = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeLong(this.leftDeclaredMask);
        out.writeLong(this.leftInferredMask);
        out.writeLong(this.leftNegativeMask);
    }

    public void addTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            this.sink = this.partitionsEnabled && !this.partitionId.equals(tupleSink.getPartitionId()) ? new AsyncSingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink) : new SingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink);
        } else if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter sinkAdapter = this.partitionsEnabled ? new AsyncCompositeLeftTupleSinkAdapter(this.getPartitionId()) : new CompositeLeftTupleSinkAdapter(this.getPartitionId());
            sinkAdapter.addTupleSink(this.sink.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeLeftTupleSinkAdapter)this.sink).addTupleSink(tupleSink);
        }
    }

    protected void removeTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        } else {
            CompositeLeftTupleSinkAdapter sinkAdapter = (CompositeLeftTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = this.partitionsEnabled && !this.partitionId.equals(tupleSink.getPartitionId()) ? new AsyncSingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]) : new SingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public LeftTupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public abstract void updateSink(LeftTupleSink var1, PropagationContext var2, InternalWorkingMemory var3);

    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    protected final void initMasks(BuildContext context, LeftTupleSource leftInput) {
        this.initDeclaredMask(context, leftInput);
        this.initInferredMask(leftInput);
    }

    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        ObjectType objectType;
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.leftDeclaredMask = Long.MAX_VALUE;
            return;
        }
        if (!(leftInput instanceof LeftInputAdapterNode)) {
            this.leftDeclaredMask = Long.MAX_VALUE;
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[1];
        if (pattern == null || this instanceof AccumulateNode) {
            ObjectSource objectSource = ((LeftInputAdapterNode)leftInput).getParentObjectSource();
            if (!(objectSource instanceof ObjectTypeNode)) {
                this.leftDeclaredMask = Long.MAX_VALUE;
                return;
            }
            objectType = ((ObjectTypeNode)objectSource).getObjectType();
        } else {
            objectType = pattern.getObjectType();
        }
        if (!(objectType instanceof ClassObjectType)) {
            this.leftDeclaredMask = Long.MAX_VALUE;
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertySpecific()) {
            this.leftDeclaredMask = Long.MAX_VALUE;
        } else if (pattern != null) {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
            this.leftDeclaredMask = PropertySpecificUtil.calculatePositiveMask(pattern.getListenedProperties(), settableProperties);
            this.leftNegativeMask = PropertySpecificUtil.calculateNegativeMask(pattern.getListenedProperties(), settableProperties);
        }
    }

    protected void initInferredMask(LeftTupleSource leftInput) {
        LeftTupleSource unwrappedLeft = this.unwrapLeftInput(leftInput);
        if (unwrappedLeft instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource();
            this.leftInferredMask = alphaNode.updateMask(this.leftDeclaredMask);
        } else {
            this.leftInferredMask = this.leftDeclaredMask;
        }
        this.leftInferredMask &= Long.MAX_VALUE - this.leftNegativeMask;
    }

    private LeftTupleSource unwrapLeftInput(LeftTupleSource leftInput) {
        if (leftInput instanceof FromNode) {
            return ((FromNode)leftInput).getLeftTupleSource();
        }
        return leftInput;
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSource.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, (LeftTupleSink)((Object)this), this.getLeftInputOtnId(), this.getLeftInferredMask());
    }

    public static void doModifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSink sink, int leftInputOtnId, long leftInferredMask) {
        LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple();
        while (leftTuple != null && leftTuple.getLeftTupleSink().getLeftInputOtnId() < leftInputOtnId) {
            modifyPreviousTuples.removeLeftTuple();
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, context, workingMemory);
            leftTuple = modifyPreviousTuples.peekLeftTuple();
        }
        if (leftTuple != null && leftTuple.getLeftTupleSink().getLeftInputOtnId() == leftInputOtnId) {
            modifyPreviousTuples.removeLeftTuple();
            leftTuple.reAdd();
            if (BitMaskUtil.intersect(context.getModificationMask(), leftInferredMask)) {
                sink.modifyLeftTuple(leftTuple, context, workingMemory);
            }
        } else if (BitMaskUtil.intersect(context.getModificationMask(), leftInferredMask)) {
            sink.assertLeftTuple(sink.createLeftTuple(factHandle, sink, true), context, workingMemory);
        }
    }

    public long getLeftDeclaredMask() {
        return this.leftDeclaredMask;
    }

    public long getLeftInferredMask() {
        return this.leftInferredMask;
    }

    public long getLeftNegativeMask() {
        return this.leftNegativeMask;
    }

    public int getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(int leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    protected abstract ObjectTypeNode getObjectTypeNode();
}

