/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.UpdateContext;
import org.drools.reteoo.AsyncCompositeObjectSinkAdapter;
import org.drools.reteoo.AsyncSingleObjectSinkAdapter;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.EmptyObjectSinkAdapter;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropertySpecificUtil;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.SingleObjectSinkAdapter;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Pattern;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectSource
extends BaseNode
implements Externalizable {
    protected ObjectSinkPropagator sink;
    protected ObjectSource source;
    private int alphaNodeHashingThreshold;
    protected long declaredMask;
    protected long inferredMask;

    public ObjectSource() {
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this(id, partitionId, partitionsEnabled, null, 3);
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, int alphaNodeHashingThreshold) {
        super(id, partitionId, partitionsEnabled);
        this.source = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (ObjectSinkPropagator)in.readObject();
        this.source = (ObjectSource)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeObject(this.source);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSource getParentObjectSource() {
        return this.source;
    }

    public void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = Long.MAX_VALUE;
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.declaredMask = Long.MAX_VALUE;
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertySpecific()) {
            this.declaredMask = Long.MAX_VALUE;
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
            this.declaredMask = this.calculateDeclaredMask(settableProperties);
        }
    }

    public abstract long calculateDeclaredMask(List<String> var1);

    public void resetInferredMask() {
        this.inferredMask = 0L;
    }

    public long updateMask(long mask) {
        long returnMask = !(this.source instanceof ObjectTypeNode) ? this.source.updateMask(this.declaredMask | mask) : this.declaredMask | mask;
        this.inferredMask |= returnMask;
        return returnMask;
    }

    public void addObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            this.sink = this.partitionsEnabled && !this.getPartitionId().equals(objectSink.getPartitionId()) ? new AsyncSingleObjectSinkAdapter(this.getPartitionId(), objectSink) : new SingleObjectSinkAdapter(this.getPartitionId(), objectSink);
        } else if (this.sink instanceof SingleObjectSinkAdapter) {
            CompositeObjectSinkAdapter sinkAdapter = this.partitionsEnabled ? new AsyncCompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold) : new CompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold);
            sinkAdapter.addObjectSink(this.sink.getSinks()[0]);
            sinkAdapter.addObjectSink(objectSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeObjectSinkAdapter)this.sink).addObjectSink(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleObjectSinkAdapter) {
            this.sink = EmptyObjectSinkAdapter.getInstance();
        } else {
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)this.sink;
            sinkAdapter.removeObjectSink(objectSink);
            if (sinkAdapter.size() == 1) {
                this.sink = this.partitionsEnabled && !this.getPartitionId().equals(sinkAdapter.getSinks()[0].getPartitionId()) ? new AsyncSingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]) : new SingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.source.networkUpdated(updateContext);
    }

    public ObjectSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse() && this instanceof NodeMemory) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((NodeMemory)((Object)this));
            }
        }
        this.source.remove(context, builder, this, workingMemories);
    }

    protected ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    public long getDeclaredMask() {
        return 0L;
    }
}

