/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.event.AfterFunctionRemovedEvent;
import org.drools.event.AfterPackageAddedEvent;
import org.drools.event.AfterPackageRemovedEvent;
import org.drools.event.AfterProcessAddedEvent;
import org.drools.event.AfterProcessRemovedEvent;
import org.drools.event.AfterRuleAddedEvent;
import org.drools.event.AfterRuleBaseLockedEvent;
import org.drools.event.AfterRuleBaseUnlockedEvent;
import org.drools.event.AfterRuleRemovedEvent;
import org.drools.event.BeforeFunctionRemovedEvent;
import org.drools.event.BeforePackageAddedEvent;
import org.drools.event.BeforePackageRemovedEvent;
import org.drools.event.BeforeProcessAddedEvent;
import org.drools.event.BeforeProcessRemovedEvent;
import org.drools.event.BeforeRuleAddedEvent;
import org.drools.event.BeforeRuleBaseLockedEvent;
import org.drools.event.BeforeRuleBaseUnlockedEvent;
import org.drools.event.BeforeRuleRemovedEvent;
import org.drools.event.RuleBaseEventListener;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Consequence;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleBaseEventSupportTest {
    private RuleBase ruleBase;
    private TestRuleBaseListener listener1;
    private TestRuleBaseListener listener2;
    private Package pkg;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = RuleBaseFactory.newRuleBase();
        this.listener1 = new TestRuleBaseListener("(listener-1) ");
        this.listener2 = new TestRuleBaseListener("(listener-2) ");
        this.ruleBase.addEventListener((RuleBaseEventListener)this.listener1);
        this.ruleBase.addEventListener((RuleBaseEventListener)this.listener2);
        Rule rule1 = new Rule("test1");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = new EqualityEvaluatorsDefinition().getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL, null);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        pattern.addConstraint((Constraint)constraint);
        rule1.addPattern((RuleConditionElement)pattern);
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        Rule rule2 = new Rule("test2");
        ClassObjectType cheeseObjectType2 = new ClassObjectType(Cheese.class);
        Pattern pattern2 = new Pattern(0, (ObjectType)cheeseObjectType2);
        FieldValue field2 = FieldFactory.getFieldValue((Object)"stilton");
        LiteralConstraint constraint2 = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field2);
        pattern2.addConstraint((Constraint)constraint2);
        rule2.addPattern((RuleConditionElement)pattern2);
        rule2.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        this.pkg = new Package("org.drools.test1");
        this.pkg.addRule(rule1);
        this.pkg.addRule(rule2);
    }

    @Test
    public void testAddPackageEvents() throws Exception {
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforePackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterPackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforePackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterPackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforeRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforeRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterRuleAdded());
        this.ruleBase.addPackage(this.pkg);
        Assert.assertEquals((long)1L, (long)this.listener1.getBeforePackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener1.getAfterPackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener2.getBeforePackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener2.getAfterPackageAdded());
        Assert.assertEquals((long)2L, (long)this.listener1.getBeforeRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener1.getAfterRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener2.getBeforeRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener2.getAfterRuleAdded());
    }

    @Test
    public void testRemovePackageEvents() throws Exception {
        this.ruleBase.addPackage(this.pkg);
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterPackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterPackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforeRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforeRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterRuleRemoved());
        this.ruleBase.removePackage("org.drools.test1");
        Assert.assertEquals((long)1L, (long)this.listener1.getBeforePackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener1.getAfterPackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener2.getBeforePackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener2.getAfterPackageRemoved());
        Assert.assertEquals((long)2L, (long)this.listener1.getBeforeRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener1.getAfterRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener2.getBeforeRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener2.getAfterRuleRemoved());
    }

    public static class TestRuleBaseListener
    implements RuleBaseEventListener {
        private String id;
        private int beforePackageAdded = 0;
        private int afterPackageAdded = 0;
        private int beforePackageRemoved = 0;
        private int afterPackageRemoved = 0;
        private int beforeRuleAdded = 0;
        private int afterRuleAdded = 0;
        private int beforeRuleRemoved = 0;
        private int afterRuleRemoved = 0;

        public TestRuleBaseListener() {
        }

        public TestRuleBaseListener(String id) {
            this.id = id;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = (String)in.readObject();
            this.beforePackageAdded = in.readInt();
            this.afterPackageAdded = in.readInt();
            this.beforePackageRemoved = in.readInt();
            this.afterPackageRemoved = in.readInt();
            this.beforeRuleAdded = in.readInt();
            this.afterRuleAdded = in.readInt();
            this.beforeRuleRemoved = in.readInt();
            this.afterRuleRemoved = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.id);
            out.writeInt(this.beforePackageAdded);
            out.writeInt(this.afterPackageAdded);
            out.writeInt(this.beforePackageRemoved);
            out.writeInt(this.afterPackageRemoved);
            out.writeInt(this.beforeRuleAdded);
            out.writeInt(this.afterRuleAdded);
            out.writeInt(this.beforeRuleRemoved);
            out.writeInt(this.afterRuleRemoved);
        }

        public void afterPackageAdded(AfterPackageAddedEvent event) {
            ++this.afterPackageAdded;
        }

        public void beforePackageAdded(BeforePackageAddedEvent event) {
            ++this.beforePackageAdded;
        }

        protected int getAfterPackageAdded() {
            return this.afterPackageAdded;
        }

        protected int getBeforePackageAdded() {
            return this.beforePackageAdded;
        }

        protected String getId() {
            return this.id;
        }

        public void afterPackageRemoved(AfterPackageRemovedEvent event) {
            ++this.afterPackageRemoved;
        }

        public void beforePackageRemoved(BeforePackageRemovedEvent event) {
            ++this.beforePackageRemoved;
        }

        protected int getAfterPackageRemoved() {
            return this.afterPackageRemoved;
        }

        protected int getBeforePackageRemoved() {
            return this.beforePackageRemoved;
        }

        public int getAfterRuleAdded() {
            return this.afterRuleAdded;
        }

        public int getBeforeRuleAdded() {
            return this.beforeRuleAdded;
        }

        public void afterRuleAdded(AfterRuleAddedEvent event) {
            ++this.afterRuleAdded;
        }

        public void beforeRuleAdded(BeforeRuleAddedEvent event) {
            ++this.beforeRuleAdded;
        }

        public int getAfterRuleRemoved() {
            return this.afterRuleRemoved;
        }

        public int getBeforeRuleRemoved() {
            return this.beforeRuleRemoved;
        }

        public void afterRuleRemoved(AfterRuleRemovedEvent event) {
            ++this.afterRuleRemoved;
        }

        public void beforeRuleRemoved(BeforeRuleRemovedEvent event) {
            ++this.beforeRuleRemoved;
        }

        public void afterFunctionRemoved(AfterFunctionRemovedEvent event) {
        }

        public void afterRuleBaseLocked(AfterRuleBaseLockedEvent event) {
        }

        public void afterRuleBaseUnlocked(AfterRuleBaseUnlockedEvent event) {
        }

        public void beforeFunctionRemoved(BeforeFunctionRemovedEvent event) {
        }

        public void beforeRuleBaseLocked(BeforeRuleBaseLockedEvent event) {
        }

        public void beforeRuleBaseUnlocked(BeforeRuleBaseUnlockedEvent event) {
        }

        public void beforeProcessAdded(BeforeProcessAddedEvent event) {
        }

        public void afterProcessAdded(AfterProcessAddedEvent event) {
        }

        public void beforeProcessRemoved(BeforeProcessRemovedEvent event) {
        }

        public void afterProcessRemoved(AfterProcessRemovedEvent event) {
        }
    }
}

