/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.drools.time.impl.CronExpression;
import org.drools.time.impl.SerializationTestSupport;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CronExpressionTest
extends SerializationTestSupport {
    private static final String[] VERSIONS = new String[]{"1.5.2"};
    private static final TimeZone EST_TIME_ZONE = TimeZone.getTimeZone("US/Eastern");

    protected Object getTargetObject() throws ParseException {
        CronExpression cronExpression = new CronExpression("0 15 10 * * ? 2005");
        cronExpression.setTimeZone(EST_TIME_ZONE);
        return cronExpression;
    }

    protected String[] getVersions() {
        return VERSIONS;
    }

    protected void verifyMatch(Object target, Object deserialized) {
        CronExpression targetCronExpression = (CronExpression)target;
        CronExpression deserializedCronExpression = (CronExpression)deserialized;
        Assert.assertNotNull((Object)deserializedCronExpression);
        Assert.assertEquals((Object)targetCronExpression.getCronExpression(), (Object)deserializedCronExpression.getCronExpression());
        Assert.assertEquals((Object)targetCronExpression.getTimeZone(), (Object)deserializedCronExpression.getTimeZone());
    }

    @Test
    public void testIsSatisfiedBy() throws Exception {
        CronExpression cronExpression = new CronExpression("0 15 10 * * ? 2005");
        Calendar cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 15, 0);
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(cal.getTime()));
        cal.set(1, 2006);
        Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(cal.getTime()));
        cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 16, 0);
        Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(cal.getTime()));
        cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 14, 0);
        Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(cal.getTime()));
    }

    @Test
    public void testQuartz571() throws Exception {
        CronExpression cronExpression = new CronExpression("19 15 10 4 Apr ? ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(cronExpression);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        CronExpression newExpression = (CronExpression)ois.readObject();
        Assert.assertEquals((Object)newExpression.getCronExpression(), (Object)cronExpression.getCronExpression());
        newExpression.getNextValidTimeAfter(new Date());
    }

    @Test
    public void testQuartz574() {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("* * * * Foo ? ");
            Assert.fail((String)"Expected ParseException did not fire for non-existent month");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Invalid Month value:"));
        }
        try {
            cronExpression = new CronExpression("* * * * Jan-Foo ? ");
            Assert.fail((String)"Expected ParseException did not fire for non-existent month");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Invalid Month value:"));
        }
    }

    @Test
    public void testQuartz621() {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("0 0 * * * *");
            Assert.fail((String)"Expected ParseException did not fire for wildcard day-of-month and day-of-week");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented."));
        }
        try {
            cronExpression = new CronExpression("0 0 * 4 * *");
            Assert.fail((String)"Expected ParseException did not fire for specified day-of-month and wildcard day-of-week");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented."));
        }
        try {
            cronExpression = new CronExpression("0 0 * * * 4");
            Assert.fail((String)"Expected ParseException did not fire for wildcard day-of-month and specified day-of-week");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented."));
        }
    }

    @Test
    public void testQuartz640() throws ParseException {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("0 43 9 1,5,29,L * ?");
            Assert.fail((String)"Expected ParseException did not fire for L combined with other days of the month");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying 'L' and 'LW' with other days of the month is not implemented"));
        }
        try {
            cronExpression = new CronExpression("0 43 9 ? * SAT,SUN,L");
            Assert.fail((String)"Expected ParseException did not fire for L combined with other days of the week");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying 'L' with other days of the week is not implemented"));
        }
        try {
            cronExpression = new CronExpression("0 43 9 ? * 6,7,L");
            Assert.fail((String)"Expected ParseException did not fire for L combined with other days of the week");
        }
        catch (ParseException pe) {
            Assert.assertTrue((String)"Incorrect ParseException thrown", (boolean)pe.getMessage().startsWith("Support for specifying 'L' with other days of the week is not implemented"));
        }
        try {
            cronExpression = new CronExpression("0 43 9 ? * 5L");
        }
        catch (ParseException pe) {
            Assert.fail((String)"Unexpected ParseException thrown for supported '5L' expression.");
        }
    }

    @Test
    @Ignore
    public void testSerialization() {
    }
}

