/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgenda;
import org.drools.core.util.Entry;
import org.drools.core.util.LinkedListNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.time.JobHandle;

public class ScheduledAgendaItem
extends AgendaItem
implements Activation,
Externalizable,
LinkedListNode {
    private static final long serialVersionUID = 510L;
    private LinkedListNode previous;
    private LinkedListNode next;
    private InternalAgenda agenda;
    private boolean enqueued;
    private JobHandle jobHandle;

    public ScheduledAgendaItem(long activationNumber, LeftTuple tuple, InternalAgenda agenda, PropagationContext context, RuleTerminalNode rtn) {
        super(activationNumber, tuple, 0, context, rtn);
        this.agenda = agenda;
        this.enqueued = false;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.agenda = (InternalAgenda)in.readObject();
        this.enqueued = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.agenda);
        out.writeBoolean(this.enqueued);
    }

    public LinkedListNode getNext() {
        return this.next;
    }

    public void setNext(LinkedListNode next) {
        this.next = next;
    }

    public void setNext(Entry next) {
        this.next = (LinkedListNode)next;
    }

    public LinkedListNode getPrevious() {
        return this.previous;
    }

    public void setPrevious(LinkedListNode previous) {
        this.previous = previous;
    }

    public void remove() {
        this.agenda.removeScheduleItem(this);
    }

    public JobHandle getJobHandle() {
        return this.jobHandle;
    }

    public void setJobHandle(JobHandle jobHandle) {
        this.jobHandle = jobHandle;
    }

    public String toString() {
        return "[ScheduledActivation rule=" + this.getRule().getName() + ", tuple=" + this.getTuple() + "]";
    }

    public boolean isEnqueued() {
        return this.enqueued;
    }

    public void setEnqueued(boolean enqueued) {
        this.enqueued = enqueued;
    }
}

